/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda.ui;

import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import net.sf.memoranda.ui.ExceptionDialog;
import net.sf.memoranda.ui.TaskDialog;
import net.sf.memoranda.util.Configuration;
import net.sf.memoranda.util.Local;

public class EventNotificationDialog
extends JFrame {
    JPanel panel1 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JButton jButton1 = new JButton();
    Border border1;
    Border border2;
    Border border3;
    JPanel jPanel1 = new JPanel();
    JLabel textLabel = new JLabel();
    JLabel timeLabel = new JLabel();
    Border border4;

    public EventNotificationDialog(String string, String string2, String string3) {
        this.setTitle(string);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception exception) {
            new ExceptionDialog(exception);
        }
        this.timeLabel.setText(string2);
        this.timeLabel.setIcon(new ImageIcon(TaskDialog.class.getResource("resources/icons/event48.png")));
        this.textLabel.setText(string3);
        this.setSize(300, 200);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        this.toFront();
        this.requestFocus();
    }

    public EventNotificationDialog() {
        this("", "", "");
    }

    void jbInit() throws Exception {
        this.setResizable(false);
        this.setIconImage(new ImageIcon(EventNotificationDialog.class.getResource("resources/icons/jnotes16.png")).getImage());
        this.getContentPane().setBackground(new Color(251, 197, 63));
        this.border2 = BorderFactory.createEmptyBorder(0, 30, 0, 30);
        this.border3 = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), BorderFactory.createEmptyBorder(0, 30, 0, 30));
        this.border4 = BorderFactory.createEmptyBorder(10, 10, 0, 10);
        this.panel1.setLayout(this.borderLayout1);
        this.panel1.setBackground(new Color(251, 197, 63));
        this.jButton1.setText(Local.getString("Ok"));
        this.jButton1.setBounds(150, 415, 95, 30);
        this.jButton1.setPreferredSize(new Dimension(95, 30));
        this.jButton1.setBackground(new Color(69, 125, 186));
        this.jButton1.setForeground(Color.white);
        this.jButton1.setDefaultCapable(true);
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EventNotificationDialog.this.jButton1_actionPerformed(actionEvent);
            }
        });
        this.panel1.setBorder(this.border4);
        this.panel1.setMinimumSize(new Dimension(300, 200));
        this.panel1.setPreferredSize(new Dimension(300, 200));
        this.timeLabel.setFont(new Font("Dialog", 0, 20));
        this.timeLabel.setHorizontalAlignment(0);
        this.textLabel.setHorizontalAlignment(0);
        this.getContentPane().add(this.panel1);
        this.panel1.add((Component)this.jPanel1, "South");
        this.jPanel1.add((Component)this.jButton1, null);
        this.jPanel1.setBackground(new Color(251, 197, 63));
        this.panel1.add((Component)this.textLabel, "Center");
        this.panel1.add((Component)this.timeLabel, "North");
        this.playSoundNotification();
    }

    void jButton1_actionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    private void playSoundNotification() {
        URL uRL;
        if (Configuration.get("NOTIFY_SOUND").equals("DISABLED")) {
            return;
        }
        if (Configuration.get("NOTIFY_SOUND").equals("BEEP")) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        if (Configuration.get("NOTIFY_SOUND").equals("")) {
            Configuration.put("NOTIFY_SOUND", "DEFAULT");
            Configuration.saveConfig();
        }
        if (Configuration.get("NOTIFY_SOUND").equals("DEFAULT")) {
            uRL = EventNotificationDialog.class.getResource("resources/beep.wav");
        } else {
            try {
                uRL = new File(Configuration.get("NOTIFY_SOUND").toString()).toURL();
            }
            catch (Exception exception) {
                uRL = EventNotificationDialog.class.getResource("resources/beep.wav");
            }
        }
        try {
            AudioClip audioClip = Applet.newAudioClip(uRL);
            audioClip.play();
        }
        catch (Exception exception) {
            new ExceptionDialog(exception, "Error loading audioclip from " + uRL, "Check the location and type of audioclip file.");
        }
    }
}

