/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.memoranda.Event;
import net.sf.memoranda.EventsManager;
import net.sf.memoranda.EventsScheduler;
import net.sf.memoranda.History;
import net.sf.memoranda.date.CalendarDate;
import net.sf.memoranda.date.CurrentDate;
import net.sf.memoranda.date.DateListener;
import net.sf.memoranda.ui.App;
import net.sf.memoranda.ui.AppFrame;
import net.sf.memoranda.ui.DailyItemsPanel;
import net.sf.memoranda.ui.EventDialog;
import net.sf.memoranda.ui.EventsTable;
import net.sf.memoranda.ui.ExceptionDialog;
import net.sf.memoranda.util.Configuration;
import net.sf.memoranda.util.CurrentStorage;
import net.sf.memoranda.util.Local;
import net.sf.memoranda.util.Util;

public class EventsPanel
extends JPanel {
    BorderLayout borderLayout1 = new BorderLayout();
    JButton historyBackB = new JButton();
    JToolBar eventsToolBar = new JToolBar();
    JButton historyForwardB = new JButton();
    JButton newEventB = new JButton();
    JButton editEventB = new JButton();
    JButton removeEventB = new JButton();
    JScrollPane scrollPane = new JScrollPane();
    EventsTable eventsTable = new EventsTable();
    JPopupMenu eventPPMenu = new JPopupMenu();
    JMenuItem ppEditEvent = new JMenuItem();
    JMenuItem ppRemoveEvent = new JMenuItem();
    JMenuItem ppNewEvent = new JMenuItem();
    DailyItemsPanel parentPanel = null;

    public EventsPanel(DailyItemsPanel dailyItemsPanel) {
        try {
            this.parentPanel = dailyItemsPanel;
            this.jbInit();
        }
        catch (Exception exception) {
            new ExceptionDialog(exception);
        }
    }

    void jbInit() throws Exception {
        this.eventsToolBar.setFloatable(false);
        this.historyBackB.setAction(History.historyBackAction);
        this.historyBackB.setFocusable(false);
        this.historyBackB.setBorderPainted(false);
        this.historyBackB.setToolTipText(Local.getString("History back"));
        this.historyBackB.setRequestFocusEnabled(false);
        this.historyBackB.setPreferredSize(new Dimension(24, 24));
        this.historyBackB.setMinimumSize(new Dimension(24, 24));
        this.historyBackB.setMaximumSize(new Dimension(24, 24));
        this.historyBackB.setText("");
        this.historyForwardB.setAction(History.historyForwardAction);
        this.historyForwardB.setBorderPainted(false);
        this.historyForwardB.setFocusable(false);
        this.historyForwardB.setPreferredSize(new Dimension(24, 24));
        this.historyForwardB.setRequestFocusEnabled(false);
        this.historyForwardB.setToolTipText(Local.getString("History forward"));
        this.historyForwardB.setMinimumSize(new Dimension(24, 24));
        this.historyForwardB.setMaximumSize(new Dimension(24, 24));
        this.historyForwardB.setText("");
        this.newEventB.setIcon(new ImageIcon(AppFrame.class.getResource("resources/icons/event_new.png")));
        this.newEventB.setEnabled(true);
        this.newEventB.setMaximumSize(new Dimension(24, 24));
        this.newEventB.setMinimumSize(new Dimension(24, 24));
        this.newEventB.setToolTipText(Local.getString("New event"));
        this.newEventB.setRequestFocusEnabled(false);
        this.newEventB.setPreferredSize(new Dimension(24, 24));
        this.newEventB.setFocusable(false);
        this.newEventB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EventsPanel.this.newEventB_actionPerformed(actionEvent);
            }
        });
        this.newEventB.setBorderPainted(false);
        this.editEventB.setBorderPainted(false);
        this.editEventB.setFocusable(false);
        this.editEventB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EventsPanel.this.editEventB_actionPerformed(actionEvent);
            }
        });
        this.editEventB.setPreferredSize(new Dimension(24, 24));
        this.editEventB.setRequestFocusEnabled(false);
        this.editEventB.setToolTipText(Local.getString("Edit event"));
        this.editEventB.setMinimumSize(new Dimension(24, 24));
        this.editEventB.setMaximumSize(new Dimension(24, 24));
        this.editEventB.setEnabled(true);
        this.editEventB.setIcon(new ImageIcon(AppFrame.class.getResource("resources/icons/event_edit.png")));
        this.removeEventB.setBorderPainted(false);
        this.removeEventB.setFocusable(false);
        this.removeEventB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EventsPanel.this.removeEventB_actionPerformed(actionEvent);
            }
        });
        this.removeEventB.setPreferredSize(new Dimension(24, 24));
        this.removeEventB.setRequestFocusEnabled(false);
        this.removeEventB.setToolTipText(Local.getString("Remove event"));
        this.removeEventB.setMinimumSize(new Dimension(24, 24));
        this.removeEventB.setMaximumSize(new Dimension(24, 24));
        this.removeEventB.setIcon(new ImageIcon(AppFrame.class.getResource("resources/icons/event_remove.png")));
        this.setLayout(this.borderLayout1);
        this.scrollPane.getViewport().setBackground(Color.white);
        this.eventsTable.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.eventsTable.setRowHeight(24);
        this.eventPPMenu.setFont(new Font("Dialog", 1, 10));
        this.ppEditEvent.setFont(new Font("Dialog", 1, 11));
        this.ppEditEvent.setText(Local.getString("Edit event") + "...");
        this.ppEditEvent.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EventsPanel.this.ppEditEvent_actionPerformed(actionEvent);
            }
        });
        this.ppEditEvent.setEnabled(false);
        this.ppEditEvent.setIcon(new ImageIcon(AppFrame.class.getResource("resources/icons/event_edit.png")));
        this.ppRemoveEvent.setFont(new Font("Dialog", 1, 11));
        this.ppRemoveEvent.setText(Local.getString("Remove event"));
        this.ppRemoveEvent.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EventsPanel.this.ppRemoveEvent_actionPerformed(actionEvent);
            }
        });
        this.ppRemoveEvent.setIcon(new ImageIcon(AppFrame.class.getResource("resources/icons/event_remove.png")));
        this.ppRemoveEvent.setEnabled(false);
        this.ppNewEvent.setFont(new Font("Dialog", 1, 11));
        this.ppNewEvent.setText(Local.getString("New event") + "...");
        this.ppNewEvent.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EventsPanel.this.ppNewEvent_actionPerformed(actionEvent);
            }
        });
        this.ppNewEvent.setIcon(new ImageIcon(AppFrame.class.getResource("resources/icons/event_new.png")));
        this.scrollPane.getViewport().add((Component)this.eventsTable, null);
        this.add((Component)this.scrollPane, "Center");
        this.eventsToolBar.add((Component)this.historyBackB, null);
        this.eventsToolBar.add((Component)this.historyForwardB, null);
        this.eventsToolBar.addSeparator(new Dimension(8, 24));
        this.eventsToolBar.add((Component)this.newEventB, null);
        this.eventsToolBar.add((Component)this.removeEventB, null);
        this.eventsToolBar.addSeparator(new Dimension(8, 24));
        this.eventsToolBar.add((Component)this.editEventB, null);
        this.add((Component)this.eventsToolBar, "North");
        PopupListener popupListener = new PopupListener();
        this.scrollPane.addMouseListener(popupListener);
        this.eventsTable.addMouseListener(popupListener);
        CurrentDate.addDateListener(new DateListener(){

            public void dateChange(CalendarDate calendarDate) {
                EventsPanel.this.eventsTable.initTable(calendarDate);
                boolean bl = calendarDate.after(CalendarDate.today()) || calendarDate.equals(CalendarDate.today());
                EventsPanel.this.newEventB.setEnabled(bl);
                EventsPanel.this.ppNewEvent.setEnabled(bl);
                EventsPanel.this.editEventB.setEnabled(false);
                EventsPanel.this.ppEditEvent.setEnabled(false);
                EventsPanel.this.removeEventB.setEnabled(false);
                EventsPanel.this.ppRemoveEvent.setEnabled(false);
            }
        });
        this.eventsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                boolean bl = EventsPanel.this.eventsTable.getSelectedRow() > -1;
                EventsPanel.this.editEventB.setEnabled(bl);
                EventsPanel.this.ppEditEvent.setEnabled(bl);
                EventsPanel.this.removeEventB.setEnabled(bl);
                EventsPanel.this.ppRemoveEvent.setEnabled(bl);
            }
        });
        this.editEventB.setEnabled(false);
        this.removeEventB.setEnabled(false);
        this.eventPPMenu.add(this.ppEditEvent);
        this.eventPPMenu.addSeparator();
        this.eventPPMenu.add(this.ppNewEvent);
        this.eventPPMenu.add(this.ppRemoveEvent);
        this.eventsTable.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (EventsPanel.this.eventsTable.getSelectedRows().length > 0 && keyEvent.getKeyCode() == 127) {
                    EventsPanel.this.ppRemoveEvent_actionPerformed(null);
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
            }
        });
    }

    void editEventB_actionPerformed(ActionEvent actionEvent) {
        EventDialog eventDialog = new EventDialog((Frame)App.getFrame(), Local.getString("Event"));
        Event event = (Event)this.eventsTable.getModel().getValueAt(this.eventsTable.getSelectedRow(), 100);
        eventDialog.timeSpin.getModel().setValue(event.getTime());
        eventDialog.textField.setText(event.getText());
        int n = event.getRepeat();
        if (n > 0) {
            eventDialog.startDate.getModel().setValue(event.getStartDate().getDate());
            if (n == 1) {
                eventDialog.dailyRepeatRB.setSelected(true);
                eventDialog.dailyRepeatRB_actionPerformed(null);
                eventDialog.daySpin.setValue(new Integer(event.getPeriod()));
            } else if (n == 2) {
                eventDialog.weeklyRepeatRB.setSelected(true);
                eventDialog.weeklyRepeatRB_actionPerformed(null);
                int n2 = event.getPeriod() - 1;
                if (Configuration.get("FIRST_DAY_OF_WEEK").equals("mon") && --n2 < 0) {
                    n2 = 6;
                }
                eventDialog.weekdaysCB.setSelectedIndex(n2);
            } else if (n == 3) {
                eventDialog.monthlyRepeatRB.setSelected(true);
                eventDialog.monthlyRepeatRB_actionPerformed(null);
                eventDialog.dayOfMonthSpin.setValue(new Integer(event.getPeriod()));
            } else if (n == 4) {
                eventDialog.yearlyRepeatRB.setSelected(true);
                eventDialog.yearlyRepeatRB_actionPerformed(null);
                eventDialog.dayOfMonthSpin.setValue(new Integer(event.getPeriod()));
            }
            if (event.getEndDate() != null) {
                eventDialog.endDate.getModel().setValue(event.getEndDate().getDate());
                eventDialog.enableEndDateCB.setSelected(true);
                eventDialog.enableEndDateCB_actionPerformed(null);
            }
            if (event.getWorkingDays()) {
                eventDialog.workingDaysOnlyCB.setSelected(true);
            }
        }
        Dimension dimension = App.getFrame().getSize();
        Point point = App.getFrame().getLocation();
        eventDialog.setLocation((dimension.width - eventDialog.getSize().width) / 2 + point.x, (dimension.height - eventDialog.getSize().height) / 2 + point.y);
        eventDialog.setVisible(true);
        if (eventDialog.CANCELLED) {
            return;
        }
        EventsManager.removeEvent(event);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(Local.getCurrentLocale());
        gregorianCalendar.setTime((Date)eventDialog.timeSpin.getModel().getValue());
        int n3 = gregorianCalendar.get(11);
        int n4 = gregorianCalendar.get(12);
        String string = eventDialog.textField.getText();
        if (eventDialog.noRepeatRB.isSelected()) {
            EventsManager.createEvent(CurrentDate.get(), n3, n4, string);
        } else {
            this.updateEvents(eventDialog, n3, n4, string);
        }
        this.saveEvents();
    }

    void newEventB_actionPerformed(ActionEvent actionEvent) {
        Calendar calendar = CurrentDate.get().getCalendar();
        calendar.set(12, 0);
        Util.debug("Default time is " + calendar);
        this.newEventB_actionPerformed(actionEvent, null, calendar.getTime(), calendar.getTime());
    }

    void newEventB_actionPerformed(ActionEvent actionEvent, String string, Date date, Date date2) {
        EventDialog eventDialog = new EventDialog((Frame)App.getFrame(), Local.getString("New event"));
        Dimension dimension = App.getFrame().getSize();
        Point point = App.getFrame().getLocation();
        if (string != null) {
            eventDialog.textField.setText(string);
        }
        eventDialog.startDate.getModel().setValue(date);
        eventDialog.endDate.getModel().setValue(date2);
        eventDialog.timeSpin.getModel().setValue(date);
        eventDialog.setLocation((dimension.width - eventDialog.getSize().width) / 2 + point.x, (dimension.height - eventDialog.getSize().height) / 2 + point.y);
        eventDialog.setEventDate(date);
        eventDialog.setVisible(true);
        if (eventDialog.CANCELLED) {
            return;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(Local.getCurrentLocale());
        gregorianCalendar.setTime((Date)eventDialog.timeSpin.getModel().getValue());
        int n = gregorianCalendar.get(11);
        int n2 = gregorianCalendar.get(12);
        String string2 = eventDialog.textField.getText();
        CalendarDate calendarDate = new CalendarDate(eventDialog.getEventDate());
        if (eventDialog.noRepeatRB.isSelected()) {
            EventsManager.createEvent(calendarDate, n, n2, string2);
        } else {
            this.updateEvents(eventDialog, n, n2, string2);
        }
        this.saveEvents();
    }

    private void saveEvents() {
        CurrentStorage.get().storeEventsManager();
        this.eventsTable.refresh();
        EventsScheduler.init();
        this.parentPanel.calendar.jnCalendar.updateUI();
        this.parentPanel.updateIndicators();
    }

    private void updateEvents(EventDialog eventDialog, int n, int n2, String string) {
        int n3;
        int n4;
        CalendarDate calendarDate = new CalendarDate((Date)eventDialog.startDate.getModel().getValue());
        CalendarDate calendarDate2 = null;
        if (eventDialog.enableEndDateCB.isSelected()) {
            calendarDate2 = new CalendarDate((Date)eventDialog.endDate.getModel().getValue());
        }
        if (eventDialog.dailyRepeatRB.isSelected()) {
            n4 = 1;
            n3 = (Integer)eventDialog.daySpin.getModel().getValue();
        } else if (eventDialog.weeklyRepeatRB.isSelected()) {
            n4 = 2;
            n3 = eventDialog.weekdaysCB.getSelectedIndex() + 1;
            if (Configuration.get("FIRST_DAY_OF_WEEK").equals("mon")) {
                n3 = n3 == 7 ? 1 : ++n3;
            }
        } else if (eventDialog.yearlyRepeatRB.isSelected()) {
            n4 = 4;
            n3 = calendarDate.getCalendar().get(6);
            if (calendarDate.getYear() % 4 == 0 && calendarDate.getCalendar().get(6) > 60) {
                --n3;
            }
        } else {
            n4 = 3;
            n3 = (Integer)eventDialog.dayOfMonthSpin.getModel().getValue();
        }
        EventsManager.createRepeatableEvent(n4, calendarDate, calendarDate2, n3, n, n2, string, eventDialog.workingDaysOnlyCB.isSelected());
    }

    void removeEventB_actionPerformed(ActionEvent actionEvent) {
        Event event;
        String string;
        if (this.eventsTable.getSelectedRows().length > 1) {
            string = Local.getString("Remove") + " " + this.eventsTable.getSelectedRows().length + " " + Local.getString("events") + "\n" + Local.getString("Are you sure?");
        } else {
            event = (Event)this.eventsTable.getModel().getValueAt(this.eventsTable.getSelectedRow(), 100);
            string = Local.getString("Remove event") + "\n'" + event.getText() + "'\n" + Local.getString("Are you sure?");
        }
        int n = JOptionPane.showConfirmDialog(App.getFrame(), string, Local.getString("Remove event"), 0);
        if (n != 0) {
            return;
        }
        for (int i = 0; i < this.eventsTable.getSelectedRows().length; ++i) {
            event = (Event)this.eventsTable.getModel().getValueAt(this.eventsTable.getSelectedRows()[i], 100);
            EventsManager.removeEvent(event);
        }
        this.eventsTable.getSelectionModel().clearSelection();
        this.saveEvents();
    }

    void ppEditEvent_actionPerformed(ActionEvent actionEvent) {
        this.editEventB_actionPerformed(actionEvent);
    }

    void ppRemoveEvent_actionPerformed(ActionEvent actionEvent) {
        this.removeEventB_actionPerformed(actionEvent);
    }

    void ppNewEvent_actionPerformed(ActionEvent actionEvent) {
        this.newEventB_actionPerformed(actionEvent);
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2 && EventsPanel.this.eventsTable.getSelectedRow() > -1) {
                EventsPanel.this.editEventB_actionPerformed(null);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                EventsPanel.this.eventPPMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

