/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.memoranda.CurrentNote;
import net.sf.memoranda.CurrentProject;
import net.sf.memoranda.Note;
import net.sf.memoranda.date.CurrentDate;
import net.sf.memoranda.ui.App;
import net.sf.memoranda.ui.AppFrame;
import net.sf.memoranda.ui.BookmarksPanel;
import net.sf.memoranda.ui.ExceptionDialog;
import net.sf.memoranda.ui.NotesList;
import net.sf.memoranda.ui.NotesListPanel;
import net.sf.memoranda.ui.SearchPanel;
import net.sf.memoranda.util.Configuration;
import net.sf.memoranda.util.CurrentStorage;
import net.sf.memoranda.util.Local;

public class NotesControlPanel
extends JPanel {
    BorderLayout borderLayout1 = new BorderLayout();
    SearchPanel searchPanel = new SearchPanel();
    NotesListPanel notesListPanel = new NotesListPanel();
    BookmarksPanel bookmarksListPanel = new BookmarksPanel();
    JTabbedPane tabbedPane = new JTabbedPane();
    JToolBar toolBar = new JToolBar();
    NotesList notesList = null;
    FlowLayout flowLayout1 = new FlowLayout();
    JButton ppOpenB = new JButton();
    JPanel buttonsPanel = new JPanel();
    JMenuItem ppAddBkmrk = new JMenuItem();
    JMenuItem ppClearNote = new JMenuItem();
    JCheckBoxMenuItem ppInvertSort = new JCheckBoxMenuItem();
    JPopupMenu notesPPMenu = new JPopupMenu();
    JMenuItem ppOpenNote = new JMenuItem();
    JMenuItem ppRemoveBkmrk = new JMenuItem();

    public NotesControlPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            new ExceptionDialog(exception);
        }
    }

    void jbInit() throws Exception {
        this.tabbedPane.setFont(new Font("Dialog", 1, 10));
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                NotesControlPanel.this.tabbedPane_stateChanged(changeEvent);
            }
        });
        this.tabbedPane.setTabPlacement(3);
        this.setLayout(this.borderLayout1);
        this.toolBar.setRequestFocusEnabled(false);
        this.toolBar.setFloatable(false);
        this.flowLayout1.setAlignment(2);
        this.flowLayout1.setVgap(0);
        this.ppOpenB.setMaximumSize(new Dimension(34, 20));
        this.ppOpenB.setMinimumSize(new Dimension(24, 10));
        this.ppOpenB.setOpaque(false);
        this.ppOpenB.setPreferredSize(new Dimension(24, 20));
        this.ppOpenB.setBorderPainted(false);
        this.ppOpenB.setFocusPainted(false);
        this.ppOpenB.setMargin(new Insets(0, 0, 0, 0));
        this.ppOpenB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NotesControlPanel.this.ppOpenB_actionPerformed(actionEvent);
            }
        });
        this.ppOpenB.setIcon(new ImageIcon(AppFrame.class.getResource("resources/icons/nopen.png")));
        this.buttonsPanel.setMinimumSize(new Dimension(70, 22));
        this.buttonsPanel.setOpaque(false);
        this.buttonsPanel.setRequestFocusEnabled(false);
        this.buttonsPanel.setLayout(this.flowLayout1);
        this.ppAddBkmrk.setFont(new Font("Dialog", 1, 11));
        this.ppAddBkmrk.setText(Local.getString("Set bookmark"));
        this.ppAddBkmrk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NotesControlPanel.this.ppAddBkmrk_actionPerformed(actionEvent);
            }
        });
        this.ppAddBkmrk.setIcon(new ImageIcon(AppFrame.class.getResource("resources/icons/addbookmark.png")));
        this.ppClearNote.setFont(new Font("Dialog", 1, 11));
        this.ppClearNote.setText(Local.getString("Clear note"));
        this.ppClearNote.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NotesControlPanel.this.ppClearNote_actionPerformed(actionEvent);
            }
        });
        this.ppClearNote.setIcon(new ImageIcon(AppFrame.class.getResource("resources/icons/editdelete.png")));
        this.ppClearNote.setEnabled(false);
        this.notesPPMenu.setFont(new Font("Dialog", 1, 10));
        this.ppOpenNote.setFont(new Font("Dialog", 1, 11));
        this.ppOpenNote.setText(Local.getString("Go to note"));
        this.ppOpenNote.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NotesControlPanel.this.ppOpenNote_actionPerformed(actionEvent);
            }
        });
        this.ppOpenNote.setEnabled(false);
        this.ppInvertSort.setFont(new Font("Dialog", 1, 11));
        this.ppInvertSort.setText(Local.getString("Invert Sort Order"));
        this.ppInvertSort.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NotesControlPanel.this.ppInvertSort_actionPerformed(actionEvent);
            }
        });
        this.ppInvertSort.setEnabled(true);
        boolean bl = Configuration.get("NOTES_SORT_ORDER").equals("true");
        this.ppInvertSort.setSelected(bl);
        this.ppRemoveBkmrk.setFont(new Font("Dialog", 1, 11));
        this.ppRemoveBkmrk.setText(Local.getString("Remove bookmark"));
        this.ppRemoveBkmrk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NotesControlPanel.this.ppRemoveBkmrk_actionPerformed(actionEvent);
            }
        });
        this.ppRemoveBkmrk.setIcon(new ImageIcon(AppFrame.class.getResource("resources/icons/removebookmark.png")));
        this.ppRemoveBkmrk.setEnabled(false);
        this.tabbedPane.add((Component)this.notesListPanel, Local.getString("Notes"));
        this.tabbedPane.add((Component)this.bookmarksListPanel, Local.getString("Bookmarks"));
        this.tabbedPane.add((Component)this.searchPanel, Local.getString("Search"));
        this.add((Component)this.toolBar, "North");
        this.buttonsPanel.add((Component)this.ppOpenB, null);
        this.toolBar.add((Component)this.buttonsPanel, null);
        this.toolBar.addSeparator();
        this.add((Component)this.tabbedPane, "Center");
        PopupListener popupListener = new PopupListener();
        this.notesListPanel.notesList.addMouseListener(popupListener);
        this.bookmarksListPanel.notesList.addMouseListener(popupListener);
        this.searchPanel.notesList.addMouseListener(popupListener);
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                NotesControlPanel.this.ppSetEnabled();
            }
        };
        this.notesListPanel.notesList.getSelectionModel().addListSelectionListener(listSelectionListener);
        this.bookmarksListPanel.notesList.getSelectionModel().addListSelectionListener(listSelectionListener);
        this.searchPanel.notesList.getSelectionModel().addListSelectionListener(listSelectionListener);
        this.notesList = this.notesListPanel.notesList;
        this.notesPPMenu.add(this.ppOpenNote);
        this.notesPPMenu.add(this.ppInvertSort);
        this.notesPPMenu.addSeparator();
        this.notesPPMenu.add(this.ppAddBkmrk);
        this.notesPPMenu.add(this.ppRemoveBkmrk);
        this.notesPPMenu.addSeparator();
        this.notesPPMenu.add(this.ppClearNote);
        KeyListener keyListener = new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 127) {
                    NotesControlPanel.this.ppClearNote_actionPerformed(null);
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
            }
        };
        this.notesListPanel.notesList.addKeyListener(keyListener);
        this.bookmarksListPanel.notesList.addKeyListener(keyListener);
        this.searchPanel.notesList.addKeyListener(keyListener);
    }

    public void refresh() {
        this.notesListPanel.notesList.update();
        this.bookmarksListPanel.notesList.update();
    }

    void tabbedPane_stateChanged(ChangeEvent changeEvent) {
        if (this.notesList != null) {
            this.notesList.clearSelection();
        }
        switch (this.tabbedPane.getSelectedIndex()) {
            case 0: {
                this.notesList = this.notesListPanel.notesList;
                break;
            }
            case 1: {
                this.notesList = this.bookmarksListPanel.notesList;
                break;
            }
            case 2: {
                this.notesList = this.searchPanel.notesList;
            }
        }
        this.ppAddBkmrk.setEnabled(false);
        this.ppRemoveBkmrk.setEnabled(false);
    }

    void setActiveNote() {
        Note note = this.notesList.getNote(this.notesList.getSelectedIndex());
        CurrentDate.set(note.getDate());
        CurrentNote.set(note, true);
    }

    void ppOpenB_actionPerformed(ActionEvent actionEvent) {
        this.notesPPMenu.show(this.toolBar, (int)this.ppOpenB.getLocation().getX(), (int)this.ppOpenB.getLocation().getY() + 24);
    }

    void ppAddBkmrk_actionPerformed(ActionEvent actionEvent) {
        for (int i = 0; i < this.notesList.getSelectedIndices().length; ++i) {
            Note note = this.notesList.getNote(this.notesList.getSelectedIndices()[i]);
            note.setMark(true);
        }
        this.notesList.updateUI();
        this.bookmarksListPanel.notesList.update();
        this.ppSetEnabled();
    }

    void ppClearNote_actionPerformed(ActionEvent actionEvent) {
        String string = this.notesList.getSelectedIndices().length > 1 ? Local.getString(Local.getString("Clear")) + " " + this.notesList.getSelectedIndices().length + " " + Local.getString("notes") + "\n" + Local.getString("Are you sure?") : Local.getString("Clear note") + "\n'" + this.notesList.getNote(this.notesList.getSelectedIndex()).getDate().getFullDateString() + "'\n" + Local.getString("Are you sure?");
        int n = JOptionPane.showConfirmDialog(App.getFrame(), string, Local.getString("Clear note"), 0);
        if (n != 0) {
            return;
        }
        for (int i = 0; i < this.notesList.getSelectedIndices().length; ++i) {
            Note note = this.notesList.getNote(this.notesList.getSelectedIndices()[i]);
            if (CurrentProject.getNoteList().getActiveNote() != null && note.getDate().equals(CurrentProject.getNoteList().getActiveNote().getDate())) {
                System.out.println("[DEBUG] Current note removed");
                CurrentNote.set(null, true);
            }
            CurrentProject.getNoteList().removeNote(note.getDate(), note.getId());
            CurrentStorage.get().removeNote(note);
        }
        this.bookmarksListPanel.notesList.update();
        this.searchPanel.notesList.update();
        this.notesListPanel.notesList.update();
        this.notesList.updateUI();
        this.notesList.clearSelection();
    }

    void ppOpenNote_actionPerformed(ActionEvent actionEvent) {
        this.setActiveNote();
    }

    void ppInvertSort_actionPerformed(ActionEvent actionEvent) {
        Configuration.put("NOTES_SORT_ORDER", new Boolean(this.ppInvertSort.isSelected()));
        Configuration.saveConfig();
        this.notesList.invertSortOrder();
        this.notesList.update();
    }

    void ppRemoveBkmrk_actionPerformed(ActionEvent actionEvent) {
        for (int i = 0; i < this.notesList.getSelectedIndices().length; ++i) {
            Note note = this.notesList.getNote(this.notesList.getSelectedIndices()[i]);
            note.setMark(false);
        }
        this.bookmarksListPanel.notesList.update();
        this.ppSetEnabled();
        this.notesList.updateUI();
        this.notesList.clearSelection();
        App.getFrame().workPanel.dailyItemsPanel.editorPanel.editor.requestFocus();
    }

    void ppSetEnabled() {
        boolean bl = this.notesList.getModel().getSize() > 0 && this.notesList.getSelectedIndex() > -1;
        this.ppRemoveBkmrk.setEnabled(bl && this.notesList.getNote(this.notesList.getSelectedIndex()).isMarked() || this.notesList.getSelectedIndices().length > 1);
        this.ppAddBkmrk.setEnabled(bl && !this.notesList.getNote(this.notesList.getSelectedIndex()).isMarked() || this.notesList.getSelectedIndices().length > 1);
        this.ppOpenNote.setEnabled(bl);
        this.ppClearNote.setEnabled(bl);
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                NotesControlPanel.this.setActiveNote();
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                NotesControlPanel.this.notesPPMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

