/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.Document;
import net.sf.memoranda.CurrentProject;
import net.sf.memoranda.Note;
import net.sf.memoranda.NoteList;
import net.sf.memoranda.Project;
import net.sf.memoranda.ProjectListener;
import net.sf.memoranda.ResourcesList;
import net.sf.memoranda.TaskList;
import net.sf.memoranda.ui.App;
import net.sf.memoranda.ui.ExceptionDialog;
import net.sf.memoranda.ui.NotesList;
import net.sf.memoranda.util.CurrentStorage;
import net.sf.memoranda.util.Local;

public class SearchPanel
extends JPanel {
    BorderLayout borderLayout1 = new BorderLayout();
    NotesList notesList = new NotesList(0);
    JScrollPane scrollPane = new JScrollPane();
    JPanel jPanel1 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JTextField searchField = new JTextField();
    JPanel jPanel2 = new JPanel();
    BorderLayout borderLayout3 = new BorderLayout();
    Border border1;
    TitledBorder titledBorder1;
    JPanel jPanel3 = new JPanel();
    JPanel jPanel4 = new JPanel();
    JCheckBox caseSensCB = new JCheckBox();
    JCheckBox regexpCB = new JCheckBox();
    JCheckBox wholeWCB = new JCheckBox();
    JButton searchB = new JButton();
    BorderLayout borderLayout4 = new BorderLayout();
    BorderLayout borderLayout5 = new BorderLayout();
    JProgressBar progressBar = new JProgressBar();
    Cursor waitCursor = new Cursor(3);

    public SearchPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            new ExceptionDialog(exception);
        }
    }

    void jbInit() throws Exception {
        this.border1 = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        this.titledBorder1 = new TitledBorder(BorderFactory.createEmptyBorder(), Local.getString("Search") + ":");
        this.setLayout(this.borderLayout1);
        this.jPanel1.setLayout(this.borderLayout2);
        this.jPanel2.setLayout(this.borderLayout3);
        this.jPanel2.setBorder(this.titledBorder1);
        this.titledBorder1.setTitleFont(new Font("Dialog", 1, 11));
        this.searchField.setFont(new Font("Dialog", 1, 10));
        this.searchField.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                SearchPanel.this.searchField_caretUpdate(caretEvent);
            }
        });
        this.jPanel3.setLayout(this.borderLayout5);
        this.caseSensCB.setText(Local.getString("Case sensitive"));
        this.caseSensCB.setFont(new Font("Dialog", 1, 10));
        this.caseSensCB.setMargin(new Insets(0, 0, 0, 0));
        this.regexpCB.setFont(new Font("Dialog", 1, 10));
        this.regexpCB.setMargin(new Insets(0, 0, 0, 0));
        this.regexpCB.setText(Local.getString("Regular expressions"));
        this.wholeWCB.setText(Local.getString("Whole words only"));
        this.wholeWCB.setMargin(new Insets(0, 0, 0, 0));
        this.wholeWCB.setFont(new Font("Dialog", 1, 10));
        this.searchB.setEnabled(false);
        this.searchB.setFont(new Font("Dialog", 1, 11));
        this.searchB.setMaximumSize(new Dimension(72, 25));
        this.searchB.setMinimumSize(new Dimension(2, 25));
        this.searchB.setPreferredSize(new Dimension(70, 25));
        this.searchB.setMargin(new Insets(0, 0, 0, 0));
        this.searchB.setText(Local.getString("Search"));
        this.searchB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchPanel.this.searchB_actionPerformed(actionEvent);
            }
        });
        this.jPanel4.setLayout(this.borderLayout4);
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)this.jPanel1, "North");
        this.scrollPane.getViewport().add(this.notesList);
        this.jPanel1.add((Component)this.jPanel2, "North");
        this.jPanel2.add((Component)this.searchField, "Center");
        this.jPanel1.add((Component)this.jPanel3, "Center");
        this.jPanel3.add((Component)this.jPanel4, "North");
        this.jPanel4.add((Component)this.caseSensCB, "South");
        this.jPanel4.add((Component)this.wholeWCB, "North");
        this.jPanel4.add((Component)this.regexpCB, "Center");
        this.jPanel3.add((Component)this.searchB, "South");
        CurrentProject.addProjectListener(new ProjectListener(){

            public void projectChange(Project project, NoteList noteList, TaskList taskList, ResourcesList resourcesList) {
                SearchPanel.this.notesList.update(new Vector());
            }

            public void projectWasChanged() {
            }
        });
    }

    void searchB_actionPerformed(ActionEvent actionEvent) {
        Cursor cursor = App.getFrame().getCursor();
        App.getFrame().setCursor(this.waitCursor);
        this.doSearch();
        App.getFrame().setCursor(cursor);
    }

    void searchField_caretUpdate(CaretEvent caretEvent) {
        this.searchB.setEnabled(this.searchField.getText().length() > 0);
    }

    void doSearch() {
        Pattern pattern;
        int n = 32;
        if (!this.caseSensCB.isSelected()) {
            n = n + 2 + 64;
        }
        String string = this.searchField.getText();
        if (!this.regexpCB.isSelected()) {
            string = "\\Q" + string + "\\E";
        }
        if (this.wholeWCB.isSelected()) {
            string = "[\\s\\p{Punct}]" + string + "[\\s\\p{Punct}]";
        }
        try {
            pattern = Pattern.compile(string, n);
        }
        catch (Exception exception) {
            new ExceptionDialog(exception, "Error in regular expression", "Check the regular expression syntax");
            return;
        }
        Vector vector = (Vector)CurrentProject.getNoteList().getAllNotes();
        Vector<Note> vector2 = new Vector<Note>();
        for (int i = 0; i < vector.size(); ++i) {
            Note note = (Note)vector.get(i);
            Document document = CurrentStorage.get().openNote(note);
            try {
                String string2 = document.getText(0, document.getLength());
                Matcher matcher = pattern.matcher(string2);
                if (!matcher.find()) continue;
                vector2.add(note);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.notesList.update(vector2);
    }
}

