/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda.ui;

import javax.swing.event.EventListenerList;
import net.sf.memoranda.CurrentProject;
import net.sf.memoranda.Project;
import net.sf.memoranda.Task;
import net.sf.memoranda.date.CurrentDate;
import net.sf.memoranda.ui.TaskTable;
import net.sf.memoranda.ui.treetable.AbstractTreeTableModel;
import net.sf.memoranda.ui.treetable.TreeTableModel;
import net.sf.memoranda.util.Context;
import net.sf.memoranda.util.Local;

public class TaskTableModel
extends AbstractTreeTableModel
implements TreeTableModel {
    String[] columnNames = new String[]{"", Local.getString("To-do"), Local.getString("Start date"), Local.getString("End date"), Local.getString("Priority"), Local.getString("Status"), "% " + Local.getString("done")};
    protected EventListenerList listenerList = new EventListenerList();
    private boolean activeOnly = TaskTableModel.check_activeOnly();

    public TaskTableModel() {
        super(CurrentProject.get());
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public Object getValueAt(Object object, int n) {
        if (object instanceof Project) {
            return null;
        }
        Task task = (Task)object;
        switch (n) {
            case 0: {
                return "";
            }
            case 1: {
                return task;
            }
            case 2: {
                return task.getStartDate().getDate();
            }
            case 3: {
                if (task.getEndDate() == null) {
                    return null;
                }
                return task.getEndDate().getDate();
            }
            case 4: {
                return this.getPriorityString(task.getPriority());
            }
            case 5: {
                return this.getStatusString(task.getStatus(CurrentDate.get()));
            }
            case 6: {
                return task;
            }
            case 100: {
                return task.getID();
            }
            case 101: {
                return task;
            }
        }
        return "";
    }

    String getStatusString(int n) {
        switch (n) {
            case 1: {
                return Local.getString("Active");
            }
            case 7: {
                return Local.getString("Deadline");
            }
            case 2: {
                return Local.getString("Completed");
            }
            case 5: {
                return Local.getString("Failed");
            }
            case 4: {
                return Local.getString("Frozen");
            }
            case 6: {
                return Local.getString("Locked");
            }
            case 0: {
                return Local.getString("Scheduled");
            }
        }
        return "";
    }

    String getPriorityString(int n) {
        switch (n) {
            case 2: {
                return Local.getString("Normal");
            }
            case 1: {
                return Local.getString("Low");
            }
            case 0: {
                return Local.getString("Lowest");
            }
            case 3: {
                return Local.getString("High");
            }
            case 4: {
                return Local.getString("Highest");
            }
        }
        return "";
    }

    public int getChildCount(Object object) {
        if (object instanceof Project) {
            if (this.activeOnly()) {
                return CurrentProject.getTaskList().getActiveSubTasks(null, CurrentDate.get()).size();
            }
            return CurrentProject.getTaskList().getTopLevelTasks().size();
        }
        Task task = (Task)object;
        if (this.activeOnly()) {
            return CurrentProject.getTaskList().getActiveSubTasks(task.getID(), CurrentDate.get()).size();
        }
        return task.getSubTasks().size();
    }

    public Object getChild(Object object, int n) {
        if (object instanceof Project) {
            if (this.activeOnly()) {
                return CurrentProject.getTaskList().getActiveSubTasks(null, CurrentDate.get()).toArray()[n];
            }
            return CurrentProject.getTaskList().getTopLevelTasks().toArray()[n];
        }
        Task task = (Task)object;
        if (this.activeOnly()) {
            return CurrentProject.getTaskList().getActiveSubTasks(task.getID(), CurrentDate.get()).toArray()[n];
        }
        return task.getSubTasks().toArray()[n];
    }

    public Class getColumnClass(int n) {
        try {
            switch (n) {
                case 1: {
                    return TreeTableModel.class;
                }
                case 0: {
                    return TaskTable.class;
                }
                case 4: 
                case 5: {
                    return Class.forName("java.lang.String");
                }
                case 2: 
                case 3: {
                    return Class.forName("java.util.Date");
                }
                case 6: {
                    return Class.forName("java.lang.Integer");
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public void fireTreeStructureChanged() {
        this.fireTreeStructureChanged(this, new Object[]{this.getRoot()}, new int[0], new Object[0]);
    }

    public void fireUpdateCache() {
        this.activeOnly = TaskTableModel.check_activeOnly();
    }

    public static boolean check_activeOnly() {
        Object object = Context.get("SHOW_ACTIVE_TASKS_ONLY");
        if (object == null) {
            return false;
        }
        return object.toString().equals("true");
    }

    public boolean activeOnly() {
        return this.activeOnly;
    }

    public boolean isCellEditable(Object object, int n) {
        if (n == 6) {
            return true;
        }
        return super.isCellEditable(object, n);
    }
}

