/*
 * Decompiled with CFR 0.152.
 */
package net.sf.memoranda.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.swing.JOptionPane;
import net.sf.memoranda.Project;
import net.sf.memoranda.ProjectManager;
import net.sf.memoranda.date.CalendarDate;
import net.sf.memoranda.ui.App;
import net.sf.memoranda.ui.ExceptionDialog;
import net.sf.memoranda.util.CurrentStorage;
import net.sf.memoranda.util.Local;
import net.sf.memoranda.util.Util;

public class ProjectPackager {
    private static String JN_DOCPATH = Util.getEnvDir();

    public static void pack(Project project, File file) {
        ZipOutputStream zipOutputStream = null;
        if (file.getName().indexOf(".zip") == -1) {
            file = new File(file.getPath() + ".zip");
        }
        try {
            zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
            File file2 = new File(JN_DOCPATH + project.getID());
            ProjectPackager.PackDirectory(file2.getPath(), file2, zipOutputStream);
            zipOutputStream.putNextEntry(new ZipEntry("__PROJECT_INFO__"));
            String string = project.getID() + "\n" + project.getTitle() + "\n" + project.getStartDate().toString() + "\n";
            if (project.getEndDate() != null) {
                string = string + project.getEndDate().toString();
            }
            zipOutputStream.write(string.getBytes("UTF-8"));
            zipOutputStream.closeEntry();
            zipOutputStream.close();
        }
        catch (Exception exception) {
            new ExceptionDialog(exception, "Failed to write to " + file, "");
        }
    }

    public static void unpack(File file) {
        try {
            ZipFile zipFile = new ZipFile(file);
            ZipEntry zipEntry = zipFile.getEntry("__PROJECT_INFO__");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(zipFile.getInputStream(zipEntry), "UTF-8"));
            String string = bufferedReader.readLine();
            String string2 = bufferedReader.readLine();
            String string3 = bufferedReader.readLine();
            String string4 = bufferedReader.readLine();
            bufferedReader.close();
            if (ProjectManager.getProject(string) != null) {
                int n = JOptionPane.showConfirmDialog(App.getFrame(), Local.getString("This project is already exists and will be replaced.\nContinue?"), Local.getString("Project is already exists"), 0);
                if (n != 0) {
                    zipFile.close();
                    return;
                }
                ProjectManager.removeProject(string);
            }
            Project project = ProjectManager.createProject(string, string2, new CalendarDate(string3), null);
            if (string4 != null) {
                project.setEndDate(new CalendarDate(string4));
            }
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                int n;
                Object object;
                ZipEntry zipEntry2 = enumeration.nextElement();
                if (zipEntry2.isDirectory()) {
                    object = new File(JN_DOCPATH + project.getID() + "/" + zipEntry2.getName());
                    ((File)object).mkdirs();
                    object = null;
                }
                if (zipEntry2.getName().equals("__PROJECT_INFO__") || zipEntry2.isDirectory()) continue;
                object = new FileOutputStream(JN_DOCPATH + project.getID() + "/" + zipEntry2.getName());
                InputStream inputStream = zipFile.getInputStream(zipEntry2);
                byte[] byArray = new byte[1024];
                while ((n = inputStream.read(byArray)) >= 0) {
                    ((FileOutputStream)object).write(byArray, 0, n);
                }
                inputStream.close();
                ((FileOutputStream)object).close();
            }
            zipFile.close();
            CurrentStorage.get().storeProjectManager();
        }
        catch (Exception exception) {
            new ExceptionDialog(exception, "Failed to read from " + file, "Make sure that this file is a Memoranda project archive.");
        }
    }

    public static void PackDirectory(String string, File file, ZipOutputStream zipOutputStream) throws IOException {
        File[] fileArray = file.listFiles();
        File file2 = new File(string);
        System.out.println("Path=" + file2.getPath() + ";length=" + file2.getPath().length() + "==>" + fileArray[0]);
        int n = file2.getPath().length();
        for (int i = 0; i < fileArray.length; ++i) {
            Object object;
            String string2 = fileArray[i].getPath().substring(n);
            if (fileArray[i].isDirectory()) {
                object = new ZipEntry("." + string2 + "/");
                zipOutputStream.putNextEntry((ZipEntry)object);
                zipOutputStream.closeEntry();
                ProjectPackager.PackDirectory(string, fileArray[i], zipOutputStream);
                continue;
            }
            object = fileArray[i];
            ZipEntry zipEntry = new ZipEntry("." + string2);
            FileInputStream fileInputStream = new FileInputStream((File)object);
            byte[] byArray = new byte[(int)((File)object).length()];
            fileInputStream.read(byArray);
            fileInputStream.close();
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write(byArray);
            zipOutputStream.closeEntry();
        }
    }
}

