/*
 * Decompiled with CFR 0.152.
 */
package com.projity.algorithm;

import com.projity.algorithm.IntervalGenerator;
import com.projity.algorithm.RangeIntervalGenerator;
import com.projity.algorithm.SelectFrom;
import com.projity.pm.time.HasStartAndEnd;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.Factory;

public class Query
implements Factory,
HasStartAndEnd {
    long start;
    long end;
    boolean hasGroupBy = false;
    private LinkedList selectFromClauses = new LinkedList();
    private IntervalGenerator groupByGenerator = null;
    private Closure actionVisitor = null;

    private Query() {
    }

    public static Query getInstance() {
        return new Query();
    }

    public Query selectFrom(SelectFrom selectFrom) {
        this.selectFromClauses.add(selectFrom);
        return this;
    }

    public Query selectFrom(LinkedList linkedList) {
        this.selectFromClauses = linkedList;
        return this;
    }

    public Query groupBy(IntervalGenerator intervalGenerator) {
        if (intervalGenerator == null) {
            return this;
        }
        this.hasGroupBy = true;
        this.groupByGenerator = intervalGenerator;
        return this;
    }

    public Query action(Closure closure) {
        this.actionVisitor = closure;
        return this;
    }

    public IntervalGenerator[] execute() {
        if (this.groupByGenerator == null) {
            this.groupByGenerator = RangeIntervalGenerator.continuous();
        }
        this.create();
        return null;
    }

    public Object create() {
        do {
            this.start = this.groupByGenerator.currentStart();
            this.end = this.groupByGenerator.currentEnd();
            Iterator iterator = this.selectFromClauses.iterator();
            while (iterator.hasNext()) {
                SelectFrom selectFrom = (SelectFrom)iterator.next();
                selectFrom.initializeCalculations();
                if (selectFrom.calculate(this.start, this.end)) continue;
                iterator.remove();
            }
            if (this.start == 0L || this.actionVisitor == null) continue;
            this.actionVisitor.execute(this);
        } while ((this.hasGroupBy || !this.selectFromClauses.isEmpty()) && this.groupByGenerator.evaluate(this));
        return null;
    }

    public long getEnd() {
        return this.end;
    }

    public long getStart() {
        return this.start;
    }

    public IntervalGenerator getGroupByGenerator() {
        return this.groupByGenerator;
    }

    public Object currentGroupByObject() {
        return this.groupByGenerator.current();
    }

    public Closure getActionVisitor() {
        return this.actionVisitor;
    }
}

