/*
 * Decompiled with CFR 0.152.
 */
package com.projity.datatype;

import com.projity.strings.Messages;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class Money
extends BigDecimal {
    private static final long serialVersionUID = -8182666966278921881L;
    private static NumberFormat moneyFormat = null;
    private static DecimalFormat moneyCompactFormat = null;

    public static NumberFormat getMoneyFormatInstance() {
        if (moneyFormat == null) {
            moneyFormat = NumberFormat.getCurrencyInstance();
            moneyFormat.setGroupingUsed(false);
        }
        return moneyFormat;
    }

    public static NumberFormat getMoneyCompactFormatInstance() {
        if (moneyCompactFormat == null) {
            moneyCompactFormat = (DecimalFormat)NumberFormat.getCurrencyInstance();
            moneyCompactFormat.setGroupingUsed(false);
            moneyCompactFormat.setMaximumFractionDigits(0);
        }
        return moneyCompactFormat;
    }

    public static NumberFormat getFormat(boolean bl) {
        return bl ? Money.getMoneyFormatInstance() : Money.getMoneyCompactFormatInstance();
    }

    public static Money getInstance(double d2) {
        return new Money(d2);
    }

    private Money(double d2) {
        super(d2);
    }

    public Money(String string) throws NumberFormatException {
        super(string);
    }

    public Money(BigInteger bigInteger) {
        super(bigInteger);
    }

    public Money(BigInteger bigInteger, int n2) {
        super(bigInteger, n2);
    }

    public double getPrimitiveTypeValue() {
        return this.doubleValue();
    }

    public static String formatCurrency(double d2, boolean bl) {
        if (bl) {
            if (d2 < 100.0) {
                return Money.normalCurrencyFormat(d2, Math.floor(d2) == d2);
            }
            if (d2 < 10000.0) {
                d2 = Math.floor(d2);
                return Money.normalCurrencyFormat(d2, true);
            }
            if (d2 < 100000.0) {
                return Money.normalCurrencyFormat(d2, Math.floor(d2 /= 1000.0) == d2) + Messages.getString("Text.thousandsAbbreviation");
            }
            if (d2 < 1000000.0) {
                return Money.normalCurrencyFormat(d2 /= 1000.0, true) + Messages.getString("Text.thousandsAbbreviation");
            }
            if (d2 < 1.0E8) {
                return Money.normalCurrencyFormat(d2, Math.floor(d2 /= 1000000.0) == d2) + Messages.getString("Text.millionsAbbreviation");
            }
            return Money.normalCurrencyFormat(d2 /= 1000000.0, true) + Messages.getString("Text.millionsAbbreviation");
        }
        return Money.normalCurrencyFormat(d2, false);
    }

    public static String normalCurrencyFormat(double d2, boolean bl) {
        return bl ? Money.getMoneyCompactFormatInstance().format(d2) : Money.getMoneyFormatInstance().format(d2);
    }
}

