/*
 * Decompiled with CFR 0.152.
 */
package com.projity.field;

import com.projity.datatype.Duration;
import com.projity.datatype.DurationFormat;
import com.projity.datatype.Money;
import com.projity.datatype.Work;
import com.projity.field.FieldContext;
import com.projity.field.FieldParseException;
import com.projity.options.EditOption;
import com.projity.strings.Messages;
import com.projity.util.DateTime;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;

public class FieldConverter {
    HashMap<FieldContext, HashMap<Class, Converter>> contextMaps = new HashMap();
    private StringConverter stringConverter;
    private StringConverter compactStringConverter;
    private static FieldConverter instance = null;
    public static final FieldContext COMPACT_CONVERTER_CONTEXT = new FieldContext();

    public static String toString(Object object, Class clazz, FieldContext fieldContext) {
        return FieldConverter.getInstance()._toString(object, clazz, fieldContext);
    }

    public static String toString(Object object) {
        return FieldConverter.getInstance()._toString(object, object.getClass(), null);
    }

    public static Object fromString(String string, Class clazz) {
        return ConvertUtils.convert(string, clazz);
    }

    public static Object convert(Object object, Class clazz, FieldContext fieldContext) throws FieldParseException {
        return FieldConverter.getInstance()._convert(object, clazz, fieldContext);
    }

    public static FieldConverter getInstance() {
        if (instance == null) {
            instance = new FieldConverter();
        }
        return instance;
    }

    public static void reinitialize() {
        instance = null;
    }

    private Object _convert(Object object, Class clazz, FieldContext fieldContext) throws FieldParseException {
        try {
            if (object instanceof String) {
                Object object2 = null;
                if (fieldContext == null) {
                    object2 = ConvertUtils.convert((String)object, clazz);
                } else {
                    Converter converter = null;
                    HashMap<Class, Converter> hashMap = this.contextMaps.get(fieldContext);
                    if (hashMap != null) {
                        converter = hashMap.get(clazz);
                    }
                    if (converter != null) {
                        converter.convert(clazz, object);
                    } else {
                        System.out.println("no context converter found ");
                        object2 = ConvertUtils.convert((String)object, clazz);
                    }
                }
                if (object2 == null) {
                    throw new FieldParseException("Invalid type");
                }
                return object2;
            }
            Converter converter = ConvertUtils.lookup(clazz);
            if (converter == null) {
                System.out.println("converter is null for class " + clazz + " instance " + instance.hashCode() + " resetting");
                instance = new FieldConverter();
                converter = ConvertUtils.lookup(String.class);
            }
            return converter.convert(clazz, object);
        }
        catch (ConversionException conversionException) {
            throw new FieldParseException(conversionException);
        }
    }

    private String _toString(Object object, Class clazz, FieldContext fieldContext) {
        if (fieldContext == COMPACT_CONVERTER_CONTEXT) {
            return (String)this.compactStringConverter.convert(clazz, object);
        }
        return (String)this.stringConverter.convert(clazz, object);
    }

    private FieldConverter() {
        instance = this;
        this.stringConverter = new StringConverter(false);
        this.compactStringConverter = new StringConverter(true);
        ConvertUtils.register(this.stringConverter, String.class);
        ConvertUtils.register(new DateConverter(), Date.class);
        ConvertUtils.register(new CalendarConverter(), GregorianCalendar.class);
        ConvertUtils.register(new DurationConverter(), Duration.class);
        ConvertUtils.register(new WorkConverter(), Work.class);
        ConvertUtils.register(new MoneyConverter(), Money.class);
        LongConverter longConverter = new LongConverter();
        ConvertUtils.register(longConverter, Long.TYPE);
        ConvertUtils.register(longConverter, Long.class);
        DoubleConverter doubleConverter = new DoubleConverter();
        ConvertUtils.register(doubleConverter, Double.TYPE);
        ConvertUtils.register(doubleConverter, Double.class);
        HashMap<Class<String>, StringConverter> hashMap = new HashMap<Class<String>, StringConverter>();
        this.contextMaps.put(COMPACT_CONVERTER_CONTEXT, hashMap);
        hashMap.put(String.class, this.compactStringConverter);
    }

    static {
        COMPACT_CONVERTER_CONTEXT.setCompact(true);
    }

    private static class MoneyConverter
    implements Converter {
        private MoneyConverter() {
        }

        public Object convert(Class clazz, Object object) throws ConversionException {
            if (object == null) {
                return Money.getInstance(0.0);
            }
            if (object instanceof Money) {
                return object;
            }
            if (object instanceof Number) {
                double d2 = ((Number)object).doubleValue();
                if (Double.isInfinite(d2) || Double.isNaN(d2)) {
                    System.out.println("Error: number is invalid double in MoneyConverter " + object);
                    d2 = 0.0;
                }
                return Money.getInstance(d2);
            }
            if (object instanceof String) {
                try {
                    return Money.getFormat(false).parseObject((String)object);
                }
                catch (ParseException parseException) {
                    throw new ConversionException(Messages.getString("Message.invalidDuration"));
                }
            }
            throw new ConversionException("Error: no conversion from " + object.getClass().getName() + " to " + clazz.getName() + " for value" + object);
        }
    }

    private static class DoubleConverter
    implements Converter {
        Converter baseConverter = new org.apache.commons.beanutils.converters.DoubleConverter();

        private DoubleConverter() {
        }

        public Object convert(Class clazz, Object object) throws ConversionException {
            if (object != null) {
                if (object instanceof Double) {
                    return object;
                }
                if (object instanceof Money) {
                    double d2 = ((Number)object).doubleValue();
                    if (Double.isInfinite(d2) || Double.isNaN(d2)) {
                        System.out.println("Error: number is invalid double in MoneyConverter " + object);
                        d2 = 0.0;
                    }
                    return new Double(d2);
                }
            }
            return this.baseConverter.convert(clazz, object);
        }
    }

    private static class WorkConverter
    implements Converter {
        private WorkConverter() {
        }

        public Object convert(Class clazz, Object object) throws ConversionException {
            if (object == null) {
                return Duration.getInstanceFromDouble(null);
            }
            if (object instanceof Number) {
                return new Work(((Number)object).longValue());
            }
            if (object instanceof Work) {
                return new Work(((Work)object).longValue());
            }
            if (object instanceof Duration) {
                return object;
            }
            if (object instanceof String) {
                try {
                    return DurationFormat.getWorkInstance().parseObject((String)object);
                }
                catch (ParseException parseException) {
                    throw new ConversionException(Messages.getString("Message.invalidDuration"));
                }
            }
            throw new ConversionException("Error: no conversion from " + object.getClass().getName() + " to " + clazz.getName() + " for value" + object);
        }
    }

    private static class DurationConverter
    implements Converter {
        private DurationConverter() {
        }

        public Object convert(Class clazz, Object object) throws ConversionException {
            if (object == null) {
                return Duration.getInstanceFromDouble(null);
            }
            if (object instanceof Number) {
                return new Duration(((Number)object).longValue());
            }
            if (object instanceof Work) {
                return new Duration(((Work)object).longValue());
            }
            if (object instanceof Duration) {
                return object;
            }
            if (object instanceof String) {
                try {
                    return DurationFormat.getInstance().parseObject((String)object);
                }
                catch (ParseException parseException) {
                    throw new ConversionException(Messages.getString("Message.invalidDuration"));
                }
            }
            throw new ConversionException("Error: no conversion from " + object.getClass().getName() + " to " + clazz.getName() + " for value" + object);
        }
    }

    private static class CalendarConverter
    implements Converter {
        private static DateConverter dateConverter = new DateConverter();

        private CalendarConverter() {
        }

        public Object convert(Class clazz, Object object) throws ConversionException {
            GregorianCalendar gregorianCalendar = DateTime.calendarInstance();
            if (object == null) {
                return null;
            }
            if (object instanceof Long) {
                long l2 = (Long)object;
                if (l2 == 0L) {
                    return null;
                }
                gregorianCalendar.setTimeInMillis(l2);
                return gregorianCalendar;
            }
            if (object instanceof Date) {
                gregorianCalendar.setTime((Date)object);
                return gregorianCalendar;
            }
            if (object instanceof String) {
                Date date = (Date)dateConverter.convert(Date.class, object);
                gregorianCalendar.setTime(date);
                return gregorianCalendar;
            }
            throw new ConversionException("Error: no conversion from " + object.getClass().getName() + " to " + clazz.getName() + " for value" + object);
        }
    }

    private static class DateConverter
    implements Converter {
        private DateConverter() {
        }

        public Object convert(Class clazz, Object object) throws ConversionException {
            if (object == null) {
                return null;
            }
            if (object instanceof Long) {
                long l2 = (Long)object;
                if (l2 == 0L) {
                    return null;
                }
                return new Date(l2);
            }
            if (object instanceof Date) {
                return object;
            }
            if (object instanceof Calendar) {
                return ((Calendar)object).getTime();
            }
            if (object instanceof String) {
                try {
                    return EditOption.getInstance().getDateFormat().parse((String)object);
                }
                catch (ParseException parseException) {
                    try {
                        return DateTime.utcShortDateFormatInstance().parse((String)object);
                    }
                    catch (ParseException parseException2) {
                        throw new ConversionException(Messages.getString("Message.invalidDate"));
                    }
                }
            }
            throw new ConversionException("Error: no conversion from " + object.getClass().getName() + " to " + clazz.getName() + " for value" + object);
        }
    }

    private static class LongConverter
    implements Converter {
        Converter baseConverter = new org.apache.commons.beanutils.converters.LongConverter();

        private LongConverter() {
        }

        public Object convert(Class clazz, Object object) throws ConversionException {
            if (object == null) {
                return null;
            }
            if (object != null) {
                if (object instanceof Date) {
                    return new Long(((Date)object).getTime());
                }
                if (object instanceof GregorianCalendar) {
                    return new Long(((GregorianCalendar)object).getTimeInMillis());
                }
                if (object instanceof Duration || object instanceof Work) {
                    return new Long(((Duration)object).getEncodedMillis());
                }
            }
            return this.baseConverter.convert(clazz, object);
        }
    }

    private static class StringConverter
    implements Converter {
        private boolean compact = false;

        StringConverter(boolean bl) {
            this.compact = bl;
        }

        public Object convert(Class clazz, Object object) {
            if (object instanceof Work) {
                if (this.compact) {
                    return ((DurationFormat)DurationFormat.getWorkInstance()).formatCompact(object);
                }
                return ((DurationFormat)DurationFormat.getWorkInstance()).format(object);
            }
            if (object instanceof Duration) {
                if (this.compact) {
                    return ((DurationFormat)DurationFormat.getInstance()).formatCompact(object);
                }
                return ((DurationFormat)DurationFormat.getInstance()).format(object);
            }
            if (object instanceof Money) {
                return Money.formatCurrency(((Money)object).doubleValue(), this.compact);
            }
            if (object instanceof Date) {
                if (object.equals(DateTime.getZeroDate())) {
                    return null;
                }
                return EditOption.getInstance().getDateFormat().format(object);
            }
            if (object == null) {
                return null;
            }
            return object.toString();
        }
    }
}

