/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.gantt;

import com.projity.association.InvalidAssociationException;
import com.projity.graphic.configuration.GraphicConfiguration;
import com.projity.pm.graphic.graph.GraphModel;
import com.projity.pm.graphic.model.cache.GraphicNode;
import com.projity.pm.graphic.timescale.CoordinatesConverter;
import com.projity.pm.task.Project;
import com.projity.timescale.TimeScaleEvent;
import com.projity.timescale.TimeScaleListener;
import java.awt.geom.AffineTransform;
import java.io.Serializable;

public class GanttModel
extends GraphModel
implements TimeScaleListener,
Serializable {
    private static final long serialVersionUID = 357529278107413145L;
    protected CoordinatesConverter coord;
    protected int rowHeight = GraphicConfiguration.getInstance().getRowHeight();

    public GanttModel(Project project, String string) {
        super(project, string);
    }

    public AffineTransform getTransform(double d2) {
        double d3 = (double)(this.coord.getEnd() - this.coord.getOrigin()) / d2;
        double d4 = 1.0 / (double)this.getRowHeight();
        return new AffineTransform(d3, 0.0, 0.0, d4, (double)this.coord.getOrigin(), 0.0);
    }

    public void createEdge(GraphicNode graphicNode, GraphicNode graphicNode2) throws InvalidAssociationException {
        this.getCache().createDependency(graphicNode, graphicNode2);
    }

    public CoordinatesConverter getCoord() {
        return this.coord;
    }

    public void setCoord(CoordinatesConverter coordinatesConverter) {
        if (this.coord != null) {
            this.coord.removeTimeScaleListener(this);
        }
        this.coord = coordinatesConverter;
        coordinatesConverter.addTimeScaleListener(this);
    }

    public void timeScaleChanged(TimeScaleEvent timeScaleEvent) {
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public void setRowHeight(int n2) {
        this.rowHeight = n2;
    }
}

