/*
 * Decompiled with CFR 0.152.
 */
package com.projity.script;

import com.projity.configuration.Dictionary;
import com.projity.configuration.NamedItem;
import com.projity.script.ConverterContext;
import com.projity.strings.Messages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.Predicate;
import org.apache.commons.digester.Digester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextStore
implements NamedItem {
    public static final String category = "ContextStoreCategory";
    protected String name = null;
    protected String id = null;
    protected Map<Integer, List<ConverterContext>> contexts = new HashMap<Integer, List<ConverterContext>>();
    protected static ContextStore instance = null;

    @Override
    public String getCategory() {
        return category;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public final void setName(String string) {
        this.name = string;
    }

    public final String getId() {
        return this.id;
    }

    public final void setId(String string) {
        this.id = string;
        if (this.name == null) {
            this.name = Messages.getString(string);
        }
    }

    public static void addDigesterEvents(Digester digester) {
        digester.addObjectCreate("*/converterContexts", "com.projity.script.ContextStore");
        digester.addSetProperties("*/converterContexts");
        digester.addSetNext("*/converterContexts", "add", "com.projity.configuration.NamedItem");
        digester.addObjectCreate("*/converterContexts/context", "com.projity.script.ConverterContext");
        digester.addSetProperties("*/converterContexts/context");
        digester.addSetNext("*/converterContexts/context", "addContext", "com.projity.script.ConverterContext");
    }

    public void addContext(ConverterContext converterContext) {
        List<ConverterContext> list = this.contexts.get(converterContext.getType());
        if (list == null) {
            list = new ArrayList<ConverterContext>();
            this.contexts.put(converterContext.getType(), list);
        }
        if (converterContext.getName() == null) {
            converterContext.setName(Messages.getString(converterContext.getFieldArrayId()));
        }
        list.add(converterContext);
    }

    public List<ConverterContext> getContexts(int n2, Predicate predicate) {
        List<ConverterContext> list = this.contexts.get(n2);
        ArrayList<ConverterContext> arrayList = null;
        if (list != null) {
            arrayList = new ArrayList<ConverterContext>(list.size());
            for (ConverterContext converterContext : list) {
                if (predicate != null && !predicate.evaluate(converterContext)) continue;
                arrayList.add((ConverterContext)converterContext.clone());
            }
        }
        return arrayList;
    }

    public ConverterContext createDefaultContext(int n2) {
        ConverterContext converterContext = this.contexts.get(n2).get(0);
        if (converterContext == null) {
            return null;
        }
        ConverterContext converterContext2 = (ConverterContext)converterContext.clone();
        converterContext2.setDistribution(true);
        return converterContext2;
    }

    public static ContextStore getInstance() {
        if (instance == null) {
            long l2 = System.currentTimeMillis();
            Dictionary.getInstance();
            instance = (ContextStore)Dictionary.get(category, "default");
            System.out.println("Configuration loaded in " + (System.currentTimeMillis() - l2) + " ms");
        }
        return instance;
    }
}

