/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util.gui.resource;

import com.projity.help.HelpUtil;
import com.projity.menu.ExtButtonFactory;
import java.awt.Color;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JToolBar;
import javax.swing.plaf.basic.BasicBorders;
import org.apache.batik.util.gui.resource.ActionMap;
import org.apache.batik.util.gui.resource.ButtonFactory;
import org.apache.batik.util.gui.resource.JToolbarSeparator;
import org.apache.batik.util.gui.resource.MissingListenerException;
import org.apache.batik.util.gui.resource.ResourceFormatException;
import org.apache.batik.util.gui.resource.ResourceManager;

public class ToolBarFactory
extends ResourceManager {
    private static final String SEPARATOR = "-";
    private ActionMap actions;
    private ButtonFactory buttonFactory;
    private ButtonGroup buttonGroup;

    public ToolBarFactory(ResourceBundle resourceBundle, ActionMap actionMap) {
        super(resourceBundle);
        this.actions = actionMap;
        this.buttonFactory = new ExtButtonFactory(resourceBundle, actionMap);
        this.buttonGroup = null;
    }

    public JToolBar createJToolBar(String string) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JToolBar jToolBar = new JToolBar();
        List list = this.getStringList(string);
        for (String string2 : list) {
            if (string2.equals(SEPARATOR)) {
                this.buttonGroup = null;
                jToolBar.add(new JToolbarSeparator());
                continue;
            }
            AbstractButton abstractButton = this.createJButton(string2);
            boolean bl = true;
            try {
                bl = this.getBoolean(string2 + ".visible");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            if (!bl) continue;
            jToolBar.add(abstractButton);
        }
        return jToolBar;
    }

    public AbstractButton createJButton(String string) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        AbstractButton abstractButton = this.buttonFactory.createJToolbarButton(string);
        String string2 = null;
        try {
            string2 = this.getString(string + ".type");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (string2 != null) {
            if (string2.equals("RADIO")) {
                if (this.buttonGroup == null) {
                    this.buttonGroup = new ButtonGroup();
                }
                this.buttonGroup.add(abstractButton);
            } else if (string2.equals("TOGGLE")) {
                abstractButton.setBorder(new BasicBorders.ToggleButtonBorder(Color.GRAY, Color.BLACK, Color.BLUE, Color.CYAN));
                abstractButton.setBorderPainted(true);
            }
        } else {
            this.buttonGroup = null;
        }
        String string3 = this.getStringOrNull(string + ".doc");
        if (string3 != null) {
            HelpUtil.addDocHelp(abstractButton, string3);
        }
        return abstractButton;
    }

    public boolean getBoolean(String string) throws MissingResourceException, ResourceFormatException {
        String string2 = this.getString(string);
        if (string2.equals("true")) {
            return true;
        }
        if (string2.equals("false")) {
            return false;
        }
        throw new ResourceFormatException("Malformed boolean", this.bundle.getClass().getName(), string);
    }
}

