/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.layout;

import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.a;
import com.jgoodies.forms.layout.b;
import com.jgoodies.forms.layout.c;
import com.jgoodies.forms.layout.j;
import com.jgoodies.forms.layout.k;
import com.jgoodies.forms.layout.m;
import com.jgoodies.forms.layout.u;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.StringTokenizer;

public final class CellConstraints
implements Cloneable,
Serializable {
    public static final j DEFAULT = new j("default", 2, null);
    public static final j FILL = new j("fill", 2, null);
    public static final j LEFT = new j("left", 0, null);
    public static final j RIGHT = new j("right", 0, null);
    public static final j CENTER = new j("center", 2, null);
    public static final j TOP = new j("top", 1, null);
    public static final j BOTTOM = new j("bottom", 1, null);
    private static final Insets a;
    public int gridX;
    public int gridY;
    public int gridWidth;
    public int gridHeight;
    public j hAlign;
    public j vAlign;
    public Insets insets;

    public CellConstraints() {
        this(1, 1);
    }

    public CellConstraints(int n2, int n3) {
        this(n2, n3, 1, 1);
    }

    public CellConstraints(int n2, int n3, j j2, j j3) {
        this(n2, n3, 1, 1, j2, j3, a);
    }

    public CellConstraints(int n2, int n3, int n4, int n5) {
        this(n2, n3, n4, n5, DEFAULT, DEFAULT);
    }

    public CellConstraints(int n2, int n3, int n4, int n5, j j2, j j3) {
        this(n2, n3, n4, n5, j2, j3, a);
    }

    public CellConstraints(int n2, int n3, int n4, int n5, j j2, j j3, Insets insets) {
        this.gridX = n2;
        this.gridY = n3;
        this.gridWidth = n4;
        this.gridHeight = n5;
        this.hAlign = j2;
        this.vAlign = j3;
        this.insets = insets;
        if (n2 <= 0) {
            throw new IndexOutOfBoundsException("The grid x must be a positive number.");
        }
        if (n3 <= 0) {
            throw new IndexOutOfBoundsException("The grid y must be a positive number.");
        }
        if (n4 <= 0) {
            throw new IndexOutOfBoundsException("The grid width must be a positive number.");
        }
        if (n5 <= 0) {
            throw new IndexOutOfBoundsException("The grid height must be a positive number.");
        }
        if (j2 == null) {
            throw new NullPointerException("The horizontal alignment must not be null.");
        }
        if (j3 == null) {
            throw new NullPointerException("The vertical alignment must not be null.");
        }
        CellConstraints.a(j2, j3);
    }

    public CellConstraints(String string) {
        this();
        this.a(string);
    }

    public final CellConstraints xy(int n2, int n3) {
        return this.xywh(n2, n3, 1, 1);
    }

    public final CellConstraints xy(int n2, int n3, String string) {
        return this.xywh(n2, n3, 1, 1, string);
    }

    public final CellConstraints xy(int n2, int n3, j j2, j j3) {
        return this.xywh(n2, n3, 1, 1, j2, j3);
    }

    public final CellConstraints xyw(int n2, int n3, int n4) {
        return this.xywh(n2, n3, n4, 1, DEFAULT, DEFAULT);
    }

    public final CellConstraints xyw(int n2, int n3, int n4, String string) {
        return this.xywh(n2, n3, n4, 1, string);
    }

    public final CellConstraints xyw(int n2, int n3, int n4, j j2, j j3) {
        return this.xywh(n2, n3, n4, 1, j2, j3);
    }

    public final CellConstraints xywh(int n2, int n3, int n4, int n5) {
        return this.xywh(n2, n3, n4, n5, DEFAULT, DEFAULT);
    }

    public final CellConstraints xywh(int n2, int n3, int n4, int n5, String string) {
        CellConstraints cellConstraints = this.xywh(n2, n3, n4, n5);
        cellConstraints.b(string);
        return cellConstraints;
    }

    public final CellConstraints xywh(int n2, int n3, int n4, int n5, j j2, j j3) {
        this.gridX = n2;
        this.gridY = n3;
        this.gridWidth = n4;
        this.gridHeight = n5;
        this.hAlign = j2;
        this.vAlign = j3;
        CellConstraints.a(this.hAlign, this.vAlign);
        return this;
    }

    private void a(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        int n2 = stringTokenizer.countTokens();
        if (n2 != 2 && n2 != 4 && n2 != 6) {
            throw new IllegalArgumentException("You must provide 2, 4 or 6 arguments.");
        }
        Integer n3 = CellConstraints.c(stringTokenizer.nextToken());
        if (n3 == null) {
            throw new IllegalArgumentException("First cell constraint element must be a number.");
        }
        this.gridX = n3;
        if (this.gridX <= 0) {
            throw new IndexOutOfBoundsException("The grid x must be a positive number.");
        }
        n3 = CellConstraints.c(stringTokenizer.nextToken());
        if (n3 == null) {
            throw new IllegalArgumentException("Second cell constraint element must be a number.");
        }
        this.gridY = n3;
        if (this.gridY <= 0) {
            throw new IndexOutOfBoundsException("The grid y must be a positive number.");
        }
        if (!stringTokenizer.hasMoreTokens()) {
            return;
        }
        String string2 = stringTokenizer.nextToken();
        n3 = CellConstraints.c(string2);
        if (n3 != null) {
            this.gridWidth = n3;
            if (this.gridWidth <= 0) {
                throw new IndexOutOfBoundsException("The grid width must be a positive number.");
            }
            n3 = CellConstraints.c(stringTokenizer.nextToken());
            if (n3 == null) {
                throw new IllegalArgumentException("Fourth cell constraint element must be like third.");
            }
            this.gridHeight = n3;
            if (this.gridHeight <= 0) {
                throw new IndexOutOfBoundsException("The grid height must be a positive number.");
            }
            if (!stringTokenizer.hasMoreTokens()) {
                return;
            }
            string2 = stringTokenizer.nextToken();
        }
        this.hAlign = CellConstraints.d(string2);
        this.vAlign = CellConstraints.d(stringTokenizer.nextToken());
        CellConstraints.a(this.hAlign, this.vAlign);
    }

    private void b(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        this.hAlign = CellConstraints.d(stringTokenizer.nextToken());
        this.vAlign = CellConstraints.d(stringTokenizer.nextToken());
        CellConstraints.a(this.hAlign, this.vAlign);
    }

    private static Integer c(String string) {
        try {
            return Integer.decode(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private static j d(String string) {
        return j.a(string);
    }

    final void a(int n2, int n3) {
        if (this.gridX <= 0) {
            throw new IndexOutOfBoundsException("The column index " + this.gridX + " must be positive.");
        }
        if (this.gridX > n2) {
            throw new IndexOutOfBoundsException("The column index " + this.gridX + " must be less than or equal to " + n2 + ".");
        }
        if (this.gridX + this.gridWidth - 1 > n2) {
            throw new IndexOutOfBoundsException("The grid width " + this.gridWidth + " must be less than or equal to " + (n2 - this.gridX + 1) + ".");
        }
        if (this.gridY <= 0) {
            throw new IndexOutOfBoundsException("The row index " + this.gridY + " must be positive.");
        }
        if (this.gridY > n3) {
            throw new IndexOutOfBoundsException("The row index " + this.gridY + " must be less than or equal to " + n3 + ".");
        }
        if (this.gridY + this.gridHeight - 1 > n3) {
            throw new IndexOutOfBoundsException("The grid height " + this.gridHeight + " must be less than or equal to " + (n3 - this.gridY + 1) + ".");
        }
    }

    private static void a(j j2, j j3) {
        if (!j.a(j2)) {
            throw new IllegalArgumentException("The horizontal alignment must be one of: left, center, right, fill, default.");
        }
        if (!j.b(j3)) {
            throw new IllegalArgumentException("The vertical alignment must be one of: top, center, botto, fill, default.");
        }
    }

    final void a(Component component, FormLayout formLayout, Rectangle rectangle, c c2, c c3, c c4, c c5) {
        b b2 = this.gridWidth == 1 ? formLayout.getColumnSpec(this.gridX) : null;
        k k2 = this.gridHeight == 1 ? formLayout.getRowSpec(this.gridY) : null;
        j j2 = this.a(this.hAlign, b2);
        j j3 = this.a(this.vAlign, k2);
        Insets insets = this.insets != null ? this.insets : a;
        int n2 = rectangle.x + insets.left;
        int n3 = rectangle.y + insets.top;
        int n4 = rectangle.width - insets.left - insets.right;
        int n5 = rectangle.height - insets.top - insets.bottom;
        int n6 = CellConstraints.a(component, b2, n4, c2, c4);
        int n7 = CellConstraints.a(component, k2, n5, c3, c5);
        int n8 = CellConstraints.a(j2, n2, n4, n6);
        int n9 = CellConstraints.a(j3, n3, n5, n7);
        int n10 = CellConstraints.a(j2, n4, n6);
        int n11 = CellConstraints.a(j3, n5, n7);
        component.setBounds(n8, n9, n10, n11);
    }

    private j a(j j2, u u2) {
        if (u2 == null) {
            if (j2 == DEFAULT) {
                return FILL;
            }
            return j2;
        }
        return CellConstraints.b(j2, u2);
    }

    private static j b(j j2, u u2) {
        if (j2 != DEFAULT) {
            return j2;
        }
        a a2 = u2.b();
        if (a2 == u.k) {
            return FILL;
        }
        if (a2 == b.a) {
            return LEFT;
        }
        if (a2 == u.j) {
            return CENTER;
        }
        if (a2 == b.c) {
            return RIGHT;
        }
        if (a2 == k.a) {
            return TOP;
        }
        return BOTTOM;
    }

    private static int a(Component component, u u2, int n2, c c2, c c3) {
        if (u2 == null) {
            return c3.a(component);
        }
        if (u2.c() == m.q) {
            return c2.a(component);
        }
        if (u2.c() == m.r) {
            return c3.a(component);
        }
        return Math.min(n2, c3.a(component));
    }

    private static int a(j j2, int n2, int n3, int n4) {
        if (j2 == RIGHT || j2 == BOTTOM) {
            return n2 + n3 - n4;
        }
        if (j2 == CENTER) {
            return n2 + (n3 - n4) / 2;
        }
        return n2;
    }

    private static int a(j j2, int n2, int n3) {
        if (j2 == FILL) {
            return n2;
        }
        return n3;
    }

    public final Object clone() {
        try {
            CellConstraints cellConstraints = (CellConstraints)super.clone();
            ((CellConstraints)super.clone()).insets = (Insets)this.insets.clone();
            return cellConstraints;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer("CellConstraints");
        stringBuffer.append("[x=");
        stringBuffer.append(this.gridX);
        stringBuffer.append("; y=");
        stringBuffer.append(this.gridY);
        stringBuffer.append("; w=");
        stringBuffer.append(this.gridWidth);
        stringBuffer.append("; h=");
        stringBuffer.append(this.gridHeight);
        stringBuffer.append("; hAlign=");
        stringBuffer.append(this.hAlign);
        stringBuffer.append("; vAlign=");
        stringBuffer.append(this.vAlign);
        if (!a.equals(this.insets)) {
            stringBuffer.append("; insets=");
            stringBuffer.append(this.insets);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public final String toShortString() {
        return this.toShortString(null);
    }

    public final String toShortString(FormLayout formLayout) {
        b b2;
        StringBuffer stringBuffer = new StringBuffer("(");
        stringBuffer.append(CellConstraints.a(this.gridX));
        stringBuffer.append(", ");
        stringBuffer.append(CellConstraints.a(this.gridY));
        stringBuffer.append(", ");
        stringBuffer.append(CellConstraints.a(this.gridWidth));
        stringBuffer.append(", ");
        stringBuffer.append(CellConstraints.a(this.gridHeight));
        stringBuffer.append(", \"");
        stringBuffer.append(this.hAlign.a());
        if (this.hAlign == DEFAULT && formLayout != null) {
            stringBuffer.append('=');
            b2 = this.gridWidth == 1 ? formLayout.getColumnSpec(this.gridX) : null;
            stringBuffer.append(this.a(this.hAlign, b2).a());
        }
        stringBuffer.append(", ");
        stringBuffer.append(this.vAlign.a());
        if (this.vAlign == DEFAULT && formLayout != null) {
            stringBuffer.append('=');
            b2 = this.gridHeight == 1 ? formLayout.getRowSpec(this.gridY) : null;
            stringBuffer.append(this.a(this.vAlign, b2).a());
        }
        stringBuffer.append("\"");
        if (!a.equals(this.insets)) {
            stringBuffer.append(", ");
            stringBuffer.append(this.insets);
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    private static String a(int n2) {
        String string = Integer.toString(n2);
        if (n2 < 10) {
            return " " + string;
        }
        return string;
    }

    static {
        j[] jArray = new j[]{DEFAULT, FILL, LEFT, RIGHT, CENTER, TOP, BOTTOM};
        a = new Insets(0, 0, 0, 0);
    }
}

