/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.unmarshaller;

import com.sun.xml.bind.DatatypeConverterImpl;
import com.sun.xml.bind.DefaultJAXBContextImpl;
import com.sun.xml.bind.ErrorHandlerToEventHandler;
import com.sun.xml.bind.TypeRegistry;
import com.sun.xml.bind.unmarshaller.DOMScanner;
import com.sun.xml.bind.unmarshaller.SAXUnmarshallerHandler;
import com.sun.xml.bind.unmarshaller.SAXUnmarshallerHandlerImpl;
import com.sun.xml.bind.validator.DOMLocator;
import com.sun.xml.bind.validator.Locator;
import com.sun.xml.bind.validator.SAXLocator;
import com.sun.xml.bind.validator.ValidatingUnmarshaller;
import java.io.IOException;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.bind.helpers.AbstractUnmarshallerImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class UnmarshallerImpl
extends AbstractUnmarshallerImpl {
    private DefaultJAXBContextImpl context = null;
    private final TypeRegistry registry;

    public UnmarshallerImpl(DefaultJAXBContextImpl context, TypeRegistry reg) {
        this.context = context;
        this.registry = reg;
        DatatypeConverter.setDatatypeConverter(DatatypeConverterImpl.theInstance);
    }

    public UnmarshallerHandler getUnmarshallerHandler() {
        return this.createUnmarshallerHandler(new SAXLocator());
    }

    public SAXUnmarshallerHandler createUnmarshallerHandler(Locator locator) {
        SAXUnmarshallerHandler unmarshaller = new SAXUnmarshallerHandlerImpl(this, this.registry);
        try {
            if (this.isValidating()) {
                unmarshaller = ValidatingUnmarshaller.create(this.context.getGrammar(), unmarshaller, locator);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return unmarshaller;
    }

    protected Object unmarshal(XMLReader reader, InputSource source) throws JAXBException {
        SAXLocator locator = new SAXLocator();
        SAXUnmarshallerHandler handler = this.createUnmarshallerHandler(locator);
        reader.setContentHandler(handler);
        reader.setErrorHandler(new ErrorHandlerToEventHandler(handler, locator));
        try {
            reader.parse(source);
        }
        catch (IOException e) {
            throw new JAXBException(e);
        }
        catch (SAXException e) {
            throw this.createUnmarshalException(e);
        }
        return handler.getResult();
    }

    public final Object unmarshal(Node node) throws JAXBException {
        try {
            DOMScanner scanner = new DOMScanner();
            SAXUnmarshallerHandler handler = this.createUnmarshallerHandler(new DOMLocator(scanner));
            if (node instanceof Element) {
                scanner.parse((Element)node, handler);
            } else if (node instanceof Document) {
                scanner.parse(((Document)node).getDocumentElement(), handler);
            } else {
                throw new IllegalArgumentException();
            }
            return handler.getResult();
        }
        catch (SAXException e) {
            throw this.createUnmarshalException(e);
        }
    }
}

