/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.mpxj.Day;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.Filter;
import net.sf.mpxj.FilterCriteria;
import net.sf.mpxj.MPPResourceField;
import net.sf.mpxj.MPPTaskField;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Table;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TestOperator;
import net.sf.mpxj.mpp.ColorType;
import net.sf.mpxj.mpp.FontBase;
import net.sf.mpxj.mpp.FontStyle;
import net.sf.mpxj.mpp.GanttBarStyle;
import net.sf.mpxj.mpp.GanttBarStyleException;
import net.sf.mpxj.mpp.GenericView;
import net.sf.mpxj.mpp.GridLines;
import net.sf.mpxj.mpp.Interval;
import net.sf.mpxj.mpp.LineStyle;
import net.sf.mpxj.mpp.LinkStyle;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.NonWorkingTimeStyle;
import net.sf.mpxj.mpp.ProgressLineDay;
import net.sf.mpxj.mpp.Props9;
import net.sf.mpxj.mpp.TableFontStyle;
import net.sf.mpxj.mpp.TimescaleAlignment;
import net.sf.mpxj.mpp.TimescaleTier;
import net.sf.mpxj.mpp.TimescaleUnits;
import net.sf.mpxj.mpp.Var2Data;

public abstract class GanttChartView
extends GenericView {
    private ProjectFile m_parent;
    private GridLines m_sheetRowsGridLines;
    private GridLines m_sheetColumnsGridLines;
    private GridLines m_titleVerticalGridLines;
    private GridLines m_titleHorizontalGridLines;
    private GridLines m_majorColumnsGridLines;
    private GridLines m_minorColumnsGridLines;
    private GridLines m_ganttRowsGridLines;
    private GridLines m_barRowsGridLines;
    private GridLines m_currentDateGridLines;
    private GridLines m_pageBreakGridLines;
    private GridLines m_projectStartGridLines;
    private GridLines m_projectFinishGridLines;
    private GridLines m_statusDateGridLines;
    private int m_ganttBarHeight;
    private TimescaleTier m_timescaleTopTier;
    private TimescaleTier m_timescaleMiddleTier;
    private TimescaleTier m_timescaleBottomTier;
    private boolean m_timescaleSeparator;
    private int m_timescaleSize;
    private String m_nonWorkingDaysCalendarName;
    private ColorType m_nonWorkingColor;
    private int m_nonWorkingPattern;
    private NonWorkingTimeStyle m_nonWorkingStyle;
    private boolean m_showDrawings;
    private boolean m_roundBarsToWholeDays;
    private boolean m_showBarSplits;
    private boolean m_alwaysRollupGanttBars;
    private boolean m_hideRollupBarsWhenSummaryExpanded;
    private int m_barDateFormat;
    private LinkStyle m_linkStyle;
    private GanttBarStyle[] m_barStyles;
    private GanttBarStyleException[] m_barStyleExceptions;
    private int m_tableWidth;
    private String m_tableName;
    private String m_filterName;
    private String m_groupName;
    private boolean m_highlightFilter;
    private boolean m_showInMenu;
    private FontStyle m_highlightedTasksFontStyle;
    private FontStyle m_rowAndColumnFontStyle;
    private FontStyle m_nonCriticalTasksFontStyle;
    private FontStyle m_criticalTasksFontStyle;
    private FontStyle m_summaryTasksFontStyle;
    private FontStyle m_milestoneTasksFontStyle;
    private FontStyle m_topTimescaleFontStyle;
    private FontStyle m_middleTimescaleFontStyle;
    private FontStyle m_bottomTimescaleFontStyle;
    private FontStyle m_barTextLeftFontStyle;
    private FontStyle m_barTextRightFontStyle;
    private FontStyle m_barTextTopFontStyle;
    private FontStyle m_barTextBottomFontStyle;
    private FontStyle m_barTextInsideFontStyle;
    private FontStyle m_markedTasksFontStyle;
    private FontStyle m_projectSummaryTasksFontStyle;
    private FontStyle m_externalTasksFontStyle;
    private TableFontStyle[] m_tableFontStyles;
    private boolean m_progressLinesEnabled;
    private boolean m_progressLinesAtCurrentDate;
    private boolean m_progressLinesAtRecurringIntervals;
    private Interval m_progressLinesInterval;
    private int m_progressLinesDailyDayNumber;
    private boolean m_progressLinesDailyWorkday;
    private boolean[] m_progressLinesWeeklyDay = new boolean[8];
    private int m_progressLinesWeekleyWeekNumber;
    private boolean m_progressLinesMonthlyDayOfMonth;
    private int m_progressLinesMonthlyDayNumber;
    private Day m_progressLinesMonthlyDay;
    private boolean m_progressLinesMonthlyFirst;
    private boolean m_progressLinesBeginAtProjectStart;
    private Date m_progressLinesBeginAtDate;
    private boolean m_progressLinesDisplaySelected;
    private Date[] m_progressLinesDisplaySelectedDates;
    private boolean m_progressLinesActualPlan;
    private int m_progressLinesDisplayType;
    private boolean m_progressLinesShowDate;
    private int m_progressLinesDateFormat;
    private FontStyle m_progressLinesFontStyle;
    private ColorType m_progressLinesCurrentLineColor;
    private LineStyle m_progressLinesCurrentLineStyle;
    private ColorType m_progressLinesCurrentProgressPointColor;
    private int m_progressLinesCurrentProgressPointShape;
    private ColorType m_progressLinesOtherLineColor;
    private LineStyle m_progressLinesOtherLineStyle;
    private ColorType m_progressLinesOtherProgressPointColor;
    private int m_progressLinesOtherProgressPointShape;
    private List m_autoFilters = new LinkedList();
    private Map m_autoFiltersByType = new HashMap();
    private static final Integer PROPERTIES = new Integer(1);
    private static final Integer VIEW_PROPERTIES = new Integer(574619656);
    private static final Integer TOP_TIER_PROPERTIES = new Integer(574619678);
    private static final Integer BAR_PROPERTIES = new Integer(574619661);
    private static final Integer TABLE_PROPERTIES = new Integer(574619655);
    private static final Integer TABLE_NAME = new Integer(574619658);
    private static final Integer FILTER_NAME = new Integer(574619659);
    private static final Integer GROUP_NAME = new Integer(574619672);
    private static final Integer COLUMN_PROPERTIES = new Integer(574619660);
    private static final Integer PROGRESS_LINE_PROPERTIES = new Integer(574619671);
    private static final Integer AUTO_FILTER_PROPERTIES = new Integer(574619669);

    protected abstract Integer getPropertiesID();

    GanttChartView(ProjectFile parent, byte[] fixedMeta, byte[] fixedData, Var2Data varData, Map fontBases) throws IOException {
        super(fixedData);
        this.m_parent = parent;
        this.m_showInMenu = (fixedMeta[8] & 8) != 0;
        byte[] propsData = varData.getByteArray(this.m_id, this.getPropertiesID());
        if (propsData != null) {
            byte[] autoFilterData;
            byte[] progressLineData;
            byte[] columnData;
            byte[] barData;
            byte[] topTierData;
            int loop;
            byte[] viewPropertyData;
            byte[] groupName;
            byte[] filterName;
            byte[] tableName;
            Props9 props = new Props9(new ByteArrayInputStream(propsData));
            byte[] tableData = props.getByteArray(TABLE_PROPERTIES);
            if (tableData != null) {
                this.m_tableWidth = MPPUtility.getShort(tableData, 35);
                boolean bl = this.m_highlightFilter = tableData[7] != 0;
            }
            if ((tableName = props.getByteArray(TABLE_NAME)) != null) {
                this.m_tableName = MPPUtility.removeAmpersands(MPPUtility.getUnicodeString(tableName));
            }
            if ((filterName = props.getByteArray(FILTER_NAME)) != null) {
                this.m_filterName = MPPUtility.getUnicodeString(filterName);
            }
            if ((groupName = props.getByteArray(GROUP_NAME)) != null) {
                this.m_groupName = MPPUtility.getUnicodeString(groupName);
            }
            if ((viewPropertyData = props.getByteArray(VIEW_PROPERTIES)) != null) {
                this.m_highlightedTasksFontStyle = this.getFontStyle(viewPropertyData, 26, fontBases);
                this.m_rowAndColumnFontStyle = this.getFontStyle(viewPropertyData, 30, fontBases);
                this.m_nonCriticalTasksFontStyle = this.getFontStyle(viewPropertyData, 34, fontBases);
                this.m_criticalTasksFontStyle = this.getFontStyle(viewPropertyData, 38, fontBases);
                this.m_summaryTasksFontStyle = this.getFontStyle(viewPropertyData, 42, fontBases);
                this.m_milestoneTasksFontStyle = this.getFontStyle(viewPropertyData, 46, fontBases);
                this.m_middleTimescaleFontStyle = this.getFontStyle(viewPropertyData, 50, fontBases);
                this.m_bottomTimescaleFontStyle = this.getFontStyle(viewPropertyData, 54, fontBases);
                this.m_barTextLeftFontStyle = this.getFontStyle(viewPropertyData, 58, fontBases);
                this.m_barTextRightFontStyle = this.getFontStyle(viewPropertyData, 62, fontBases);
                this.m_barTextTopFontStyle = this.getFontStyle(viewPropertyData, 66, fontBases);
                this.m_barTextBottomFontStyle = this.getFontStyle(viewPropertyData, 70, fontBases);
                this.m_barTextInsideFontStyle = this.getFontStyle(viewPropertyData, 74, fontBases);
                this.m_markedTasksFontStyle = this.getFontStyle(viewPropertyData, 78, fontBases);
                this.m_projectSummaryTasksFontStyle = this.getFontStyle(viewPropertyData, 82, fontBases);
                this.m_externalTasksFontStyle = this.getFontStyle(viewPropertyData, 86, fontBases);
                this.m_topTimescaleFontStyle = this.getFontStyle(viewPropertyData, 90, fontBases);
                this.m_sheetRowsGridLines = new GridLines(viewPropertyData, 99);
                this.m_sheetColumnsGridLines = new GridLines(viewPropertyData, 109);
                this.m_titleVerticalGridLines = new GridLines(viewPropertyData, 119);
                this.m_titleHorizontalGridLines = new GridLines(viewPropertyData, 129);
                this.m_majorColumnsGridLines = new GridLines(viewPropertyData, 139);
                this.m_minorColumnsGridLines = new GridLines(viewPropertyData, 149);
                this.m_ganttRowsGridLines = new GridLines(viewPropertyData, 159);
                this.m_barRowsGridLines = new GridLines(viewPropertyData, 169);
                this.m_currentDateGridLines = new GridLines(viewPropertyData, 179);
                this.m_pageBreakGridLines = new GridLines(viewPropertyData, 189);
                this.m_projectStartGridLines = new GridLines(viewPropertyData, 199);
                this.m_projectFinishGridLines = new GridLines(viewPropertyData, 209);
                this.m_statusDateGridLines = new GridLines(viewPropertyData, 219);
                this.m_nonWorkingDaysCalendarName = MPPUtility.getUnicodeString(viewPropertyData, 352);
                this.m_nonWorkingColor = ColorType.getInstance(viewPropertyData[1153]);
                this.m_nonWorkingPattern = viewPropertyData[1154];
                this.m_nonWorkingStyle = NonWorkingTimeStyle.getInstance(viewPropertyData[1152]);
                this.m_ganttBarHeight = this.mapGanttBarHeight(MPPUtility.getByte(viewPropertyData, 1163));
                byte flags = viewPropertyData[228];
                this.m_timescaleMiddleTier = new TimescaleTier();
                this.m_timescaleMiddleTier.setTickLines((flags & 1) != 0);
                this.m_timescaleMiddleTier.setUsesFiscalYear((flags & 8) != 0);
                this.m_timescaleMiddleTier.setUnits(TimescaleUnits.getInstance(viewPropertyData[242]));
                this.m_timescaleMiddleTier.setCount(viewPropertyData[246]);
                this.m_timescaleMiddleTier.setFormat(viewPropertyData[250]);
                this.m_timescaleMiddleTier.setAlignment(TimescaleAlignment.getInstance(viewPropertyData[256] - 32));
                this.m_timescaleBottomTier = new TimescaleTier();
                this.m_timescaleBottomTier.setTickLines((flags & 2) != 0);
                this.m_timescaleBottomTier.setUsesFiscalYear((flags & 0x10) != 0);
                this.m_timescaleBottomTier.setUnits(TimescaleUnits.getInstance(viewPropertyData[244]));
                this.m_timescaleBottomTier.setCount(viewPropertyData[248]);
                this.m_timescaleBottomTier.setFormat(viewPropertyData[252]);
                this.m_timescaleBottomTier.setAlignment(TimescaleAlignment.getInstance(viewPropertyData[254] - 32));
                this.m_timescaleSeparator = (flags & 4) != 0;
                this.m_timescaleSize = viewPropertyData[268];
                this.m_showDrawings = viewPropertyData[1156] != 0;
                this.m_roundBarsToWholeDays = viewPropertyData[1158] != 0;
                this.m_showBarSplits = viewPropertyData[1160] != 0;
                this.m_alwaysRollupGanttBars = viewPropertyData[1186] != 0;
                this.m_hideRollupBarsWhenSummaryExpanded = viewPropertyData[1188] != 0;
                this.m_barDateFormat = viewPropertyData[1182];
                this.m_linkStyle = LinkStyle.getInstance(viewPropertyData[1155]);
                this.m_barStyles = new GanttBarStyle[viewPropertyData[1162]];
                int styleOffset = 1190;
                int nameOffset = styleOffset + this.m_barStyles.length * 58;
                loop = 0;
                while (loop < this.m_barStyles.length) {
                    String styleName = MPPUtility.getUnicodeString(viewPropertyData, nameOffset);
                    nameOffset += (styleName.length() + 1) * 2;
                    this.m_barStyles[loop] = new GanttBarStyle(styleName, viewPropertyData, styleOffset);
                    styleOffset += 58;
                    ++loop;
                }
            }
            if ((topTierData = props.getByteArray(TOP_TIER_PROPERTIES)) != null) {
                this.m_timescaleTopTier = new TimescaleTier();
                this.m_timescaleTopTier.setTickLines(topTierData[48] != 0);
                this.m_timescaleTopTier.setUsesFiscalYear(topTierData[60] != 0);
                this.m_timescaleTopTier.setUnits(TimescaleUnits.getInstance(topTierData[30]));
                this.m_timescaleTopTier.setCount(topTierData[32]);
                this.m_timescaleTopTier.setFormat(topTierData[34]);
                this.m_timescaleTopTier.setAlignment(TimescaleAlignment.getInstance(topTierData[36] - 20));
            }
            if ((barData = props.getByteArray(BAR_PROPERTIES)) != null) {
                this.m_barStyleExceptions = new GanttBarStyleException[barData.length / 38];
                int offset = 0;
                int loop2 = 0;
                while (loop2 < this.m_barStyleExceptions.length) {
                    this.m_barStyleExceptions[loop2] = new GanttBarStyleException(barData, offset);
                    offset += 38;
                    ++loop2;
                }
            }
            if ((columnData = props.getByteArray(COLUMN_PROPERTIES)) != null) {
                this.m_tableFontStyles = new TableFontStyle[columnData.length / 16];
                int offset = 0;
                loop = 0;
                while (loop < this.m_tableFontStyles.length) {
                    this.m_tableFontStyles[loop] = this.getColumnFontStyle(columnData, offset, fontBases);
                    offset += 16;
                    ++loop;
                }
            }
            if ((progressLineData = props.getByteArray(PROGRESS_LINE_PROPERTIES)) != null) {
                this.m_progressLinesEnabled = progressLineData[0] != 0;
                this.m_progressLinesAtCurrentDate = progressLineData[2] != 0;
                this.m_progressLinesAtRecurringIntervals = progressLineData[4] != 0;
                this.m_progressLinesInterval = Interval.getInstance(progressLineData[6]);
                this.m_progressLinesDailyDayNumber = progressLineData[8];
                this.m_progressLinesDailyWorkday = progressLineData[10] != 0;
                this.m_progressLinesWeeklyDay[Day.SUNDAY.getValue()] = progressLineData[14] != 0;
                this.m_progressLinesWeeklyDay[Day.MONDAY.getValue()] = progressLineData[16] != 0;
                this.m_progressLinesWeeklyDay[Day.TUESDAY.getValue()] = progressLineData[18] != 0;
                this.m_progressLinesWeeklyDay[Day.WEDNESDAY.getValue()] = progressLineData[20] != 0;
                this.m_progressLinesWeeklyDay[Day.THURSDAY.getValue()] = progressLineData[22] != 0;
                this.m_progressLinesWeeklyDay[Day.FRIDAY.getValue()] = progressLineData[24] != 0;
                this.m_progressLinesWeeklyDay[Day.SATURDAY.getValue()] = progressLineData[26] != 0;
                this.m_progressLinesWeekleyWeekNumber = progressLineData[30];
                this.m_progressLinesMonthlyDayOfMonth = progressLineData[32] != 0;
                this.m_progressLinesMonthlyDayNumber = progressLineData[34];
                this.m_progressLinesMonthlyDay = ProgressLineDay.getInstance(progressLineData[36]);
                this.m_progressLinesMonthlyFirst = progressLineData[40] == 1;
                this.m_progressLinesBeginAtProjectStart = progressLineData[44] != 0;
                this.m_progressLinesBeginAtDate = MPPUtility.getDate(progressLineData, 46);
                this.m_progressLinesDisplaySelected = progressLineData[48] != 0;
                this.m_progressLinesActualPlan = progressLineData[52] != 0;
                this.m_progressLinesDisplayType = MPPUtility.getShort(progressLineData, 54);
                this.m_progressLinesShowDate = progressLineData[56] != 0;
                this.m_progressLinesDateFormat = MPPUtility.getShort(progressLineData, 58);
                this.m_progressLinesFontStyle = this.getFontStyle(progressLineData, 60, fontBases);
                this.m_progressLinesCurrentLineColor = ColorType.getInstance(progressLineData[64]);
                this.m_progressLinesCurrentLineStyle = LineStyle.getInstance(progressLineData[65]);
                this.m_progressLinesCurrentProgressPointColor = ColorType.getInstance(progressLineData[66]);
                this.m_progressLinesCurrentProgressPointShape = progressLineData[67];
                this.m_progressLinesOtherLineColor = ColorType.getInstance(progressLineData[68]);
                this.m_progressLinesOtherLineStyle = LineStyle.getInstance(progressLineData[69]);
                this.m_progressLinesOtherProgressPointColor = ColorType.getInstance(progressLineData[70]);
                this.m_progressLinesOtherProgressPointShape = progressLineData[71];
                int dateCount = MPPUtility.getShort(progressLineData, 50);
                if (dateCount != 0) {
                    this.m_progressLinesDisplaySelectedDates = new Date[dateCount];
                    int offset = 72;
                    int count = 0;
                    while (count < dateCount && offset < progressLineData.length) {
                        this.m_progressLinesDisplaySelectedDates[count] = MPPUtility.getDate(progressLineData, offset);
                        offset += 2;
                        ++count;
                    }
                }
            }
            if ((autoFilterData = props.getByteArray(AUTO_FILTER_PROPERTIES)) != null) {
                this.processAutoFilters(autoFilterData);
            }
        }
    }

    public GridLines getSheetColumnsGridLines() {
        return this.m_sheetColumnsGridLines;
    }

    public GridLines getSheetRowsGridLines() {
        return this.m_sheetRowsGridLines;
    }

    public GridLines getStatusDateGridLines() {
        return this.m_statusDateGridLines;
    }

    public GridLines getTitleHorizontalGridLines() {
        return this.m_titleHorizontalGridLines;
    }

    public GridLines getTitleVerticalGridLines() {
        return this.m_titleVerticalGridLines;
    }

    public GridLines getBarRowsGridLines() {
        return this.m_barRowsGridLines;
    }

    public GridLines getCurrentDateGridLines() {
        return this.m_currentDateGridLines;
    }

    public GridLines getGanttRowsGridLines() {
        return this.m_ganttRowsGridLines;
    }

    public GridLines getMajorColumnsGridLines() {
        return this.m_majorColumnsGridLines;
    }

    public GridLines getMinorColumnsGridLines() {
        return this.m_minorColumnsGridLines;
    }

    public String getNonWorkingDaysCalendarName() {
        return this.m_nonWorkingDaysCalendarName;
    }

    public GridLines getPageBreakGridLines() {
        return this.m_pageBreakGridLines;
    }

    public GridLines getProjectFinishGridLines() {
        return this.m_projectFinishGridLines;
    }

    public GridLines getProjectStartGridLines() {
        return this.m_projectStartGridLines;
    }

    public int getGanttBarHeight() {
        return this.m_ganttBarHeight;
    }

    public boolean getTimescaleSeparator() {
        return this.m_timescaleSeparator;
    }

    public TimescaleTier getTimescaleTopTier() {
        return this.m_timescaleTopTier;
    }

    public TimescaleTier getTimescaleMiddleTier() {
        return this.m_timescaleMiddleTier;
    }

    public TimescaleTier getTimescaleBottomTier() {
        return this.m_timescaleBottomTier;
    }

    public int getTimescaleSize() {
        return this.m_timescaleSize;
    }

    public ColorType getNonWorkingColor() {
        return this.m_nonWorkingColor;
    }

    public int getNonWorkingPattern() {
        return this.m_nonWorkingPattern;
    }

    public NonWorkingTimeStyle getNonWorkingStyle() {
        return this.m_nonWorkingStyle;
    }

    public boolean getAlwaysRollupGanttBars() {
        return this.m_alwaysRollupGanttBars;
    }

    public int getBarDateFormat() {
        return this.m_barDateFormat;
    }

    public boolean getHideRollupBarsWhenSummaryExpanded() {
        return this.m_hideRollupBarsWhenSummaryExpanded;
    }

    public LinkStyle getLinkStyle() {
        return this.m_linkStyle;
    }

    public boolean getRoundBarsToWholeDays() {
        return this.m_roundBarsToWholeDays;
    }

    public boolean getShowBarSplits() {
        return this.m_showBarSplits;
    }

    public boolean getShowDrawings() {
        return this.m_showDrawings;
    }

    public GanttBarStyleException[] getBarStyleExceptions() {
        return this.m_barStyleExceptions;
    }

    public GanttBarStyle[] getBarStyles() {
        return this.m_barStyles;
    }

    public int getTableWidth() {
        return this.m_tableWidth;
    }

    public String getTableName() {
        return this.m_tableName;
    }

    public String getFilterName() {
        return this.m_filterName;
    }

    public Filter getFilter() {
        return this.m_parent.getFilterByName(this.m_filterName);
    }

    public String getGroupName() {
        return this.m_groupName;
    }

    public boolean getHighlightFilter() {
        return this.m_highlightFilter;
    }

    public boolean getShowInMenu() {
        return this.m_showInMenu;
    }

    public FontStyle getBarTextBottomFontStyle() {
        return this.m_barTextBottomFontStyle;
    }

    public FontStyle getBarTextInsideFontStyle() {
        return this.m_barTextInsideFontStyle;
    }

    public FontStyle getBarTextLeftFontStyle() {
        return this.m_barTextLeftFontStyle;
    }

    public FontStyle getBarTextRightFontStyle() {
        return this.m_barTextRightFontStyle;
    }

    public FontStyle getBarTextTopFontStyle() {
        return this.m_barTextTopFontStyle;
    }

    public FontStyle getCriticalTasksFontStyle() {
        return this.m_criticalTasksFontStyle;
    }

    public FontStyle getExternalTasksFontStyle() {
        return this.m_externalTasksFontStyle;
    }

    public FontStyle getHighlightedTasksFontStyle() {
        return this.m_highlightedTasksFontStyle;
    }

    public FontStyle getTopTimescaleFontStyle() {
        return this.m_topTimescaleFontStyle;
    }

    public FontStyle getMiddleTimescaleFontStyle() {
        return this.m_middleTimescaleFontStyle;
    }

    public FontStyle getMarkedTasksFontStyle() {
        return this.m_markedTasksFontStyle;
    }

    public FontStyle getMilestoneTasksFontStyle() {
        return this.m_milestoneTasksFontStyle;
    }

    public FontStyle getBottomTimescaleFontStyle() {
        return this.m_bottomTimescaleFontStyle;
    }

    public FontStyle getNonCriticalTasksFontStyle() {
        return this.m_nonCriticalTasksFontStyle;
    }

    public FontStyle getProjectSummaryTasksFontStyle() {
        return this.m_projectSummaryTasksFontStyle;
    }

    public FontStyle getRowAndColumnFontStyle() {
        return this.m_rowAndColumnFontStyle;
    }

    public FontStyle getSummaryTasksFontStyle() {
        return this.m_summaryTasksFontStyle;
    }

    public Table getTable() {
        return this.m_parent.getTaskTableByName(this.m_tableName);
    }

    public TableFontStyle[] getTableFontStyles() {
        return this.m_tableFontStyles;
    }

    public boolean getProgressLinesActualPlan() {
        return this.m_progressLinesActualPlan;
    }

    public boolean getProgressLinesAtCurrentDate() {
        return this.m_progressLinesAtCurrentDate;
    }

    public boolean getProgressLinesAtRecurringIntervals() {
        return this.m_progressLinesAtRecurringIntervals;
    }

    public Date getProgressLinesBeginAtDate() {
        return this.m_progressLinesBeginAtDate;
    }

    public boolean getProgressLinesBeginAtProjectStart() {
        return this.m_progressLinesBeginAtProjectStart;
    }

    public ColorType getProgressLinesCurrentLineColor() {
        return this.m_progressLinesCurrentLineColor;
    }

    public LineStyle getProgressLinesCurrentLineStyle() {
        return this.m_progressLinesCurrentLineStyle;
    }

    public ColorType getProgressLinesCurrentProgressPointColor() {
        return this.m_progressLinesCurrentProgressPointColor;
    }

    public int getProgressLinesCurrentProgressPointShape() {
        return this.m_progressLinesCurrentProgressPointShape;
    }

    public int getProgressLinesDailyDayNumber() {
        return this.m_progressLinesDailyDayNumber;
    }

    public boolean getProgressLinesDailyWorkday() {
        return this.m_progressLinesDailyWorkday;
    }

    public int getProgressLinesDateFormat() {
        return this.m_progressLinesDateFormat;
    }

    public boolean getProgressLinesDisplaySelected() {
        return this.m_progressLinesDisplaySelected;
    }

    public Date[] getProgressLinesDisplaySelectedDates() {
        return this.m_progressLinesDisplaySelectedDates;
    }

    public int getProgressLinesDisplayType() {
        return this.m_progressLinesDisplayType;
    }

    public boolean getProgressLinesEnabled() {
        return this.m_progressLinesEnabled;
    }

    public FontStyle getProgressLinesFontStyle() {
        return this.m_progressLinesFontStyle;
    }

    public Interval getProgressLinesInterval() {
        return this.m_progressLinesInterval;
    }

    public Day getProgressLinesMonthlyDay() {
        return this.m_progressLinesMonthlyDay;
    }

    public int getProgressLinesMonthlyDayNumber() {
        return this.m_progressLinesMonthlyDayNumber;
    }

    public boolean getProgressLinesMonthlyDayOfMonth() {
        return this.m_progressLinesMonthlyDayOfMonth;
    }

    public boolean getProgressLinesMonthlyFirst() {
        return this.m_progressLinesMonthlyFirst;
    }

    public ColorType getProgressLinesOtherLineColor() {
        return this.m_progressLinesOtherLineColor;
    }

    public LineStyle getProgressLinesOtherLineStyle() {
        return this.m_progressLinesOtherLineStyle;
    }

    public ColorType getProgressLinesOtherProgressPointColor() {
        return this.m_progressLinesOtherProgressPointColor;
    }

    public int getProgressLinesOtherProgressPointShape() {
        return this.m_progressLinesOtherProgressPointShape;
    }

    public boolean getProgressLinesShowDate() {
        return this.m_progressLinesShowDate;
    }

    public int getProgressLinesWeekleyWeekNumber() {
        return this.m_progressLinesWeekleyWeekNumber;
    }

    public boolean[] getProgressLinesWeeklyDay() {
        return this.m_progressLinesWeeklyDay;
    }

    private int mapGanttBarHeight(int height) {
        switch (height) {
            case 0: {
                height = 6;
                break;
            }
            case 1: {
                height = 8;
                break;
            }
            case 2: {
                height = 10;
                break;
            }
            case 3: {
                height = 12;
                break;
            }
            case 4: {
                height = 14;
                break;
            }
            case 5: {
                height = 18;
                break;
            }
            case 6: {
                height = 24;
            }
        }
        return height;
    }

    private FontStyle getFontStyle(byte[] data, int offset, Map fontBases) {
        Integer index = new Integer(MPPUtility.getByte(data, offset));
        FontBase fontBase = (FontBase)fontBases.get(index);
        int style = MPPUtility.getByte(data, offset + 1);
        ColorType color = ColorType.getInstance(MPPUtility.getByte(data, offset + 2));
        boolean bold = (style & 1) != 0;
        boolean italic = (style & 2) != 0;
        boolean underline = (style & 4) != 0;
        return new FontStyle(fontBase, italic, bold, underline, color);
    }

    private TableFontStyle getColumnFontStyle(byte[] data, int offset, Map fontBases) {
        int uniqueID = MPPUtility.getInt(data, offset);
        TaskField fieldType = MPPTaskField.getInstance(MPPUtility.getShort(data, offset + 4));
        Integer index = new Integer(MPPUtility.getByte(data, offset + 8));
        int style = MPPUtility.getByte(data, offset + 9);
        ColorType color = ColorType.getInstance(MPPUtility.getByte(data, offset + 10));
        int change = MPPUtility.getByte(data, offset + 12);
        FontBase fontBase = (FontBase)fontBases.get(index);
        boolean bold = (style & 1) != 0;
        boolean italic = (style & 2) != 0;
        boolean underline = (style & 4) != 0;
        boolean boldChanged = (change & 1) != 0;
        boolean underlineChanged = (change & 2) != 0;
        boolean italicChanged = (change & 4) != 0;
        boolean colorChanged = (change & 8) != 0;
        boolean fontChanged = (change & 0x10) != 0;
        return new TableFontStyle(uniqueID, fieldType, fontBase, italic, bold, underline, color, italicChanged, boldChanged, underlineChanged, colorChanged, fontChanged);
    }

    private void processAutoFilters(byte[] data) {
        int offset = 8;
        String[] stringData = new String[2];
        while (offset + 224 < data.length) {
            int blockSize = MPPUtility.getShort(data, offset + 8);
            int varDataOffset = MPPUtility.getInt(data, offset + 28) + 12;
            stringData[0] = null;
            stringData[1] = null;
            if (varDataOffset < blockSize) {
                stringData[0] = MPPUtility.getUnicodeString(data, offset + varDataOffset);
                int nextOffset = varDataOffset + (stringData[0].length() + 1) * 2;
                if (nextOffset < blockSize) {
                    stringData[1] = MPPUtility.getUnicodeString(data, offset + nextOffset);
                }
            }
            Filter filter = new Filter();
            FilterCriteria criteria = new FilterCriteria(this.m_parent);
            filter.addCriteria(criteria);
            int fieldType = MPPUtility.getShort(data, offset + 4);
            int entityType = MPPUtility.getByte(data, offset + 7);
            FieldType type = null;
            switch (entityType) {
                case 11: {
                    type = MPPTaskField.getInstance(fieldType);
                    break;
                }
                case 12: {
                    type = MPPResourceField.getInstance(fieldType);
                }
            }
            criteria.setField(type);
            int operatorValue = MPPUtility.getInt(data, offset + 32);
            criteria.setOperator(TestOperator.getInstance(operatorValue - 999));
            Object value = this.getValue(type, data, offset, stringData[0]);
            criteria.setValue(0, value);
            if (criteria.getOperator() == TestOperator.IS_WITHIN || criteria.getOperator() == TestOperator.IS_NOT_WITHIN) {
                value = this.getValue(type, data, offset + 80, null);
                criteria.setValue(1, value);
            }
            if (varDataOffset - 272 >= 272) {
                criteria.setLogicalAnd((MPPUtility.getByte(data, offset + 272) & 1) == 1);
                criteria = new FilterCriteria(this.m_parent);
                filter.addCriteria(criteria);
                criteria.setField(type);
                operatorValue = MPPUtility.getInt(data, offset + 272 + 80);
                criteria.setOperator(TestOperator.getInstance(operatorValue - 999));
                value = this.getValue(type, data, offset + 272 + 48, stringData[1]);
                criteria.setValue(0, value);
                if (criteria.getOperator() == TestOperator.IS_WITHIN || criteria.getOperator() == TestOperator.IS_NOT_WITHIN) {
                    value = this.getValue(type, data, offset + 272 + 128 + 80, null);
                    criteria.setValue(1, value);
                }
            }
            offset += blockSize;
            this.m_autoFilters.add(filter);
            this.m_autoFiltersByType.put(type, filter);
        }
    }

    private Object getValue(FieldType type, byte[] filterData, int offset, String stringData) {
        boolean valueFlag;
        Object value = null;
        boolean bl = valueFlag = MPPUtility.getInt(filterData, offset + 192) == 1;
        if (!valueFlag) {
            int field = MPPUtility.getShort(filterData, offset + 200);
            value = type instanceof TaskField ? MPPTaskField.getInstance(field) : MPPResourceField.getInstance(field);
        } else {
            switch (type.getDataType().getType()) {
                case 6: {
                    value = MPPUtility.getAdjustedDuration(this.m_parent, MPPUtility.getInt(filterData, offset + 224), MPPUtility.getDurationTimeUnits(MPPUtility.getShort(filterData, offset + 224)));
                    break;
                }
                case 5: {
                    value = new Double(MPPUtility.getDouble(filterData, offset + 224));
                    break;
                }
                case 8: {
                    value = new Double(MPPUtility.getInt(filterData, offset + 224));
                    break;
                }
                case 3: {
                    value = new Double(MPPUtility.getDouble(filterData, offset + 224) / 100.0);
                    break;
                }
                case 1: {
                    value = stringData;
                    break;
                }
                case 4: {
                    int intValue = MPPUtility.getShort(filterData, offset + 224);
                    value = intValue == 1 ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                case 2: {
                    value = MPPUtility.getTimestamp(filterData, offset + 224);
                }
            }
        }
        return value;
    }

    public List getAutoFilters() {
        return this.m_autoFilters;
    }

    public Filter getAutoFilterByType(FieldType type) {
        return (Filter)this.m_autoFiltersByType.get(type);
    }

    public String toString() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(os);
        pw.println("[GanttChartView");
        pw.println("   " + super.toString());
        pw.println("   highlightedTasksFontStyle=" + this.m_highlightedTasksFontStyle);
        pw.println("   rowAndColumnFontStyle=" + this.m_rowAndColumnFontStyle);
        pw.println("   nonCriticalTasksFontStyle=" + this.m_nonCriticalTasksFontStyle);
        pw.println("   criticalTasksFontStyle=" + this.m_criticalTasksFontStyle);
        pw.println("   summaryTasksFontStyle=" + this.m_summaryTasksFontStyle);
        pw.println("   milestoneTasksFontStyle=" + this.m_milestoneTasksFontStyle);
        pw.println("   topTimescaleFontStyle=" + this.m_topTimescaleFontStyle);
        pw.println("   middleTimescaleFontStyle=" + this.m_middleTimescaleFontStyle);
        pw.println("   bottomTimescaleFontStyle=" + this.m_bottomTimescaleFontStyle);
        pw.println("   barTextLeftFontStyle=" + this.m_barTextLeftFontStyle);
        pw.println("   barTextRightFontStyle=" + this.m_barTextRightFontStyle);
        pw.println("   barTextTopFontStyle=" + this.m_barTextTopFontStyle);
        pw.println("   barTextBottomFontStyle=" + this.m_barTextBottomFontStyle);
        pw.println("   barTextInsideFontStyle=" + this.m_barTextInsideFontStyle);
        pw.println("   markedTasksFontStyle=" + this.m_markedTasksFontStyle);
        pw.println("   projectSummaryTasksFontStyle=" + this.m_projectSummaryTasksFontStyle);
        pw.println("   externalTasksFontStyle=" + this.m_externalTasksFontStyle);
        pw.println("   SheetRowsGridLines=" + this.m_sheetRowsGridLines);
        pw.println("   SheetColumnsGridLines=" + this.m_sheetColumnsGridLines);
        pw.println("   TitleVerticalGridLines=" + this.m_titleVerticalGridLines);
        pw.println("   TitleHorizontalGridLines=" + this.m_titleHorizontalGridLines);
        pw.println("   MajorColumnsGridLines=" + this.m_majorColumnsGridLines);
        pw.println("   MinorColumnsGridLines=" + this.m_minorColumnsGridLines);
        pw.println("   GanttRowsGridLines=" + this.m_ganttRowsGridLines);
        pw.println("   BarRowsGridLines=" + this.m_barRowsGridLines);
        pw.println("   CurrentDateGridLines=" + this.m_currentDateGridLines);
        pw.println("   PageBreakGridLines=" + this.m_pageBreakGridLines);
        pw.println("   ProjectStartGridLines=" + this.m_projectStartGridLines);
        pw.println("   ProjectFinishGridLines=" + this.m_projectFinishGridLines);
        pw.println("   StatusDateGridLines=" + this.m_statusDateGridLines);
        pw.println("   GanttBarHeight=" + this.m_ganttBarHeight);
        pw.println("   TimescaleTopTier=" + this.m_timescaleTopTier);
        pw.println("   TimescaleMiddleTier=" + this.m_timescaleMiddleTier);
        pw.println("   TimescaleBottomTier=" + this.m_timescaleBottomTier);
        pw.println("   TimescaleSeparator=" + this.m_timescaleSeparator);
        pw.println("   TimescaleSize=" + this.m_timescaleSize + "%");
        pw.println("   NonWorkingDaysCalendarName=" + this.m_nonWorkingDaysCalendarName);
        pw.println("   NonWorkingColor=" + this.m_nonWorkingColor);
        pw.println("   NonWorkingPattern=" + this.m_nonWorkingPattern);
        pw.println("   NonWorkingStyle=" + this.m_nonWorkingStyle);
        pw.println("   ShowDrawings=" + this.m_showDrawings);
        pw.println("   RoundBarsToWholeDays=" + this.m_roundBarsToWholeDays);
        pw.println("   ShowBarSplits=" + this.m_showBarSplits);
        pw.println("   AlwaysRollupGanttBars=" + this.m_alwaysRollupGanttBars);
        pw.println("   HideRollupBarsWhenSummaryExpanded=" + this.m_hideRollupBarsWhenSummaryExpanded);
        pw.println("   BarDateFormat=" + this.m_barDateFormat);
        pw.println("   LinkStyle=" + this.m_linkStyle);
        pw.println("   ProgressLinesEnabled=" + this.m_progressLinesEnabled);
        pw.println("   ProgressLinesAtCurrentDate=" + this.m_progressLinesAtCurrentDate);
        pw.println("   ProgressLinesAtRecurringIntervals=" + this.m_progressLinesAtRecurringIntervals);
        pw.println("   ProgressLinesInterval=" + this.m_progressLinesInterval);
        pw.println("   ProgressLinesDailyDayNumber=" + this.m_progressLinesDailyDayNumber);
        pw.println("   ProgressLinesDailyWorkday=" + this.m_progressLinesDailyWorkday);
        pw.print("   ProgressLinesWeeklyDay=[");
        int loop = 0;
        while (loop < this.m_progressLinesWeeklyDay.length) {
            if (loop != 0) {
                pw.print(",");
            }
            pw.print(this.m_progressLinesWeeklyDay[loop]);
            ++loop;
        }
        pw.println("]");
        pw.println("   ProgressLinesWeeklyWeekNumber=" + this.m_progressLinesWeekleyWeekNumber);
        pw.println("   ProgressLinesMonthlyDayOfMonth=" + this.m_progressLinesMonthlyDayOfMonth);
        pw.println("   ProgressLinesMonthDayNumber=" + this.m_progressLinesMonthlyDayNumber);
        pw.println("   ProgressLinesMonthlyDay=" + this.m_progressLinesMonthlyDay);
        pw.println("   ProgressLinesMonthlyFirst=" + this.m_progressLinesMonthlyFirst);
        pw.println("   ProgressLinesBeginAtProjectStart=" + this.m_progressLinesBeginAtProjectStart);
        pw.println("   ProgressLinesBeginAtDate=" + this.m_progressLinesBeginAtDate);
        pw.println("   ProgressLinesDisplaySelected=" + this.m_progressLinesDisplaySelected);
        pw.print("   ProgressLinesDisplaySelectedDates=[");
        if (this.m_progressLinesDisplaySelectedDates != null) {
            loop = 0;
            while (loop < this.m_progressLinesDisplaySelectedDates.length) {
                if (loop != 0) {
                    pw.print(",");
                }
                pw.print(this.m_progressLinesDisplaySelectedDates[loop]);
                ++loop;
            }
        }
        pw.println("]");
        pw.println("   ProgressLinesActualPlan=" + this.m_progressLinesActualPlan);
        pw.println("   ProgressLinesDisplayType=" + this.m_progressLinesDisplayType);
        pw.println("   ProgressLinesShowDate=" + this.m_progressLinesShowDate);
        pw.println("   ProgressLinesDateFormat=" + this.m_progressLinesDateFormat);
        pw.println("   ProgressLinesFontStyle=" + this.m_progressLinesFontStyle);
        pw.println("   ProgressLinesCurrentLineColor=" + this.m_progressLinesCurrentLineColor);
        pw.println("   ProgressLinesCurrentLineStyle=" + this.m_progressLinesCurrentLineStyle);
        pw.println("   ProgressLinesCurrentProgressPointColor=" + this.m_progressLinesCurrentProgressPointColor);
        pw.println("   ProgressLinesCurrentProgressPointShape=" + this.m_progressLinesCurrentProgressPointShape);
        pw.println("   ProgressLinesOtherLineColor=" + this.m_progressLinesOtherLineColor);
        pw.println("   ProgressLinesOtherLineStyle=" + this.m_progressLinesOtherLineStyle);
        pw.println("   ProgressLinesOtherProgressPointColor=" + this.m_progressLinesOtherProgressPointColor);
        pw.println("   ProgressLinesOtherProgressPointShape=" + this.m_progressLinesOtherProgressPointShape);
        pw.println("   TableWidth=" + this.m_tableWidth);
        pw.println("   TableName=" + this.m_tableName);
        pw.println("   FilterName=" + this.m_filterName);
        pw.println("   GroupName=" + this.m_groupName);
        pw.println("   HighlightFilter=" + this.m_highlightFilter);
        pw.println("   ShowInMenu=" + this.m_showInMenu);
        pw.println("   Table=" + this.getTable());
        if (this.m_tableFontStyles != null) {
            loop = 0;
            while (loop < this.m_tableFontStyles.length) {
                pw.println("   ColumnFontStyle=" + this.m_tableFontStyles[loop]);
                ++loop;
            }
        }
        if (this.m_barStyles != null) {
            loop = 0;
            while (loop < this.m_barStyles.length) {
                pw.println("   BarStyle=" + this.m_barStyles[loop]);
                ++loop;
            }
        }
        if (this.m_barStyleExceptions != null) {
            loop = 0;
            while (loop < this.m_barStyleExceptions.length) {
                pw.println("   BarStyleException=" + this.m_barStyleExceptions[loop]);
                ++loop;
            }
        }
        if (!this.m_autoFilters.isEmpty()) {
            Iterator iter = this.m_autoFilters.iterator();
            while (iter.hasNext()) {
                pw.println("   AutoFilter=" + iter.next());
            }
        }
        pw.println("]");
        pw.flush();
        return os.toString();
    }
}

