/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mspdi.schema.impl.runtime;

import com.sun.xml.bind.DatatypeConverterImpl;
import com.sun.xml.bind.JAXBAssertionError;
import com.sun.xml.bind.marshaller.CharacterEscapeHandler;
import com.sun.xml.bind.marshaller.DataWriter;
import com.sun.xml.bind.marshaller.DumbEscapeHandler;
import com.sun.xml.bind.marshaller.Messages;
import com.sun.xml.bind.marshaller.MinimumEscapeHandler;
import com.sun.xml.bind.marshaller.NamespacePrefixMapper;
import com.sun.xml.bind.marshaller.NioEscapeHandler;
import com.sun.xml.bind.marshaller.SAX2DOMEx;
import com.sun.xml.bind.marshaller.SchemaLocationFilter;
import com.sun.xml.bind.marshaller.XMLWriter;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.PropertyException;
import javax.xml.bind.helpers.AbstractMarshallerImpl;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import net.sf.mpxj.mspdi.schema.impl.runtime.DefaultJAXBContextImpl;
import net.sf.mpxj.mspdi.schema.impl.runtime.SAXMarshaller;
import net.sf.mpxj.mspdi.schema.impl.runtime.XMLSerializable;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.LocatorImpl;

public class MarshallerImpl
extends AbstractMarshallerImpl {
    private String indent = "    ";
    private NamespacePrefixMapper prefixMapper = null;
    private CharacterEscapeHandler escapeHandler = null;
    private boolean printXmlDeclaration = true;
    private String header = null;
    final DefaultJAXBContextImpl context;

    public MarshallerImpl(DefaultJAXBContextImpl c) {
        DatatypeConverter.setDatatypeConverter(DatatypeConverterImpl.theInstance);
        this.context = c;
    }

    public void marshal(Object obj, Result result) throws JAXBException {
        XMLSerializable so = this.context.getGrammarInfo().castToXMLSerializable(obj);
        if (so == null) {
            throw new MarshalException(Messages.format("MarshallerImpl.NotMarshallable"));
        }
        if (result instanceof SAXResult) {
            this.write(so, ((SAXResult)result).getHandler());
            return;
        }
        if (result instanceof DOMResult) {
            Node node = ((DOMResult)result).getNode();
            if (node == null) {
                try {
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    dbf.setNamespaceAware(true);
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    Document doc = db.newDocument();
                    ((DOMResult)result).setNode(doc);
                    this.write(so, new SAX2DOMEx(doc));
                }
                catch (ParserConfigurationException pce) {
                    throw new JAXBAssertionError(pce);
                }
            } else {
                this.write(so, new SAX2DOMEx(node));
            }
            return;
        }
        if (result instanceof StreamResult) {
            StreamResult sr = (StreamResult)result;
            XMLWriter w = null;
            if (sr.getWriter() != null) {
                w = this.createWriter(sr.getWriter());
            } else if (sr.getOutputStream() != null) {
                w = this.createWriter(sr.getOutputStream());
            } else if (sr.getSystemId() != null) {
                String fileURL = sr.getSystemId();
                if (fileURL.startsWith("file:///")) {
                    fileURL = fileURL.substring(8).indexOf(":") > 0 ? fileURL.substring(8) : fileURL.substring(7);
                }
                try {
                    w = this.createWriter(new FileOutputStream(fileURL));
                }
                catch (IOException e) {
                    throw new MarshalException(e);
                }
            }
            if (w == null) {
                throw new IllegalArgumentException();
            }
            this.write(so, w);
            return;
        }
        throw new MarshalException(Messages.format("MarshallerImpl.UnsupportedResult"));
    }

    private void write(XMLSerializable obj, ContentHandler writer) throws JAXBException {
        try {
            if (this.getSchemaLocation() != null || this.getNoNSSchemaLocation() != null) {
                writer = new SchemaLocationFilter(this.getSchemaLocation(), this.getNoNSSchemaLocation(), writer);
            }
            SAXMarshaller serializer = new SAXMarshaller(writer, this.prefixMapper, this);
            writer.setDocumentLocator(new LocatorImpl());
            writer.startDocument();
            serializer.childAsBody(obj, null);
            writer.endDocument();
            serializer.reconcileID();
        }
        catch (SAXException e) {
            throw new MarshalException(e);
        }
    }

    protected CharacterEscapeHandler createEscapeHandler(String encoding) {
        if (this.escapeHandler != null) {
            return this.escapeHandler;
        }
        if (encoding.startsWith("UTF")) {
            return MinimumEscapeHandler.theInstance;
        }
        try {
            return new NioEscapeHandler(this.getJavaEncoding(encoding));
        }
        catch (Throwable e) {
            return DumbEscapeHandler.theInstance;
        }
    }

    public XMLWriter createWriter(Writer w, String encoding) throws JAXBException {
        XMLWriter xw;
        w = new BufferedWriter(w);
        CharacterEscapeHandler ceh = this.createEscapeHandler(encoding);
        if (this.isFormattedOutput()) {
            DataWriter d = new DataWriter(w, encoding, ceh);
            d.setIndentStep(this.indent);
            xw = d;
        } else {
            xw = new XMLWriter(w, encoding, ceh);
        }
        xw.setXmlDecl(this.printXmlDeclaration);
        xw.setHeader(this.header);
        return xw;
    }

    public XMLWriter createWriter(Writer w) throws JAXBException {
        return this.createWriter(w, this.getEncoding());
    }

    public XMLWriter createWriter(OutputStream os) throws JAXBException {
        return this.createWriter(os, this.getEncoding());
    }

    public XMLWriter createWriter(OutputStream os, String encoding) throws JAXBException {
        try {
            return this.createWriter(new OutputStreamWriter(os, this.getJavaEncoding(encoding)), encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new MarshalException(Messages.format("MarshallerImpl.UnsupportedEncoding", encoding), e);
        }
    }

    public Object getProperty(String name) throws PropertyException {
        if ("com.sun.xml.bind.indentString".equals(name)) {
            return this.indent;
        }
        if ("com.sun.xml.bind.characterEscapeHandler".equals(name)) {
            return this.escapeHandler;
        }
        if ("com.sun.xml.bind.namespacePrefixMapper".equals(name)) {
            return this.prefixMapper;
        }
        if ("com.sun.xml.bind.xmlDeclaration".equals(name)) {
            return this.printXmlDeclaration ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("com.sun.xml.bind.xmlHeaders".equals(name)) {
            return this.header;
        }
        return super.getProperty(name);
    }

    public void setProperty(String name, Object value) throws PropertyException {
        if ("com.sun.xml.bind.indentString".equals(name) && value instanceof String) {
            this.indent = (String)value;
            return;
        }
        if ("com.sun.xml.bind.characterEscapeHandler".equals(name)) {
            this.escapeHandler = (CharacterEscapeHandler)value;
            return;
        }
        if ("com.sun.xml.bind.namespacePrefixMapper".equals(name)) {
            this.prefixMapper = (NamespacePrefixMapper)value;
            return;
        }
        if ("com.sun.xml.bind.xmlDeclaration".equals(name)) {
            this.printXmlDeclaration = (Boolean)value;
            return;
        }
        if ("com.sun.xml.bind.xmlHeaders".equals(name)) {
            this.header = (String)value;
            return;
        }
        super.setProperty(name, value);
    }
}

