/*
 * Decompiled with CFR 0.152.
 */
package com.projity.configuration;

import com.projity.configuration.Configuration;
import com.projity.contrib.util.Log;
import com.projity.contrib.util.LogFactory;
import com.projity.field.Field;
import com.projity.pm.assignment.Assignment;
import com.projity.pm.dependency.Dependency;
import com.projity.pm.resource.Resource;
import com.projity.pm.resource.ResourceImpl;
import com.projity.pm.task.NormalTask;
import com.projity.pm.task.Project;
import com.projity.strings.Messages;
import com.projity.util.ClassUtils;
import com.projity.util.Environment;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.digester.Digester;

public class FieldDictionary {
    private static Log log = LogFactory.getLog(FieldDictionary.class);
    private HashedMap map = new HashedMap();
    private HashMap actionsMap = new HashMap();
    private Class clazz;
    private LinkedList taskFields = new LinkedList();
    private LinkedList resourceFields = new LinkedList();
    private LinkedList assignmentFields = new LinkedList();
    private LinkedList dependencyFields = new LinkedList();
    private LinkedList projectFields = new LinkedList();
    private LinkedList taskAndAssignmentFields = new LinkedList();
    private LinkedList resourceAndAssignmentFields = new LinkedList();

    public void addField(Field field) {
        if (field.isServer() && Environment.getStandAlone()) {
            return;
        }
        field.setClass(this.clazz);
        if (!field.build()) {
            // empty if block
        }
        if (field.isIndexed()) {
            for (int i = 0; i < field.getIndexes(); ++i) {
                Field field2 = field.createIndexedField(i);
                log.debug("adding indexfield " + this.clazz.getName() + "." + field2.getName() + " id " + field2.getId() + " field " + field2);
                this.map.put(field2.getId(), field2);
            }
        } else {
            log.debug("adding field " + this.clazz.getName() + "." + field.getName() + " " + field);
            this.map.put(field.getId(), field);
            if (field.getAction() != null) {
                this.actionsMap.put(field.getAction(), field);
            }
        }
    }

    public Field getActionField(String string) {
        return (Field)this.actionsMap.get(string);
    }

    public static FieldDictionary getInstance() {
        return Configuration.getInstance().getFieldDictionary();
    }

    public Field getFieldFromId(String string) {
        return (Field)this.map.get(string);
    }

    public void setClassName(String string) {
        try {
            this.clazz = ClassUtils.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
    }

    public void populateListWithFieldsOfType(List list, Class clazz) {
        this.populateListWithFieldsOfType(list, new Class[]{clazz});
    }

    public void populateListWithFieldsOfType(List list, Class[] classArray) {
        MapIterator mapIterator = this.map.mapIterator();
        while (mapIterator.hasNext()) {
            Object object = mapIterator.next();
            Field field = (Field)mapIterator.getValue();
            if (!field.isApplicable(classArray)) continue;
            list.add(field);
        }
        Collections.sort(list);
    }

    Collection getAllFields() {
        return this.map.values();
    }

    void setDonePopulating() {
        this.taskFields = new LinkedList();
        this.resourceFields = new LinkedList();
        this.assignmentFields = new LinkedList();
        this.dependencyFields = new LinkedList();
        this.projectFields = new LinkedList();
        this.taskAndAssignmentFields = new LinkedList();
        this.resourceAndAssignmentFields = new LinkedList();
        this.populateListWithFieldsOfType((List)this.taskFields, NormalTask.class);
        this.populateListWithFieldsOfType((List)this.resourceFields, ResourceImpl.class);
        this.populateListWithFieldsOfType((List)this.assignmentFields, Assignment.class);
        this.populateListWithFieldsOfType((List)this.dependencyFields, Dependency.class);
        this.populateListWithFieldsOfType((List)this.projectFields, Project.class);
        this.populateListWithFieldsOfType((List)this.taskAndAssignmentFields, new Class[]{NormalTask.class, Assignment.class});
        this.populateListWithFieldsOfType((List)this.resourceAndAssignmentFields, new Class[]{Resource.class, Assignment.class});
    }

    public LinkedList getAssignmentFields() {
        return this.assignmentFields;
    }

    public LinkedList getDependencyFields() {
        return this.dependencyFields;
    }

    public LinkedList getProjectFields() {
        return this.projectFields;
    }

    public LinkedList getResourceFields() {
        return this.resourceFields;
    }

    public LinkedList getTaskAndAssignmentFields() {
        return this.taskAndAssignmentFields;
    }

    public LinkedList getTaskFields() {
        return this.taskFields;
    }

    public LinkedList getResourceAndAssignmentFields() {
        return this.resourceAndAssignmentFields;
    }

    public static LinkedList extractExtraFields(Collection collection, final boolean bl) {
        LinkedList linkedList = new LinkedList();
        CollectionUtils.select(collection, new Predicate(){

            @Override
            public boolean evaluate(Object object) {
                Field field = (Field)object;
                return field.isExtra() && (!bl || field.isValidOnObjectCreate());
            }
        }, linkedList);
        return linkedList;
    }

    public static void addDigesterEvents(Digester digester) {
        digester.addFactoryCreate("*/fieldDictionary", "com.projity.configuration.FieldDictionaryFactory");
        digester.addSetNext("*/fieldDictionary", "setFieldDictionary", "com.projity.configuration.FieldDictionary");
        digester.addSetProperties("*/fieldDictionary/class", "name", "className");
        digester.addObjectCreate("*/fieldDictionary/class/field", "com.projity.field.Field");
        digester.addSetProperties("*/fieldDictionary/class/field");
        digester.addSetNext("*/fieldDictionary/class/field", "addField", "com.projity.field.Field");
        digester.addObjectCreate("*/field/select", "com.projity.field.StaticSelect");
        digester.addSetProperties("*/field/select");
        digester.addSetNext("*/field/select", "setSelect", "com.projity.field.StaticSelect");
        digester.addObjectCreate("*/field/choice", "com.projity.field.DynamicSelect");
        digester.addSetProperties("*/field/choice");
        digester.addSetNext("*/field/choice", "setSelect", "com.projity.field.DynamicSelect");
        digester.addObjectCreate("*/field/select/option", "com.projity.field.SelectOption");
        digester.addSetProperties("*/field/select/option");
        digester.addSetNext("*/field/select/option", "addOption", "com.projity.field.SelectOption");
        digester.addObjectCreate("*/field/range", "com.projity.field.Range");
        digester.addSetProperties("*/field/range");
        digester.addSetNext("*/field/range", "setRange", "com.projity.field.Range");
        digester.addObjectCreate("*/field/filter", "com.projity.field.OptionsFilter");
        digester.addSetProperties("*/field/filter");
        digester.addSetNext("*/field/filter", "setFilter", "com.projity.field.OptionsFilter");
        String string = Messages.getMetaString("FieldAccessible");
        digester.addObjectCreate("*/field/permission", string);
        digester.addSetProperties("*/field/permission");
        digester.addSetNext("*/field/permission", "setAccessControl", "com.projity.field.FieldAccessible");
    }

    private static void tabbedStringToHtmlRow(StringBuffer stringBuffer, String string, boolean bl) {
        String[] stringArray;
        stringBuffer.append("<tr>");
        for (String string2 : stringArray = string.split("\t")) {
            stringBuffer.append(bl ? "<th>" : "<td>").append(string2).append(bl ? "</th>" : "</td>");
        }
        stringBuffer.append("</tr>");
    }

    private static void fieldsToHtmlTable(final StringBuffer stringBuffer, String string, Collection collection) {
        stringBuffer.append("<p><b>").append(string).append("</b><br />");
        stringBuffer.append("<table border='1'>");
        FieldDictionary.tabbedStringToHtmlRow(stringBuffer, Field.getMetadataStringHeader(), true);
        CollectionUtils.forAllDo(FieldDictionary.getInstance().getProjectFields(), new Closure(){

            @Override
            public void execute(Object object) {
                FieldDictionary.tabbedStringToHtmlRow(stringBuffer, ((Field)object).getMetadataString(), false);
            }
        });
        stringBuffer.append("</table>");
        stringBuffer.append("</p>");
    }

    public static void generateFieldDoc(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html><body>");
        FieldDictionary.fieldsToHtmlTable(stringBuffer, "Project Fields", FieldDictionary.getInstance().getProjectFields());
        FieldDictionary.fieldsToHtmlTable(stringBuffer, "Resource Fields", FieldDictionary.getInstance().getProjectFields());
        FieldDictionary.fieldsToHtmlTable(stringBuffer, "Task Fields", FieldDictionary.getInstance().getProjectFields());
        FieldDictionary.fieldsToHtmlTable(stringBuffer, "Assignment Fields", FieldDictionary.getInstance().getProjectFields());
        FieldDictionary.fieldsToHtmlTable(stringBuffer, "Dependency Fields", FieldDictionary.getInstance().getProjectFields());
        stringBuffer.append("</body></html>");
        try {
            new FileOutputStream(string).write(stringBuffer.toString().getBytes());
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        FieldDictionary.generateFieldDoc("d:/pod/fields.html");
    }

    public static HashMap getAliasMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        MapIterator mapIterator = FieldDictionary.getInstance().map.mapIterator();
        while (mapIterator.hasNext()) {
            Object object = mapIterator.next();
            Field field = (Field)mapIterator.getValue();
            if (field.getAlias() == null) continue;
            hashMap.put(field.getId(), field.getAlias());
        }
        return hashMap;
    }

    public static void setAliasMap(HashMap hashMap) {
        if (hashMap == null) {
            return;
        }
        for (String string : hashMap.keySet()) {
            Field field = Configuration.getFieldFromId(string);
            if (field == null) continue;
            field.setAlias((String)hashMap.get(string));
        }
    }
}

