/*
 * Decompiled with CFR 0.152.
 */
package com.projity.grouping.core.transform;

import com.projity.configuration.Dictionary;
import com.projity.configuration.NamedItem;
import com.projity.contrib.util.Log;
import com.projity.contrib.util.LogFactory;
import com.projity.field.InvalidFormulaException;
import com.projity.grouping.core.transform.CommonTransform;
import com.projity.grouping.core.transform.CommonTransformFactory;
import com.projity.grouping.core.transform.ViewConfiguration;
import com.projity.grouping.core.transform.filtering.NodeFilter;
import com.projity.grouping.core.transform.filtering.NotVoidFilter;
import com.projity.strings.Messages;
import com.projity.util.Environment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.digester.Digester;

public class TransformList
implements NamedItem {
    static Log log = LogFactory.getLog(TransformList.class);
    public static final String category = "TransformCategory";
    String name = null;
    String id = null;
    Map elementMap = new HashMap();
    Map factoryMap = new HashMap();
    List factories = new ArrayList();

    @Override
    public String getCategory() {
        return category;
    }

    public void addFactory(CommonTransformFactory commonTransformFactory) {
        if (commonTransformFactory.isServer() && Environment.getStandAlone()) {
            return;
        }
        this.factories.add(commonTransformFactory);
        this.factoryMap.put(commonTransformFactory.getId(), commonTransformFactory);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setId(String string) {
        this.id = string;
        this.setName(Messages.getString(string));
    }

    public String getId() {
        return this.id;
    }

    public Object getTransform(String string) {
        CommonTransform commonTransform = null;
        if (this.elementMap.containsKey(string)) {
            commonTransform = (CommonTransform)this.elementMap.get(string);
        } else {
            CommonTransformFactory commonTransformFactory = this.getFactory(string);
            if (commonTransformFactory == null) {
                return null;
            }
            try {
                commonTransform = commonTransformFactory.getTransform();
                this.elementMap.put(string, commonTransform);
            }
            catch (InvalidFormulaException invalidFormulaException) {
                log.error("Formula not set: invalid formula text: " + commonTransformFactory.getFormulaText());
            }
        }
        return commonTransform;
    }

    public CommonTransformFactory getFactory(String string) {
        return (CommonTransformFactory)this.factoryMap.get(string);
    }

    public List getFactories() {
        return this.factories;
    }

    public List getFactories(ViewConfiguration viewConfiguration, String string) {
        List<String> list;
        if (viewConfiguration == null) {
            list = new ArrayList();
            if ("user_filters".equals(string)) {
                list.add("Filter.None");
            } else if ("user_sorters".equals(string)) {
                list.add("Sorter.None");
            } else if ("user_groupers".equals(string)) {
                list.add("Grouper.None");
            }
        } else {
            list = "user_filters".equals(string) ? viewConfiguration.getTransform().getFilterList() : ("user_sorters".equals(string) ? viewConfiguration.getTransform().getSorterList() : viewConfiguration.getTransform().getGrouperList());
            if (list == null) {
                return this.factories;
            }
        }
        ArrayList<CommonTransformFactory> arrayList = new ArrayList<CommonTransformFactory>();
        for (CommonTransformFactory commonTransformFactory : this.factories) {
            if (!list.contains(commonTransformFactory.getId())) continue;
            arrayList.add(commonTransformFactory);
        }
        return arrayList;
    }

    public static void addDigesterEvents(Digester digester) {
        digester.addObjectCreate("*/transform/filters", "com.projity.grouping.core.transform.TransformList");
        digester.addSetProperties("*/transform/filters");
        digester.addSetNext("*/transform/filters", "add", "com.projity.configuration.NamedItem");
        digester.addObjectCreate("*/filter", "com.projity.grouping.core.transform.filtering.NodeFilterFactory");
        digester.addSetProperties("*/filter");
        digester.addCallMethod("*/filter/formulaText", "setFormulaText", 0);
        digester.addSetNext("*/filter", "addFactory", "com.projity.grouping.core.transform.filtering.NodeFilterFactory");
        digester.addObjectCreate("*/transform/sorters", "com.projity.grouping.core.transform.TransformList");
        digester.addSetProperties("*/transform/sorters");
        digester.addSetNext("*/transform/sorters", "add", "com.projity.configuration.NamedItem");
        digester.addObjectCreate("*/sorter", "com.projity.grouping.core.transform.sorting.NodeSorterFactory");
        digester.addSetProperties("*/sorter");
        digester.addCallMethod("*/sorter/formulaText", "setFormulaText", 0);
        digester.addCallMethod("*/sorter/groupNameFormula", "setGroupNameFormula", 0);
        digester.addSetNext("*/sorter", "addFactory", "com.projity.grouping.core.transform.sorting.NodeSorterFactory");
        digester.addObjectCreate("*/transform/groupers", "com.projity.grouping.core.transform.TransformList");
        digester.addSetProperties("*/transform/groupers");
        digester.addSetNext("*/transform/groupers", "add", "com.projity.configuration.NamedItem");
        digester.addObjectCreate("*/grouper", "com.projity.grouping.core.transform.grouping.NodeGrouper");
        digester.addSetProperties("*/grouper");
        digester.addSetNext("*/grouper", "addFactory", "com.projity.grouping.core.transform.grouping.NodeGrouper");
        digester.addObjectCreate("*/grouper/group", "com.projity.grouping.core.transform.grouping.NodeGroup");
        digester.addSetProperties("*/grouper/group");
        digester.addSetNext("*/grouper/group", "addGroup", "com.projity.grouping.core.transform.grouping.NodeGroup");
        digester.addObjectCreate("*/param", "com.projity.grouping.core.transform.TransformParameter");
        digester.addSetProperties("*/param");
        digester.addSetNext("*/param", "addParameter", "com.projity.grouping.core.transform.TransformParameter");
        digester.addObjectCreate("*/transform/transformers", "com.projity.grouping.core.transform.TransformList");
        digester.addSetProperties("*/transform/transformers");
        digester.addSetNext("*/transform/transformers", "add", "com.projity.configuration.NamedItem");
        digester.addObjectCreate("*/transformer", "com.projity.grouping.core.transform.transformer.NodeTransformerFactory");
        digester.addSetProperties("*/transformer");
        digester.addCallMethod("*/transformer/formulaText", "setFormulaText", 0);
        digester.addSetNext("*/transformer", "addFactory", "com.projity.grouping.core.transform.transformer.NodeTransformerFactory");
    }

    public static TransformList getInstance(String string) {
        return (TransformList)Dictionary.get(category, string);
    }

    public static NodeFilter getNotVoidFilter() {
        return NotVoidFilter.getInstance();
    }

    public static NodeFilter getTrueFilter() {
        return (NodeFilter)TransformList.getInstance("user_filters").getTransform("Filter.True");
    }
}

