/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.assignment;

import com.projity.algorithm.CollectionIntervalGenerator;
import com.projity.algorithm.DoubleValue;
import com.projity.algorithm.InstantIntervalGenerator;
import com.projity.algorithm.IntervalGeneratorSet;
import com.projity.algorithm.Merge;
import com.projity.algorithm.Query;
import com.projity.algorithm.RangeIntervalGenerator;
import com.projity.algorithm.ReverseQuery;
import com.projity.algorithm.SelectFrom;
import com.projity.algorithm.TimeIteratorGenerator;
import com.projity.algorithm.buffer.CalculatedValues;
import com.projity.association.Association;
import com.projity.association.InvalidAssociationException;
import com.projity.configuration.Configuration;
import com.projity.datatype.CanSupplyRateUnit;
import com.projity.datatype.Duration;
import com.projity.datatype.DurationFormat;
import com.projity.datatype.ImageLink;
import com.projity.datatype.Rate;
import com.projity.datatype.RateFormat;
import com.projity.document.Document;
import com.projity.field.Field;
import com.projity.field.FieldContext;
import com.projity.functor.IntervalConsumer;
import com.projity.functor.ObjectVisitor;
import com.projity.options.AdvancedOption;
import com.projity.pm.assignment.Allocation;
import com.projity.pm.assignment.AssignmentDetail;
import com.projity.pm.assignment.AssignmentService;
import com.projity.pm.assignment.AssignmentSpecificFields;
import com.projity.pm.assignment.HasRequestDemandType;
import com.projity.pm.assignment.HasTimeDistributedData;
import com.projity.pm.assignment.TimeDistributedFields;
import com.projity.pm.assignment.TimeDistributedHelper;
import com.projity.pm.assignment.contour.AbstractContour;
import com.projity.pm.assignment.contour.AbstractContourBucket;
import com.projity.pm.assignment.contour.ContourBucketIntervalGenerator;
import com.projity.pm.assignment.contour.ContourFactory;
import com.projity.pm.assignment.contour.PersonalContour;
import com.projity.pm.assignment.functor.AssignmentFieldClosureCollection;
import com.projity.pm.assignment.functor.AssignmentFieldFunctor;
import com.projity.pm.assignment.functor.CalculatedValuesFunctor;
import com.projity.pm.assignment.functor.CostFunctor;
import com.projity.pm.assignment.functor.DateAtValueFunctor;
import com.projity.pm.assignment.functor.FixedCostFunctor;
import com.projity.pm.assignment.functor.PercentAllocFunctor;
import com.projity.pm.assignment.functor.PersonalContourMaker;
import com.projity.pm.assignment.functor.PrintValueFunctor;
import com.projity.pm.assignment.functor.ResourceAvailabilityFunctor;
import com.projity.pm.assignment.functor.ValueAtInstant;
import com.projity.pm.assignment.functor.WorkComparator;
import com.projity.pm.assignment.functor.WorkFunctor;
import com.projity.pm.assignment.functor.ZeroFunctor;
import com.projity.pm.assignment.timesheet.TimesheetHelper;
import com.projity.pm.assignment.timesheet.UpdatesFromTimesheet;
import com.projity.pm.calendar.WorkCalendar;
import com.projity.pm.costing.EarnedValueCalculator;
import com.projity.pm.costing.EarnedValueFields;
import com.projity.pm.costing.EarnedValueValues;
import com.projity.pm.costing.HasCostRateIndex;
import com.projity.pm.criticalpath.TaskSchedule;
import com.projity.pm.key.HasKey;
import com.projity.pm.key.HasKeyImpl;
import com.projity.pm.resource.Resource;
import com.projity.pm.resource.ResourceImpl;
import com.projity.pm.scheduling.BarClosure;
import com.projity.pm.scheduling.Delayable;
import com.projity.pm.scheduling.Schedule;
import com.projity.pm.scheduling.ScheduleInterval;
import com.projity.pm.scheduling.ScheduleUtil;
import com.projity.pm.snapshot.Snapshottable;
import com.projity.pm.task.BelongsToDocument;
import com.projity.pm.task.NormalTask;
import com.projity.pm.task.Project;
import com.projity.pm.task.Task;
import com.projity.pm.time.HasStartAndEnd;
import com.projity.pm.time.ImmutableInterval;
import com.projity.pm.time.MutableInterval;
import com.projity.server.data.DataObject;
import com.projity.strings.Messages;
import com.projity.util.Alert;
import com.projity.util.Environment;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.Predicate;

public final class Assignment
implements Schedule,
Association,
Allocation,
Delayable,
HasTimeDistributedData,
TimeDistributedFields,
EarnedValueValues,
EarnedValueFields,
AssignmentSpecificFields,
HasKey,
BelongsToDocument,
HasRequestDemandType,
UpdatesFromTimesheet,
CanSupplyRateUnit,
HasCostRateIndex,
Cloneable,
DataObject {
    static final long serialVersionUID = 56779404923241L;
    AssignmentDetail detail = null;
    private transient HasKeyImpl hasKey = new HasKeyImpl(true, this);
    private static Field unitsFieldInstance = null;
    private transient Date cachedStart = null;
    private transient Date cachedEnd = null;
    private transient int timesheetStatus = 0;
    private transient long lastTimesheetUpdate = 0L;
    private transient int workflowState = 1;
    private transient boolean timesheetAssignment = false;
    private static Field rateFieldInstance = null;
    private static Field requestDemandTypeInstance = null;
    private static transient BarClosure barClosureInstance = new BarClosure();
    private transient boolean dirty = true;

    public static Field getUnitsField() {
        if (unitsFieldInstance == null) {
            unitsFieldInstance = Configuration.getFieldFromId("Field.assignmentUnits");
        }
        return unitsFieldInstance;
    }

    public static Field getRateField() {
        if (rateFieldInstance == null) {
            rateFieldInstance = Configuration.getFieldFromId("Field.rate");
        }
        return rateFieldInstance;
    }

    public static Field getRequestDemandTypeField() {
        if (requestDemandTypeInstance == null) {
            requestDemandTypeInstance = Configuration.getFieldFromId("Field.requestDemandType");
        }
        return requestDemandTypeInstance;
    }

    public static Assignment getInstance(Task task, Resource resource, double d, int n) {
        return new Assignment(task, resource, d, n);
    }

    public static Assignment getInstance(Task task, Resource resource, double d, long l) {
        return new Assignment(task, resource, d, l);
    }

    private Assignment(Task task, Resource resource, double d, int n) {
        this.detail = new AssignmentDetail(task, resource, d, n, 0L);
    }

    public Assignment(Assignment assignment) {
        this.detail = assignment.detail;
    }

    public Assignment(AssignmentDetail assignmentDetail) {
        this.detail = assignmentDetail;
    }

    public boolean isReadOnly() {
        return this.getTask().isReadOnly();
    }

    public boolean isExternal() {
        return this.getTask().isExternal();
    }

    public static Predicate instanceofPredicate() {
        return new Predicate(){

            @Override
            public boolean evaluate(Object object) {
                return object instanceof Assignment;
            }
        };
    }

    public void usePropertiesOf(Assignment assignment) {
        boolean bl = this.isLabor() == assignment.isLabor();
        double d = this.getUnits();
        Rate rate = this.getRate();
        Resource resource = this.getResource();
        this.detail = (AssignmentDetail)assignment.detail.clone();
        this.detail.replaceResourceAndUnits(d, resource);
        if (!bl) {
            this.detail.setRate(rate);
        }
    }

    @Override
    public void setStart(long l) {
        this.detail.setStart(l);
    }

    @Override
    public int getRequestDemandType() {
        return this.detail.getRequestDemandType();
    }

    @Override
    public void setRequestDemandType(int n) {
        this.newDetail().setRequestDemandType(n);
    }

    public AbstractContourBucket[] getContour(Object object) {
        return this.detail.getContour(object);
    }

    private Assignment(Task task, Resource resource, double d, long l) {
        this.detail = new AssignmentDetail(task, resource, d, 0, l);
    }

    @Override
    public final double getUnits() {
        return this.detail.getUnits();
    }

    public final double getLaborUnits() {
        if (this.isLabor()) {
            return this.getUnits();
        }
        return 0.0;
    }

    public void setOvertimeWork(long l) {
        this.newDetail().setOvertimeWork(l);
    }

    public String toExternalId() {
        return this.getResourceId() + "." + this.getTaskId();
    }

    public String toString() {
        return this.getTask() + "/" + this.getResource();
    }

    public AbstractContour getWorkContour() {
        return this.detail.getWorkContour();
    }

    public void debugSetWorkContour(AbstractContour abstractContour) {
        this.newDetail().setWorkContour(abstractContour);
    }

    @Override
    public long getDelay() {
        return this.detail.getDelay();
    }

    @Override
    public void setDelay(long l) {
        this.newDetail().setDelay(l);
    }

    @Override
    public long getLevelingDelay() {
        return this.detail.getLevelingDelay();
    }

    @Override
    public void setLevelingDelay(long l) {
        this.newDetail().setLevelingDelay(l);
    }

    public long getDurationMillis() {
        return this.detail.getDuration();
    }

    private void setDurationMillis(long l) {
        this.newDetail().setDuration(l);
    }

    @Override
    public void setDuration(long l) {
        this.adjustRemainingDuration(l - this.getActualDuration(), false);
    }

    @Override
    public void adjustRemainingDuration(long l, boolean bl) {
        long l2 = this.getRemainingDuration();
        l = Duration.millis(l);
        if (this.getUnits() == 0.0) {
            l = 0L;
        }
        this.newDetail().adjustRemainingDuration(l);
    }

    public void adjustRemainingDurationIfWorkingAtTaskEnd(long l) {
        if (this.getEnd() >= this.getTask().getEnd() || !this.isInitialized()) {
            this.adjustRemainingDuration(l, false);
        }
    }

    @Override
    public void adjustRemainingWork(double d, boolean bl) {
        if (this.getPercentComplete() > 0.0) {
            this.makeContourPersonal();
        }
        this.newDetail().adjustRemainingWork(d);
    }

    @Override
    public void adjustRemainingUnits(double d, double d2, boolean bl, boolean bl2) {
        if (!this.isTemporal()) {
            return;
        }
        d2 = this.getRemainingUnits();
        NormalTask normalTask = (NormalTask)this.getTask();
        if (bl) {
            normalTask.getSchedulingRule().adjustRemainingUnits(this, d, d2, false, false);
        } else {
            if (this.getPercentComplete() > 0.0) {
                this.makeContourPersonal();
            }
            this.newDetail().adjustRemainingUnits(d);
        }
    }

    @Override
    public void setWork(long l, FieldContext fieldContext) {
        l = Duration.millis(l);
        if (this.isLabor() && l < 60000L) {
            l = (long)((double)l * Duration.timeUnitFactor(1));
            System.out.println("modifying invalid work to make it hours");
        }
        long l2 = l - this.getActualWork(null);
        WorkCalendar workCalendar = this.getEffectiveWorkCalendar();
        if (!FieldContext.hasInterval(fieldContext)) {
            long l3 = Duration.millis(this.getWork(fieldContext)) - Duration.millis(this.getActualWork(fieldContext));
            if (l3 == 0L && l2 == 0L) {
                this.adjustRemainingUnits(0.0, 0.0, true, false);
            } else if (this.getTaskSchedulingType() == 0) {
                this.adjustRemainingDuration(l2, false);
            } else if (this.getTaskSchedulingType() == 1 && l3 > 0L) {
                this.adjustRemainingWork((double)l2 / (double)l3, true);
            } else {
                this.newDetail().adjustRemainingDuration(l2);
            }
        } else {
            long l4 = workCalendar.adjustInsideCalendar(fieldContext.getStart(), false);
            long l5 = workCalendar.adjustInsideCalendar(fieldContext.getEnd(), true);
            if (l5 > l4) {
                this.setWorkInterval(l4, l5, l);
            }
            if (this.getRate().getValue() == 0.0) {
                double d = (double)l / (double)workCalendar.compare(l5, l4, false);
                this.forceUnits(d);
            }
        }
    }

    private boolean addWorkingTimeIfRequired(long l, FieldContext fieldContext, boolean bl) {
        WorkCalendar workCalendar = this.getEffectiveWorkCalendar();
        long l2 = workCalendar.adjustInsideCalendar(fieldContext.getStart(), false);
        long l3 = workCalendar.adjustInsideCalendar(fieldContext.getEnd(), true);
        if (l != 0L && !this.verifyBounds(l2, l3)) {
            return false;
        }
        if (l3 <= l2 && l != 0L) {
            long l4;
            l2 = fieldContext.getStart();
            l3 = fieldContext.getEnd();
            this.addCalendarTime(l2, l3);
            workCalendar = this.getEffectiveWorkCalendar();
            if (bl && this.getTask().getActualStart() == 0L) {
                l4 = workCalendar.adjustInsideCalendar(l2, false);
                ((NormalTask)this.getTask()).setActualStartNoEvent(l4);
            }
            l4 = workCalendar.compare(l3, l2, false);
            this.shift(l2, l3, l4);
            this.getTask().recalculateLater(this);
        }
        return true;
    }

    public void makeFlatIfPossible() {
        if (this.getWorkContour().isPersonal()) {
            this.detail.recalculateDuration();
            this.detail.setWorkContour(((PersonalContour)this.getWorkContour()).convertToFlatIfPossible());
        }
    }

    @Override
    public void setActualWork(long l, FieldContext fieldContext) {
        long l2 = Duration.millis(l);
        if (FieldContext.hasInterval(fieldContext)) {
            long l3;
            boolean bl = this.getPercentComplete() == 1.0;
            long l4 = this.work();
            if (!this.addWorkingTimeIfRequired(l, fieldContext, true)) {
                return;
            }
            if (this.getTask().getActualStart() == 0L && l != 0L) {
                l3 = this.getEffectiveWorkCalendar().adjustInsideCalendar(fieldContext.getStart(), false);
                this.getTask().setActualStart(l3);
            }
            l3 = this.getStop();
            this.setWork(l, fieldContext);
            if (fieldContext.getStart() > l3) {
                FieldContext fieldContext2 = new FieldContext();
                fieldContext2.setInterval(new ImmutableInterval(l3 == 0L ? this.getStart() : l3, fieldContext.getStart()));
                this.setWork(0L, fieldContext2);
            }
            if (l2 > 0L) {
                if (fieldContext.getEnd() > l3) {
                    this.setStop(fieldContext.getEnd());
                } else {
                    this.setStop(l3);
                }
            } else if (fieldContext.getStart() < l3 && fieldContext.getEnd() >= l3) {
                this.setStop(fieldContext.getStart());
            } else if (l3 != 0L) {
                this.setStop(l3);
            }
            long l5 = l4 - this.getActualWork(null);
            if (!bl) {
                ((NormalTask)this.getTask()).getSchedulingRule().adjustRemainingWork(this, l5, false);
            }
            this.getTask().recalculateLater(this);
        } else {
            if (l2 == 0L) {
                this.setPercentComplete(0.0);
                return;
            }
            long l6 = ReverseQuery.getDateAtValue(WORK, this, l2, false);
            this.setStop(l6);
        }
    }

    public boolean isInitialized() {
        return this.getProject().isInitialized();
    }

    public void adjustWorkingDuration(long l) {
        this.newDetail().adjustWorkingDuration(l);
    }

    @Override
    public WorkCalendar getEffectiveWorkCalendar() {
        return this.detail.getEffectiveWorkCalendar();
    }

    public Task getTask() {
        return this.detail.getTask();
    }

    @Override
    public String getTaskName() {
        return this.getTask().getName();
    }

    @Override
    public String getTaskId() {
        return "" + this.getTask().getId();
    }

    @Override
    public String getResourceName() {
        return this.getResource().getName();
    }

    @Override
    public String getResourceId() {
        return "" + this.getResource().getId();
    }

    @Override
    public long getStart() {
        return this.detail.getStart();
    }

    public long getFinish() {
        return this.detail.getFinish();
    }

    private long computeStart(long l, long l2) {
        long l3 = this.calcTotalDelay();
        long l4 = l;
        if (this.getPercentComplete() == 0.0 && l2 > l4) {
            l4 = l2;
        }
        if (l3 > 0L) {
            l4 = this.getEffectiveWorkCalendar().add(l4, l3, true);
        }
        return l4;
    }

    public long calcOffsetFrom(long l, long l2, boolean bl, boolean bl2, boolean bl3) {
        long l3 = bl ? this.computeStart(l, l2) : l;
        if (this.getPercentComplete() > 0.0) {
            l3 = this.getEffectiveWorkCalendar().add(l3, this.getActualDuration(), bl3);
        }
        long l4 = bl2 ? this.detail.getRemainingDuration() : this.detail.getDuration();
        long l5 = bl ? l4 : -l4;
        return this.getEffectiveWorkCalendar().add(l3, l5, bl3);
    }

    boolean isInRange(long l, long l2) {
        long l3 = this.getStart();
        return l2 > l3 && l < this.getEffectiveWorkCalendar().add(l3, this.detail.getDuration(), true);
    }

    public Resource getResource() {
        return this.detail.getResource();
    }

    public Closure forResource(Closure closure) {
        return new ObjectVisitor(closure){

            @Override
            protected final Object getObject(Object object) {
                return ((Assignment)object).getResource();
            }
        };
    }

    public Closure forTask(Closure closure) {
        return new ObjectVisitor(closure){

            @Override
            protected final Object getObject(Object object) {
                return ((Assignment)object).getTask();
            }
        };
    }

    public long calcWork() {
        if (!this.isLabor()) {
            return 0L;
        }
        return this.detail.calcWork();
    }

    @Override
    public long calcTotalDelay() {
        return this.detail.calcTotalDelay();
    }

    public AssignmentDetail getDetail() {
        return this.detail;
    }

    public ContourBucketIntervalGenerator contourGeneratorInstance(Object object) {
        return this.contourGeneratorInstance(object, this.getStart());
    }

    public ContourBucketIntervalGenerator contourGeneratorInstance(Object object, long l) {
        return ContourBucketIntervalGenerator.getInstance(this, object);
    }

    AssignmentFieldFunctor work(SelectFrom selectFrom) {
        ContourBucketIntervalGenerator contourBucketIntervalGenerator = this.contourGeneratorInstance(WORK);
        WorkFunctor workFunctor = WorkFunctor.getInstance(this, contourBucketIntervalGenerator.getWorkCalendar(), contourBucketIntervalGenerator, this.detail.calcOvertimeUnits());
        selectFrom.select(workFunctor).from(contourBucketIntervalGenerator);
        return workFunctor;
    }

    private AssignmentFieldFunctor percentAlloc(SelectFrom selectFrom, boolean bl) {
        ContourBucketIntervalGenerator contourBucketIntervalGenerator = this.contourGeneratorInstance(WORK);
        PercentAllocFunctor percentAllocFunctor = PercentAllocFunctor.getInstance(this, contourBucketIntervalGenerator.getWorkCalendar(), contourBucketIntervalGenerator, bl);
        selectFrom.select(percentAllocFunctor).from(contourBucketIntervalGenerator);
        return percentAllocFunctor;
    }

    private AssignmentFieldFunctor fixedCost(SelectFrom selectFrom) {
        ContourBucketIntervalGenerator contourBucketIntervalGenerator = this.contourGeneratorInstance(COST);
        FixedCostFunctor fixedCostFunctor = FixedCostFunctor.getInstance(this);
        selectFrom.select(fixedCostFunctor).from(contourBucketIntervalGenerator);
        return fixedCostFunctor;
    }

    private AssignmentFieldFunctor availability(SelectFrom selectFrom) {
        ResourceAvailabilityFunctor resourceAvailabilityFunctor = ResourceAvailabilityFunctor.getInstance(this);
        CollectionIntervalGenerator collectionIntervalGenerator = CollectionIntervalGenerator.getInstance(((ResourceImpl)this.detail.getResource()).getAvailabilityTable().getList());
        selectFrom.select(resourceAvailabilityFunctor).from(collectionIntervalGenerator);
        return resourceAvailabilityFunctor;
    }

    private static AssignmentFieldFunctor resourceAvailability(SelectFrom selectFrom, Resource resource) {
        ResourceAvailabilityFunctor resourceAvailabilityFunctor = ResourceAvailabilityFunctor.getInstance(resource);
        CollectionIntervalGenerator collectionIntervalGenerator = CollectionIntervalGenerator.getInstance(resource.getAvailabilityTable().getList());
        selectFrom.select(resourceAvailabilityFunctor).from(collectionIntervalGenerator);
        return resourceAvailabilityFunctor;
    }

    private AssignmentFieldFunctor cost(SelectFrom selectFrom, boolean bl) {
        if (this.detail.getCostContour().isPersonal()) {
            ContourBucketIntervalGenerator contourBucketIntervalGenerator = this.contourGeneratorInstance(COST);
            WorkFunctor workFunctor = WorkFunctor.getInstance(this, this.getEffectiveWorkCalendar(), contourBucketIntervalGenerator, this.detail.calcOvertimeUnits());
            selectFrom.select(workFunctor).from(contourBucketIntervalGenerator);
            return workFunctor;
        }
        boolean bl2 = this.isProratedCost();
        if (bl || bl2) {
            ContourBucketIntervalGenerator contourBucketIntervalGenerator = this.contourGeneratorInstance(WORK);
            CollectionIntervalGenerator collectionIntervalGenerator = CollectionIntervalGenerator.getInstance(this.detail.getResource().getCostRateTable(this.detail.getCostRateIndex()).getList());
            selectFrom.from(collectionIntervalGenerator).from(contourBucketIntervalGenerator);
            CostFunctor costFunctor = CostFunctor.getInstance(this, this.getEffectiveWorkCalendar(), contourBucketIntervalGenerator, this.detail.calcOvertimeUnits(), collectionIntervalGenerator, this.getStart(), bl2);
            selectFrom.select(costFunctor);
            return costFunctor;
        }
        long l = this.detail.getResource().getAccrueAt() == 1 ? this.getStart() : this.getFinish();
        ValueAtInstant valueAtInstant = ValueAtInstant.getInstance(l, this.calcAll(COST));
        selectFrom.select(valueAtInstant).from(InstantIntervalGenerator.getInstance(l));
        return valueAtInstant;
    }

    public boolean isProratedCost() {
        return this.detail.getResource().getAccrueAt() == 3;
    }

    public AssignmentFieldFunctor getDataSelect(Object object, SelectFrom selectFrom, boolean bl) {
        Field field;
        if (object == PERCENT_ALLOC) {
            return this.percentAlloc(selectFrom, false);
        }
        if (object == AVAILABILITY) {
            return this.availability(selectFrom);
        }
        if (object == COST) {
            return this.cost(selectFrom, bl);
        }
        if (object == OVERALLOCATED) {
            return this.work(selectFrom);
        }
        if (object == WORK || object == THIS_PROJECT) {
            return this.work(selectFrom);
        }
        if (object == ACTUAL_WORK) {
            selectFrom.whereInRange(this.detail.getStart(), this.getStop());
            return this.work(selectFrom);
        }
        if (object == REMAINING_WORK) {
            selectFrom.whereInRange(this.getResume(), this.detail.getFinish());
            return this.work(selectFrom);
        }
        if (object == ACTUAL_COST) {
            selectFrom.whereInRange(this.detail.getStart(), this.getStop());
            return this.cost(selectFrom, bl);
        }
        if (object == FIXED_COST) {
            selectFrom.whereInRange(this.detail.getStart(), this.getEnd());
            return this.fixedCost(selectFrom);
        }
        if (object == ACTUAL_FIXED_COST) {
            selectFrom.whereInRange(this.detail.getStart(), this.getStop());
            return this.fixedCost(selectFrom);
        }
        if (object == REMAINING_COST) {
            selectFrom.whereInRange(this.getResume(), this.detail.getFinish());
            return this.cost(selectFrom, bl);
        }
        if (object == BASELINE_COST) {
            return this.baselineData(COST, selectFrom);
        }
        if (object == BASELINE_WORK) {
            return this.baselineData(WORK, selectFrom);
        }
        if (object == ACWP) {
            selectFrom.whereInRange(this.detail.effectiveBaselineStart(), this.getCompletedOrStatusDate());
            return this.cost(selectFrom, bl);
        }
        if (object == BCWP) {
            selectFrom.whereInRange(this.detail.getStart(), this.getStatusDate());
            AssignmentFieldFunctor assignmentFieldFunctor = this.cost(selectFrom, bl);
            assignmentFieldFunctor.setMultiplier(this.efficiency());
            return assignmentFieldFunctor;
        }
        if (object == BCWS) {
            selectFrom.whereInRange(this.detail.effectiveBaselineStart(), this.getStatusDate());
            return this.baselineData(COST, selectFrom);
        }
        if (object instanceof Field && (field = (Field)object).isIndexed()) {
            Integer n = new Integer(field.getIndex());
            if (field.isWork()) {
                return this.baselineData(WORK, selectFrom, n);
            }
            return this.baselineData(COST, selectFrom, n);
        }
        return null;
    }

    public void calcDataBetween(Object object, long l, long l2) {
        SelectFrom selectFrom = SelectFrom.getInstance().whereInRange(l, l2);
        AssignmentFieldFunctor assignmentFieldFunctor = this.getDataSelect(object, selectFrom, false);
        RangeIntervalGenerator rangeIntervalGenerator = RangeIntervalGenerator.getInstance(l, l2, 86400000);
        PrintValueFunctor printValueFunctor = PrintValueFunctor.getInstance(assignmentFieldFunctor);
        Query.getInstance().selectFrom(selectFrom).groupBy(rangeIntervalGenerator).action(printValueFunctor).execute();
    }

    public double calcAll(Object object) {
        SelectFrom selectFrom = SelectFrom.getInstance();
        AssignmentFieldFunctor assignmentFieldFunctor = this.getDataSelect(object, selectFrom, true);
        Query.getInstance().selectFrom(selectFrom).execute();
        return assignmentFieldFunctor.getValue();
    }

    @Override
    public void buildReverseQuery(ReverseQuery reverseQuery) {
        SelectFrom selectFrom = SelectFrom.getInstance();
        reverseQuery.addField(this.getDataSelect(reverseQuery.getType(), selectFrom, false));
        reverseQuery.addGroupBy(IntervalGeneratorSet.extractUnshared(selectFrom.getFromIntervalGenerators()));
        reverseQuery.addSelectFrom(selectFrom);
    }

    @Override
    public void forEachWorkingInterval(Closure closure, boolean bl, WorkCalendar workCalendar) {
        WorkComparator workComparator = bl ? null : WorkComparator.getInstance();
        Merge merge = Merge.getInstance(closure, workComparator);
        Query.getInstance().groupBy(this.contourGeneratorInstance(WORK)).action(merge).execute();
    }

    @Override
    public void consumeIntervals(IntervalConsumer intervalConsumer) {
        barClosureInstance.initialize(intervalConsumer, this);
        boolean bl = this.getPercentComplete() > 0.0;
        MutableInterval mutableInterval = null;
        if (bl) {
            mutableInterval = new MutableInterval(this.getStart(), this.getStop());
            barClosureInstance.setBounds(mutableInterval);
        }
        this.forEachWorkingInterval(barClosureInstance, true, this.getEffectiveWorkCalendar());
        if (bl) {
            mutableInterval.setStart(mutableInterval.getEnd());
            mutableInterval.setEnd(this.getEnd());
            this.forEachWorkingInterval(barClosureInstance, true, this.getEffectiveWorkCalendar());
        }
        barClosureInstance.setBounds(null);
    }

    @Override
    public void moveInterval(Object object, long l, long l2, ScheduleInterval scheduleInterval, boolean bl) {
        long l3 = this.getEffectiveWorkCalendar().compare(l, scheduleInterval.getStart(), false);
        long l4 = this.getEffectiveWorkCalendar().compare(l2, scheduleInterval.getEnd(), false);
        boolean bl2 = l3 != 0L && l4 != 0L;
        long l5 = this.getStop();
        if (bl2) {
            this.shift(scheduleInterval.getStart(), scheduleInterval.getEnd(), l3);
        } else if (l4 != 0L) {
            this.extend(scheduleInterval.getStart(), scheduleInterval.getEnd(), l4);
        } else {
            this.extendBefore(scheduleInterval.getStart(), scheduleInterval.getEnd(), l3);
        }
        this.setStop(l5);
        if (!bl) {
            this.getTask().updateCachedDuration();
            this.getTask().recalculate(object);
        }
    }

    public long getDateAtValue(Object object, double d) {
        SelectFrom selectFrom = SelectFrom.getInstance();
        AssignmentFieldFunctor assignmentFieldFunctor = object == COST ? this.cost(selectFrom, true) : this.work(selectFrom);
        DateAtValueFunctor dateAtValueFunctor = DateAtValueFunctor.getInstance(d, AssignmentFieldClosureCollection.getInstance(assignmentFieldFunctor));
        selectFrom.select(dateAtValueFunctor);
        Query.getInstance().selectFrom(selectFrom).execute();
        return dateAtValueFunctor.getDate();
    }

    public long getDateAtWorkFraction(double d) {
        return this.getDateAtValue(WORK, this.calcAll(WORK) * d);
    }

    private AssignmentFieldFunctor baselineData(Object object, SelectFrom selectFrom) {
        AssignmentFieldFunctor assignmentFieldFunctor;
        Assignment assignment = this.detail.getBaselineAssignment();
        if (assignment == null) {
            assignmentFieldFunctor = ZeroFunctor.getInstance();
            selectFrom.select(assignmentFieldFunctor).from(RangeIntervalGenerator.empty());
        } else {
            assignmentFieldFunctor = assignment.getDataSelect(object, selectFrom, false);
        }
        return assignmentFieldFunctor;
    }

    public Assignment getBaselineAssignment(Object object, boolean bl) {
        return this.detail.getBaselineAssignment(object, bl);
    }

    private AssignmentFieldFunctor baselineData(Object object, SelectFrom selectFrom, Object object2) {
        AssignmentFieldFunctor assignmentFieldFunctor;
        Assignment assignment = this.detail.getBaselineAssignment(object2, false);
        if (assignment == null) {
            assignmentFieldFunctor = ZeroFunctor.getInstance();
            selectFrom.select(assignmentFieldFunctor).from(RangeIntervalGenerator.empty());
        } else {
            assignmentFieldFunctor = assignment.getDataSelect(object, selectFrom, false);
        }
        return assignmentFieldFunctor;
    }

    private long getStatusDate() {
        return this.getProject().getStatusDate();
    }

    private long getCompletedOrStatusDate() {
        return Math.min(this.getStatusDate(), this.detail.getStop());
    }

    public double getCost() {
        return this.calcAll(COST);
    }

    void setTotalDelay(long l) {
        this.setDelay(l);
        this.setLevelingDelay(0L);
    }

    public void setInterval(Object object, long l, long l2, double d) {
        if (object == ACTUAL_WORK || object == WORK || object == REMAINING_WORK) {
            if (d != 0.0 && !this.verifyBounds(l, l2)) {
                return;
            }
            if (Environment.isImporting()) {
                WorkCalendar workCalendar = this.getEffectiveWorkCalendar();
                l = workCalendar.adjustInsideCalendar(l, false);
                l2 = workCalendar.adjustInsideCalendar(l2, true);
            }
            this.setWorkInterval(l, l2, d);
            if (object == ACTUAL_WORK && l2 > this.getStop() && d > 0.0) {
                this.setStop(l2);
            }
        } else if (TimeDistributedHelper.isWork(object)) {
            Object object2 = TimeDistributedHelper.baselineForData(object);
            Assignment assignment = this.getBaselineAssignment(object2, true);
            TaskSchedule taskSchedule = assignment.getTaskScheduleOfAssignment();
            long l3 = taskSchedule.getStart();
            long l4 = taskSchedule.getFinish();
            if (l3 == 0L || l3 > l) {
                taskSchedule.setStart(l);
            }
            if (l4 == 0L || l4 < l2) {
                taskSchedule.setEnd(l2);
            }
            assignment.setWorkInterval(l, l2, d);
        }
    }

    TaskSchedule getTaskScheduleOfAssignment() {
        return this.detail.getTaskSchedule();
    }

    public boolean verifyBounds(long l, long l2) {
        if (Environment.isImporting()) {
            return true;
        }
        if (this.getProject().getStart() > l) {
            return Alert.okCancel(Messages.getString("Message.allowDistrbutedStartBeforeProjectStart"));
        }
        if (l < this.getTask().getStart()) {
            return Alert.okCancel(Messages.getString("Message.allowDistrbutedStartBeforeTaskStart"));
        }
        return true;
    }

    private void setWorkInterval(long l, long l2, double d) {
        long l3;
        this.moveDelayToContour();
        long l4 = this.getStart();
        WorkCalendar workCalendar = this.getEffectiveWorkCalendar();
        if (l2 > this.getFinish()) {
            if (d == 0.0) {
                this.setEnd(l);
                return;
            }
            this.makeContourPersonal();
            l3 = workCalendar.compare(l2, this.getFinish(), false);
            this.setDurationMillis(this.getDurationMillis() + l3);
            PersonalContour personalContour = PersonalContour.addEmptyBucket(this.getWorkContour(), l3, true);
            this.newDetail().setWorkContour(personalContour);
            if (l2 > this.getTask().getEnd()) {
                this.getTask().setEnd(l2);
            }
        } else if (l < l4) {
            l3 = this.getTask().getStart();
            if (l < l3) {
                long l5 = workCalendar.compare(l3, l, false);
                this.setDurationMillis(this.getDurationMillis() + l5);
                if (!this.getWorkContour().isPersonal()) {
                    this.makeContourPersonal();
                }
                this.newDetail().setWorkContour(PersonalContour.addEmptyBucket(this.getWorkContour(), l5, false));
                this.getTask().setScheduleConstraintAndUpdate(5, l);
                l3 = this.getTask().getStart();
            }
            l4 = l3;
        }
        l3 = workCalendar.compare(l, l4, false);
        long l6 = workCalendar.compare(l2, l4, false);
        if (l3 == l6) {
            return;
        }
        if (!this.getWorkContour().isPersonal()) {
            this.makeContourPersonal();
        }
        PersonalContour personalContour = ((PersonalContour)this.getWorkContour()).setInterval(l3, l6, d /= (double)(l6 - l3));
        this.extractDelayFromContour(personalContour);
        this.newDetail().setWorkContour(personalContour);
        this.newDetail().recalculateDuration();
        this.getTask().updateCachedDuration();
    }

    @Override
    public void moveRemainingToDate(long l) {
        long l2 = this.getResume();
        long l3 = this.getEnd();
        long l4 = this.getEffectiveWorkCalendar().compare(l, l2, false);
        this.shift(l2, l3, l4);
        long l5 = this.getEffectiveWorkCalendar().compare(l, this.getStart(), false);
        if (l5 > 0L) {
            this.newDetail().removeEmptyBucketAtDuration(l5);
        }
    }

    public void shift(long l, long l2, long l3) {
        WorkCalendar workCalendar = this.getEffectiveWorkCalendar();
        if (this.getTask().inProgress() && workCalendar.compare(this.getStop(), l, false) > 0L) {
            return;
        }
        long l4 = this.getTask().getStart();
        l = Math.max(l, this.getStop());
        l = Math.max(l, l4);
        long l5 = workCalendar.compare(l, l4, false);
        long l6 = workCalendar.compare(l2, l4, false);
        if (this.getResume() != 0L && l >= this.getResume()) {
            long l7 = this.detail.getSplitDuration();
            l5 -= l7;
            l6 -= l7;
        }
        if (l5 >= l6) {
            return;
        }
        boolean bl = workCalendar.compare(this.getStart(), l, false) == 0L;
        MutableInterval mutableInterval = this.getRangeThatIntervalCanBeMoved(l, l5, l6);
        if (bl) {
            mutableInterval.setStart(mutableInterval.getStart() - this.calcTotalDelay());
        }
        l3 = l3 > 0L ? Math.min(l3, mutableInterval.getEnd() - l6) : Math.max(l3, mutableInterval.getStart() - l5);
        if (bl) {
            this.setTotalDelay(this.calcTotalDelay() + l3);
        } else {
            this.newDetail().shift(l5, l6, l3);
        }
    }

    private MutableInterval getRangeThatIntervalCanBeMoved(long l, long l2, long l3) {
        MutableInterval mutableInterval = this.getRangeThatIntervalCanBeMoved(l2, l3);
        if (this.getEffectiveWorkCalendar().compare(this.getStart(), l, false) == 0L) {
            mutableInterval.setStart(mutableInterval.getStart() - this.calcTotalDelay());
        }
        return mutableInterval;
    }

    public MutableInterval getRangeThatIntervalCanBeMoved(long l, long l2) {
        return this.detail.getRangeThatIntervalCanBeMoved(l, l2);
    }

    public void extend(long l, long l2, long l3) {
        if (l2 < this.getStop()) {
            return;
        }
        WorkCalendar workCalendar = this.getEffectiveWorkCalendar();
        long l4 = workCalendar.compare(l, this.getStart(), false);
        long l5 = workCalendar.compare(l2, this.getStart(), false);
        MutableInterval mutableInterval = this.getRangeThatIntervalCanBeMoved(l, l4, l5);
        l3 = l3 > 0L ? Math.min(l3, mutableInterval.getEnd() - l5) : Math.max(l3, l4 - l5);
        this.newDetail().extend(l5, l3);
    }

    @Override
    public void split(Object object, long l, long l2) {
        if ((l = Math.max(l, this.getResume())) >= l2) {
            return;
        }
        long l3 = this.getEffectiveWorkCalendar().compare(l2, l, false);
        this.shift(l, this.getEnd(), l3);
    }

    public void extendBefore(long l, long l2, long l3) {
        if (l < this.getStop()) {
            return;
        }
        WorkCalendar workCalendar = this.getEffectiveWorkCalendar();
        boolean bl = workCalendar.compare(this.getStart(), l, false) == 0L;
        long l4 = workCalendar.compare(l, this.getStart(), false);
        long l5 = workCalendar.compare(l2, this.getStart(), false);
        MutableInterval mutableInterval = this.getRangeThatIntervalCanBeMoved(l, l4, l4);
        l3 = l3 > 0L ? Math.min(l3, l5 - l4) : Math.max(l3, mutableInterval.getStart() - l4);
        if (bl) {
            this.setTotalDelay(this.calcTotalDelay() + l3);
        }
        this.newDetail().extendBefore(l4, l3);
    }

    public void addCalendarTime(long l, long l2) {
        this.newDetail().addCalendarTime(l, l2);
    }

    @Override
    public int getWorkContourType() {
        return this.getWorkContour().getType();
    }

    @Override
    public void setWorkContourType(int n) {
        this.newDetail().setWorkContour(ContourFactory.getInstance(n));
    }

    @Override
    public final double getRemainingUnits() {
        if (!this.isLabor()) {
            return 1.0;
        }
        long l = this.getRemainingDuration();
        if ((double)l == 0.0) {
            return this.getWorkContour().getLastBucketUnits();
        }
        long l2 = this.getRemainingWork();
        if (l2 == 0L) {
            return 1.0;
        }
        return (double)l2 / (double)l;
    }

    public final double getRemainingLaborUnits() {
        if (this.isLabor()) {
            return this.getRemainingUnits();
        }
        return 0.0;
    }

    @Override
    public Object getLeft() {
        return this.getTask();
    }

    @Override
    public Object getRight() {
        return this.getResource();
    }

    @Override
    public void testValid(boolean bl) throws InvalidAssociationException {
    }

    @Override
    public void copyPrincipalFieldsFrom(Association association) {
        Assignment assignment = (Assignment)association;
        double d = assignment.getUnits();
        if (assignment.isLabor()) {
            this.adjustRemainingUnits(assignment.getUnits(), 0.0, true, false);
            this.detail.setUnits(d);
        } else {
            this.detail.rate = assignment.detail.getRate();
            this.detail.setDuration(this.getDuration());
        }
        this.getTask().updateCachedDuration();
    }

    public void forceUnits(double d) {
        this.newDetail().setUnits(d);
    }

    @Override
    public void doAddService(Object object) {
        AssignmentService.getInstance().connect(this, object);
    }

    @Override
    public void doRemoveService(Object object) {
        AssignmentService.getInstance().remove(this, object, true);
    }

    @Override
    public void doUpdateService(Object object) {
        Assignment.getUnitsField().fireEvent(this, this, null);
    }

    @Override
    public boolean isDefault() {
        return this.getTask() == NormalTask.getUnassignedInstance() || this.getResource() == ResourceImpl.getUnassignedInstance();
    }

    @Override
    public boolean isReadOnlyUnits(FieldContext fieldContext) {
        return false;
    }

    @Override
    public double acwp(long l, long l2) {
        if (!this.isInRange(l, l2)) {
            return 0.0;
        }
        Query query = Query.getInstance();
        SelectFrom selectFrom = SelectFrom.getInstance().whereInRange(Math.max(l, this.detail.effectiveBaselineStart()), Math.min(l2, this.getCompletedOrStatusDate()));
        query.selectFrom(selectFrom).action(this.cost(selectFrom, false)).execute();
        return ((DoubleValue)((Object)query.getActionVisitor())).getValue();
    }

    @Override
    public double bcws(long l, long l2) {
        if (!this.isInRange(l, l2)) {
            return 0.0;
        }
        if (AdvancedOption.getInstance().isEarnedValueFieldsCumulative()) {
            l = this.getStart();
        }
        Query query = Query.getInstance();
        SelectFrom selectFrom = SelectFrom.getInstance().whereInRange(Math.max(l, this.detail.effectiveBaselineStart()), Math.min(l2, this.getStatusDate()));
        query.selectFrom(selectFrom).action(this.baselineData(COST, selectFrom)).execute();
        return ((DoubleValue)((Object)query.getActionVisitor())).getValue();
    }

    public double efficiency() {
        Assignment assignment = this.detail.getBaselineAssignment();
        if (assignment == null) {
            return 0.0;
        }
        long l = assignment.work();
        if (l == 0L) {
            return 0.0;
        }
        long l2 = this.work();
        if ((double)l2 == 0.0) {
            return 1.0;
        }
        return (double)l / (double)l2;
    }

    @Override
    public double bcwp(long l, long l2) {
        double d;
        if (!this.isInRange(l, l2)) {
            return 0.0;
        }
        if ((l2 = Math.min(l2, this.getStatusDate())) == 0L) {
            return 0.0;
        }
        if (AdvancedOption.getInstance().isEarnedValueFieldsCumulative()) {
            l = this.getStart();
        }
        if ((d = this.actualCost(l, l2)) == 0.0) {
            return 0.0;
        }
        return this.efficiency() * d;
    }

    @Override
    public double bac(long l, long l2) {
        if (!this.isInRange(l, l2)) {
            return 0.0;
        }
        Query query = Query.getInstance();
        SelectFrom selectFrom = SelectFrom.getInstance().whereInRange(l, l2);
        query.selectFrom(selectFrom).action(this.baselineData(COST, selectFrom)).execute();
        return ((DoubleValue)((Object)query.getActionVisitor())).getValue();
    }

    @Override
    public double cost(long l, long l2) {
        if (!this.isInRange(l, l2)) {
            return 0.0;
        }
        Query query = Query.getInstance();
        SelectFrom selectFrom = SelectFrom.getInstance().whereInRange(l, l2);
        query.selectFrom(selectFrom).action(this.cost(selectFrom, false)).execute();
        return ((DoubleValue)((Object)query.getActionVisitor())).getValue();
    }

    @Override
    public long work(long l, long l2) {
        if (!this.isInRange(l, l2)) {
            return 0L;
        }
        Query query = Query.getInstance();
        SelectFrom selectFrom = SelectFrom.getInstance().whereInRange(l, l2);
        query.selectFrom(selectFrom).action(this.work(selectFrom)).execute();
        return (long)((DoubleValue)((Object)query.getActionVisitor())).getValue();
    }

    @Override
    public double actualCost(long l, long l2) {
        if (!this.isInRange(l, l2)) {
            return 0.0;
        }
        Query query = Query.getInstance();
        SelectFrom selectFrom = SelectFrom.getInstance().whereInRange(Math.max(l, this.detail.getStart()), Math.min(l2, this.getStop()));
        query.selectFrom(selectFrom).action(this.cost(selectFrom, false)).execute();
        return ((DoubleValue)((Object)query.getActionVisitor())).getValue();
    }

    @Override
    public long actualWork(long l, long l2) {
        if (!this.isInRange(l, l2)) {
            return 0L;
        }
        if (!this.isLabor()) {
            return 0L;
        }
        Query query = Query.getInstance();
        SelectFrom selectFrom = SelectFrom.getInstance().whereInRange(Math.max(l, this.detail.getStart()), Math.min(l2, this.getStop()));
        query.selectFrom(selectFrom).action(this.work(selectFrom)).execute();
        return (long)((DoubleValue)((Object)query.getActionVisitor())).getValue();
    }

    @Override
    public long remainingWork(long l, long l2) {
        if (!this.isInRange(l, l2)) {
            return 0L;
        }
        if (!this.isLabor()) {
            return 0L;
        }
        Query query = Query.getInstance();
        SelectFrom selectFrom = SelectFrom.getInstance().whereInRange(Math.max(l, this.detail.getStop()), Math.min(l2, this.getEnd()));
        query.selectFrom(selectFrom).action(this.work(selectFrom)).execute();
        return (long)((DoubleValue)((Object)query.getActionVisitor())).getValue();
    }

    @Override
    public double baselineCost(long l, long l2) {
        Query query = Query.getInstance();
        SelectFrom selectFrom = SelectFrom.getInstance().whereInRange(l, l2);
        query.selectFrom(selectFrom).action(this.baselineData(COST, selectFrom)).execute();
        return ((DoubleValue)((Object)query.getActionVisitor())).getValue();
    }

    @Override
    public long baselineWork(long l, long l2) {
        if (!this.isLabor()) {
            return 0L;
        }
        Query query = Query.getInstance();
        SelectFrom selectFrom = SelectFrom.getInstance().whereInRange(l, l2);
        query.selectFrom(selectFrom).action(this.baselineData(WORK, selectFrom)).execute();
        return (long)((DoubleValue)((Object)query.getActionVisitor())).getValue();
    }

    private boolean isFieldHidden(FieldContext fieldContext) {
        return fieldContext != null && !this.isInRange(fieldContext.getStart(), fieldContext.getEnd());
    }

    private boolean isEarnedValueFieldHidden(FieldContext fieldContext) {
        if (this.isFieldHidden(fieldContext)) {
            return true;
        }
        return this.getStatusDate() < fieldContext.getStart();
    }

    private boolean isBaselineFieldHidden(int n, FieldContext fieldContext) {
        Assignment assignment = this.getBaselineAssignment(new Integer(n), false);
        if (assignment == null) {
            return true;
        }
        if (fieldContext == null) {
            return false;
        }
        return fieldContext.getStart() >= assignment.getFinish() || fieldContext.getEnd() <= assignment.getStart();
    }

    @Override
    public boolean fieldHideCost(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideWork(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideActualCost(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideActualWork(FieldContext fieldContext) {
        return this.fieldHideWork(fieldContext);
    }

    @Override
    public boolean fieldHideBaselineCost(int n, FieldContext fieldContext) {
        return this.isBaselineFieldHidden(n, fieldContext);
    }

    @Override
    public boolean fieldHideBaselineWork(int n, FieldContext fieldContext) {
        return this.isBaselineFieldHidden(n, fieldContext);
    }

    @Override
    public boolean fieldHideAcwp(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideBac(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideBcwp(FieldContext fieldContext) {
        return this.isEarnedValueFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideBcws(FieldContext fieldContext) {
        return this.isEarnedValueFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideCv(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideSv(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideEac(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideVac(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideCpi(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideSpi(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideCvPercent(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideSvPercent(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideTcpi(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public double getCost(FieldContext fieldContext) {
        return this.cost(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    public long work() {
        return this.work(0L, FieldContext.defaultEnd);
    }

    @Override
    public long getWork(FieldContext fieldContext) {
        long l = this.work(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
        if (!this.isLabor()) {
            l = Duration.setAsNonTemporal(l);
        }
        return l;
    }

    @Override
    public double getActualCost(FieldContext fieldContext) {
        return this.actualCost(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public long getActualWork(FieldContext fieldContext) {
        return this.actualWork(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public long getRemainingWork(FieldContext fieldContext) {
        return this.remainingWork(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public long getRemainingWork() {
        return this.getRemainingWork(null);
    }

    @Override
    public double getBaselineCost(int n, FieldContext fieldContext) {
        return this.baselineCost(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public long getBaselineWork(int n, FieldContext fieldContext) {
        return this.baselineWork(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getAcwp(FieldContext fieldContext) {
        return this.acwp(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getBac(FieldContext fieldContext) {
        return this.bac(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getBcwp(FieldContext fieldContext) {
        return this.bcwp(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getBcws(FieldContext fieldContext) {
        return this.bcws(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getCv(FieldContext fieldContext) {
        return EarnedValueCalculator.getInstance().cv(this, FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getSv(FieldContext fieldContext) {
        return EarnedValueCalculator.getInstance().sv(this, FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getEac(FieldContext fieldContext) {
        return EarnedValueCalculator.getInstance().eac(this, FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getVac(FieldContext fieldContext) {
        return EarnedValueCalculator.getInstance().vac(this, FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getCpi(FieldContext fieldContext) {
        return EarnedValueCalculator.getInstance().cpi(this, FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getSpi(FieldContext fieldContext) {
        return EarnedValueCalculator.getInstance().spi(this, FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getCsi(FieldContext fieldContext) {
        return EarnedValueCalculator.getInstance().csi(this, FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getCvPercent(FieldContext fieldContext) {
        return EarnedValueCalculator.getInstance().cvPercent(this, FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getSvPercent(FieldContext fieldContext) {
        return EarnedValueCalculator.getInstance().svPercent(this, FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getTcpi(FieldContext fieldContext) {
        return EarnedValueCalculator.getInstance().tcpi(this, FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public Date getCreated() {
        return this.hasKey.getCreated();
    }

    @Override
    public long getId() {
        return this.hasKey.getId();
    }

    @Override
    public String getName() {
        return "" + this.getLeft() + " " + this.getRight();
    }

    @Override
    public String getName(FieldContext fieldContext) {
        if (fieldContext == null) {
            return "???";
        }
        if (fieldContext.isLeftAssociation()) {
            return this.getRight().toString();
        }
        return this.getLeft().toString();
    }

    @Override
    public long getUniqueId() {
        return this.hasKey.getUniqueId();
    }

    @Override
    public void setCreated(Date date) {
        this.hasKey.setCreated(date);
    }

    @Override
    public void setId(long l) {
        this.hasKey.setId(l);
    }

    @Override
    public void setName(String string) {
        this.hasKey.setName(string);
    }

    @Override
    public void setUniqueId(long l) {
        this.hasKey.setUniqueId(l);
    }

    @Override
    public Document getDocument() {
        return this.getProject();
    }

    public Document getDocument(boolean bl) {
        return bl ? this.getTask().getDocument() : this.getResource().getDocument();
    }

    public Query workQuery() {
        Query query = Query.getInstance();
        SelectFrom selectFrom = SelectFrom.getInstance();
        query.selectFrom(selectFrom).action(this.work(selectFrom));
        return query;
    }

    public void calcDataBetween(Object object, HasStartAndEnd hasStartAndEnd, CalculatedValues calculatedValues) {
        SelectFrom selectFrom = SelectFrom.getInstance();
        AssignmentFieldFunctor assignmentFieldFunctor = this.getDataSelect(object, selectFrom, false);
        Assignment.calcDataBetween(assignmentFieldFunctor, selectFrom, hasStartAndEnd, calculatedValues);
    }

    public static void calcResourceAvailabilityBetween(Resource resource, HasStartAndEnd hasStartAndEnd, CalculatedValues calculatedValues) {
        SelectFrom selectFrom = SelectFrom.getInstance();
        AssignmentFieldFunctor assignmentFieldFunctor = Assignment.resourceAvailability(selectFrom, resource);
        Assignment.calcDataBetween(assignmentFieldFunctor, selectFrom, hasStartAndEnd, calculatedValues);
    }

    public static void calcDataBetween(AssignmentFieldFunctor assignmentFieldFunctor, SelectFrom selectFrom, HasStartAndEnd hasStartAndEnd, CalculatedValues calculatedValues) {
        if (hasStartAndEnd != null) {
            selectFrom.whereInRange(hasStartAndEnd.getStart(), hasStartAndEnd.getEnd());
        }
        CalculatedValuesFunctor calculatedValuesFunctor = CalculatedValuesFunctor.getInstance(assignmentFieldFunctor, calculatedValues, (TimeIteratorGenerator)hasStartAndEnd);
        Query query = Query.getInstance();
        query.selectFrom(selectFrom);
        if (hasStartAndEnd != null && hasStartAndEnd instanceof TimeIteratorGenerator) {
            query.groupBy((TimeIteratorGenerator)hasStartAndEnd).action(calculatedValuesFunctor);
        } else {
            selectFrom.select(calculatedValuesFunctor);
        }
        query.execute();
    }

    @Override
    public long getResourceAvailability() {
        return this.detail.getResourceAvailability();
    }

    @Override
    public Collection childrenToRollup() {
        return null;
    }

    @Override
    public double getMostLoadedAssignmentUnits() {
        return this.getUnits();
    }

    public void makeContourPersonal() {
        Object object = WORK;
        ContourBucketIntervalGenerator contourBucketIntervalGenerator = this.contourGeneratorInstance(object);
        PersonalContourMaker personalContourMaker = PersonalContourMaker.getInstance(this, contourBucketIntervalGenerator);
        Query.getInstance().selectFrom(SelectFrom.getInstance().select(personalContourMaker).from(contourBucketIntervalGenerator).all()).execute();
        this.newDetail().setContour(object, personalContourMaker.getList());
        this.detail.recalculateDuration();
    }

    private AssignmentDetail newDetail() {
        this.detail = (AssignmentDetail)this.detail.clone();
        if (this.getTask() != null) {
            this.getTask().setDirty(true);
        }
        this.setDirty(true);
        return this.detail;
    }

    @Override
    public long getElapsedDuration() {
        return this.detail.getElapsedDuration();
    }

    @Override
    public long getDuration() {
        return this.detail.getDuration();
    }

    @Override
    public double getPercentComplete() {
        return this.detail.getPercentComplete();
    }

    @Override
    public void setPercentComplete(double d) {
        this.newDetail().setPercentComplete(d);
    }

    @Override
    public long getEnd() {
        return this.detail.getEnd();
    }

    @Override
    public void setEnd(long l) {
        this.detail.setEnd(l);
    }

    @Override
    public long getActualStart() {
        return this.detail.getActualStart();
    }

    @Override
    public void setActualStart(long l) {
        this.newDetail().setActualStart(l);
    }

    @Override
    public void setRemainingDuration(long l) {
        this.newDetail().setRemainingDuration(l);
    }

    @Override
    public long getActualFinish() {
        return this.detail.getActualFinish();
    }

    @Override
    public void setActualFinish(long l) {
        this.newDetail().setActualFinish(l);
    }

    @Override
    public long getResume() {
        return this.detail.getResume();
    }

    @Override
    public long getActualDuration() {
        return this.detail.getActualDuration();
    }

    @Override
    public void setActualDuration(long l) {
        this.newDetail().setActualDuration(l);
    }

    @Override
    public long getRemainingDuration() {
        return this.detail.getRemainingDuration();
    }

    @Override
    public void setResume(long l) {
        this.newDetail().setResume(l);
    }

    @Override
    public long getStop() {
        return this.detail.getStop();
    }

    @Override
    public void setStop(long l) {
        if (l < this.getStart()) {
            l = this.getStart();
        } else if (l > this.getEnd()) {
            l = this.getEnd();
        }
        long l2 = this.getStop();
        if (l2 == l) {
            return;
        }
        if (l < l2) {
            this.newDetail().removeFillerAfter(l);
        }
        if (l2 > 0L && this.getDependencyStart() > l2 && this.getDependencyStart() < l) {
            this.makeContourPersonal();
        }
        this.newDetail().setStop(l);
    }

    @Override
    public void clearDuration() {
        this.newDetail().clearDuration();
    }

    @Override
    public long getDependencyStart() {
        return this.detail.getDependencyStart();
    }

    @Override
    public void setDependencyStart(long l) {
        this.detail.setDependencyStart(l);
    }

    public boolean isNormal() {
        return false;
    }

    public boolean isCritical() {
        return false;
    }

    public boolean isSummary() {
        return false;
    }

    public boolean isMilestone() {
        return false;
    }

    public boolean isAssignment() {
        return true;
    }

    public void setTaskSchedule(TaskSchedule taskSchedule) {
        this.newDetail().setTaskSchedule(taskSchedule);
    }

    public boolean inProgress() {
        double d = this.getPercentComplete();
        return d > 0.0 && d < 1.0;
    }

    @Override
    public boolean isComplete() {
        return this.getPercentComplete() == 1.0;
    }

    public boolean isUnstarted() {
        return this.getPercentComplete() == 0.0;
    }

    public boolean isMine() {
        return this.getResource().isMe();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        this.hasKey.serialize(objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.hasKey = HasKeyImpl.deserialize(objectInputStream, this);
    }

    public Object clone() {
        try {
            Assignment assignment = (Assignment)super.clone();
            assignment.hasKey = new HasKeyImpl(true, assignment);
            assignment.setName(this.getName());
            assignment.detail = (AssignmentDetail)this.detail.clone();
            return assignment;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public Object cloneWithTask(Task task) {
        Assignment assignment = (Assignment)this.clone();
        assignment.detail.setTask(task);
        return assignment;
    }

    public Object cloneWithResource(Resource resource) {
        Assignment assignment = (Assignment)this.clone();
        assignment.detail.setResource(resource);
        return assignment;
    }

    public Object cloneWithResourceAndTask(Resource resource, Task task) {
        Assignment assignment = (Assignment)this.clone();
        assignment.detail.setResource(resource);
        assignment.detail.setTask(task);
        return assignment;
    }

    public void convertToBaselineAssignment(boolean bl) {
        this.detail.convertToBaselineAssignment(bl);
    }

    public boolean hasDuration() {
        return this.detail.hasDuration();
    }

    @Override
    public void setRemainingWork(long l, FieldContext fieldContext) {
        this.setActualWork(this.getWork(fieldContext) - Duration.millis(l), fieldContext);
    }

    @Override
    public boolean isReadOnlyWork(FieldContext fieldContext) {
        if (fieldContext == null) {
            return this.isMaterial();
        }
        return !this.isActiveBetween(fieldContext.getStart(), fieldContext.getEnd());
    }

    public boolean isActiveBetween(long l, long l2) {
        return this.getEffectiveWorkCalendar().compare(l2, l, false) > 0L;
    }

    @Override
    public boolean isReadOnlyActualWork(FieldContext fieldContext) {
        return false;
    }

    @Override
    public boolean isReadOnlyRemainingWork(FieldContext fieldContext) {
        return this.isReadOnlyWork(fieldContext);
    }

    @Override
    public double getFixedCost(FieldContext fieldContext) {
        return 0.0;
    }

    @Override
    public double getActualFixedCost(FieldContext fieldContext) {
        return 0.0;
    }

    @Override
    public boolean fieldHideActualFixedCost(FieldContext fieldContext) {
        return true;
    }

    @Override
    public double fixedCost(long l, long l2) {
        return this.getTask().fixedCost(l, l2);
    }

    @Override
    public double actualFixedCost(long l, long l2) {
        return this.getTask().actualFixedCost(l, l2);
    }

    @Override
    public void setFixedCost(double d, FieldContext fieldContext) {
    }

    @Override
    public boolean isReadOnlyFixedCost(FieldContext fieldContext) {
        return true;
    }

    @Override
    public boolean isLabor() {
        return this.getResource().isLabor();
    }

    public boolean isTemporal() {
        return this.detail.isTemporal();
    }

    public void setRateUnit(int n) {
        this.detail.setRateUnit(n);
        this.getTask().updateCachedDuration();
    }

    @Override
    public final Rate getRate() {
        return this.detail.getRate();
    }

    private int getTaskSchedulingType() {
        return ((NormalTask)this.getTask()).getSchedulingType();
    }

    public String valuesString() {
        return "Duration=" + DurationFormat.format(this.getDuration()) + " Work=" + DurationFormat.format(this.getWork(null)) + " Units=" + this.getUnits() + " contour=" + this.getWorkContour().toString(this.getDuration());
    }

    @Override
    public final void setRate(Rate rate) {
        if (rate.isNonTemporal() == this.getRate().isNonTemporal()) {
            double d = this.getRate().getValue();
            if (rate.getValue() == d) {
                return;
            }
            long l = this.getRemainingDuration();
            this.newDetail();
            double d2 = rate.getValue() / d;
            if (this.getPercentComplete() > 0.0) {
                this.makeContourPersonal();
            }
            this.detail.adjustRemainingUnits(rate.getValue());
            if (this.getTaskSchedulingType() != 1) {
                this.detail.adjustRemainingDuration((long)((double)l / d2));
            }
        }
        this.detail.setRate(rate);
        this.getTask().updateCachedDuration();
    }

    @Override
    public double getRemainingCost(FieldContext fieldContext) {
        return this.getCost(fieldContext) - this.getActualCost(fieldContext);
    }

    public void invalidateAssignmentCalendar() {
        this.detail.invalidateAssignmentCalendar();
    }

    public boolean isSubproject() {
        return false;
    }

    @Override
    public boolean isJustModified() {
        Task task = this.getTask();
        if (task == null) {
            return false;
        }
        return task.isJustModified();
    }

    public boolean isInvalidIntersectionCalendar() {
        return this.detail.isInvalidIntersectionCalendar();
    }

    private void moveDelayToContour() {
        long l = this.calcTotalDelay();
        if (l == 0L) {
            return;
        }
        this.makeContourPersonal();
        this.setTotalDelay(0L);
        this.setDurationMillis(this.getDurationMillis() + l);
        PersonalContour personalContour = PersonalContour.addEmptyBucket(this.getWorkContour(), l, false);
        this.newDetail().setWorkContour(personalContour);
    }

    private void extractDelayFromContour(PersonalContour personalContour) {
        long l = personalContour.extractDelay();
        if (l > 0L) {
            this.newDetail();
            this.detail.setDelay(l);
        }
    }

    @Override
    public void setComplete(boolean bl) {
        ScheduleUtil.setComplete(this, bl);
    }

    @Override
    public String getProjectName() {
        return this.getOwningProject().getName();
    }

    @Override
    public Project getProject() {
        return this.getTask().getProject();
    }

    public Project getOwningProject() {
        Project project = this.getTask().getOwningProject();
        if (project == null) {
            project = this.getProject();
        }
        return project;
    }

    @Override
    public final int getTimesheetStatus() {
        Assignment assignment = this.getTimesheetAssignment();
        if (assignment != null) {
            return assignment.timesheetStatus;
        }
        return this.timesheetStatus;
    }

    public final void setTimesheetStatus(int n) {
        this.timesheetStatus = n;
    }

    @Override
    public final long getLastTimesheetUpdate() {
        return this.lastTimesheetUpdate;
    }

    public final void setLastTimesheetUpdate(long l) {
        this.lastTimesheetUpdate = l;
    }

    @Override
    public boolean isPendingTimesheetUpdate() {
        return this.getTimesheetStatus() == 2;
    }

    @Override
    public String getTimesheetStatusName() {
        return TimesheetHelper.getTimesheetStatusName(this.getTimesheetStatus());
    }

    public final boolean isTimesheetAssignment() {
        return this.timesheetAssignment;
    }

    public final void setTimesheetAssignment(boolean bl) {
        this.timesheetAssignment = bl;
    }

    public Assignment getTimesheetAssignment() {
        if (this.isTimesheetAssignment()) {
            return this;
        }
        return this.detail.getBaselineAssignment(Snapshottable.TIMESHEET, false);
    }

    @Override
    public long getTimesheetStart() {
        return this.getCachedStart().getTime();
    }

    @Override
    public long getTimesheetFinish() {
        return this.getCachedEnd().getTime();
    }

    public boolean isTimesheetEditable() {
        return this.getTimesheetStatus() != 3;
    }

    public boolean isTimesheetEntered() {
        return this.getTimesheetStatus() != 1;
    }

    public boolean isTimesheetValidated() {
        return this.getTimesheetStatus() != 2;
    }

    public boolean isTimesheetRejected() {
        return this.getTimesheetStatus() != 4;
    }

    public boolean copyFieldsFromTimesheet(Collection collection) {
        Assignment assignment = this.getTimesheetAssignment();
        if (assignment == null) {
            return false;
        }
        if (assignment.getTimesheetStatus() != 2) {
            return false;
        }
        Field.copyData(collection, (Object)this, assignment);
        return true;
    }

    @Override
    public boolean applyTimesheet(Collection collection, long l) {
        boolean bl = this.copyFieldsFromTimesheet(collection);
        if (bl) {
            this.setTimesheetStatus(3);
            this.lastTimesheetUpdate = l;
            Assignment assignment = this.getTimesheetAssignment();
            assignment.setTimesheetStatus(3);
            assignment.lastTimesheetUpdate = l;
        }
        return bl;
    }

    public String getTimesheetStatusStyle() {
        return TimesheetHelper.getTimesheetStatusStyle(this.getTimesheetStatus());
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean bl) {
        Task task;
        this.dirty = bl;
        if (bl && (task = this.getTask()) != null) {
            task.setDirty(true);
        }
    }

    public final Date getCachedEnd() {
        return this.cachedEnd;
    }

    public final void setCachedEnd(Date date) {
        this.cachedEnd = date;
    }

    public final Date getCachedStart() {
        return this.cachedStart;
    }

    public final void setCachedStart(Date date) {
        this.cachedStart = date;
    }

    public final int getWorkflowState() {
        return this.workflowState;
    }

    public final void setWorkflowState(int n) {
        this.workflowState = n;
    }

    public void setTaskAndResource(Task task, Resource resource) {
        this.detail.setTask(task);
        this.detail.setResource(resource);
    }

    public long getDeadline() {
        return 0L;
    }

    @Override
    public final long getEarliestStop() {
        return this.detail.getEarliestStop();
    }

    @Override
    public final long getCompletedThrough() {
        return this.detail.getCompletedThrough();
    }

    @Override
    public void setCompletedThrough(long l) {
        this.setStop(l);
    }

    @Override
    public void replace(Object object, boolean bl) {
        if (bl) {
            this.newDetail().setTask((Task)object);
        } else {
            this.newDetail().setResource((Resource)object);
        }
    }

    @Override
    public long getFinishOffset() {
        return EarnedValueCalculator.getInstance().getFinishOffset(this);
    }

    @Override
    public long getStartOffset() {
        return EarnedValueCalculator.getInstance().getStartOffset(this);
    }

    @Override
    public String getTimeUnitLabel() {
        return this.getResource().getTimeUnitLabel();
    }

    @Override
    public boolean isMaterial() {
        return this.getResource().isMaterial();
    }

    public RateFormat getRateFormat() {
        return this.getResource().getRateFormat();
    }

    public ImageLink getBudgetStatusIndicator() {
        return EarnedValueCalculator.getInstance().getBudgetStatusIndicator(this.getCpi(null));
    }

    public ImageLink getScheduleStatusIndicator() {
        return EarnedValueCalculator.getInstance().getBudgetStatusIndicator(this.getSpi(null));
    }

    @Override
    public Object backupDetail() {
        return this.detail.backupDetail();
    }

    @Override
    public void restoreDetail(Object object, Object object2, boolean bl) {
        this.restoreDetail(object2);
        this.getTask().recalculate(object);
        this.getTask().updateCachedDuration();
    }

    public void restoreDetail(Object object) {
        this.detail = (AssignmentDetail)object;
    }

    public String getDelegatedToName() {
        return this.getTask().getDelegatedToName();
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public void setLocal(boolean bl) {
    }

    @Override
    public boolean renumber(boolean bl) {
        return this.hasKey.renumber(bl);
    }

    @Override
    public int getCostRateIndex() {
        return this.detail.getCostRateIndex();
    }

    @Override
    public void setCostRateIndex(int n) {
        this.newDetail().setCostRateIndex(n);
    }

    public String getUniqueIdString() {
        return this.getTask().getUniqueId() + "." + this.getResource().getUniqueId();
    }
}

