/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.assignment;

import com.projity.configuration.Configuration;
import com.projity.datatype.CanSupplyRateUnit;
import com.projity.datatype.Rate;
import com.projity.document.Document;
import com.projity.field.Field;
import com.projity.pm.assignment.Assignment;
import com.projity.pm.assignment.HasAssignments;
import com.projity.pm.assignment.HasRequestDemandType;
import com.projity.pm.key.HasKey;
import com.projity.pm.task.BelongsToDocument;
import com.projity.pm.task.Task;
import com.projity.util.ClassUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AssignmentEntry
implements HasRequestDemandType,
BelongsToDocument,
CanSupplyRateUnit {
    HasAssignments resource;
    ArrayList assignments;
    Document document;
    private static Field rateFieldInstance = null;

    public static Field getRateField() {
        if (rateFieldInstance == null) {
            rateFieldInstance = Configuration.getFieldFromId("Field.assignmentEntryRate");
        }
        return rateFieldInstance;
    }

    public AssignmentEntry(HasAssignments hasAssignments, ArrayList arrayList, Document document) {
        this.resource = hasAssignments;
        this.assignments = arrayList;
        this.document = document;
    }

    public String getName() {
        return ((HasKey)((Object)this.resource)).getName();
    }

    @Override
    public void setRequestDemandType(int n) {
        if (!this.isAssigned()) {
            return;
        }
        for (Assignment assignment : this.assignments) {
            assignment.setRequestDemandType(n);
        }
    }

    @Override
    public int getRequestDemandType() {
        Integer n = (Integer)Assignment.getRequestDemandTypeField().getCommonValue(this.assignments, false, false);
        if (n == null) {
            return 0;
        }
        return n;
    }

    private boolean isAssignmentListEmpty() {
        return this.assignments == null || this.assignments.size() == 0;
    }

    public Rate getRate() {
        Rate rate = (Rate)Assignment.getRateField().getCommonValue(this.assignments, false, false);
        if (rate == null) {
            if (this.isAssignmentListEmpty()) {
                if (this.getResource().isLabor()) {
                    return ClassUtils.defaultRate;
                }
                return ClassUtils.defaultUnitlessRate;
            }
            return ClassUtils.RATE_MULTIPLE_VALUES;
        }
        return rate;
    }

    public void setRate(Rate rate) throws ParseException {
        Iterator iterator = this.assignments.iterator();
        int n = rate.getTimeUnit();
        while (iterator.hasNext()) {
            Assignment assignment = (Assignment)iterator.next();
            if (n != -2) {
                if (assignment.isLabor()) {
                    assignment.adjustRemainingUnits(rate.getValue(), 0.0, true, false);
                    assignment.forceUnits(rate.getValue());
                } else {
                    assignment.setRate(rate);
                }
            } else {
                assignment.forceUnits(rate.getValue());
            }
            assignment.setRateUnit(n);
            Assignment.getRateField().fireEvent(assignment, this, null);
        }
    }

    public boolean isAssigned() {
        return this.assignments != null && this.assignments.size() > 0;
    }

    public int getAssignmentCount() {
        if (this.assignments == null) {
            return 0;
        }
        return this.assignments.size();
    }

    private void addAssignment(Assignment assignment) {
        if (this.assignments == null) {
            this.assignments = new ArrayList();
        }
        this.assignments.add(assignment);
    }

    public void setAssignmentsFromTaskList(List list) {
        this.assignments = null;
        for (Object e : list) {
            Task task;
            Assignment assignment;
            if (!(e instanceof Task) || (assignment = this.resource.findAssignment(task = (Task)e)) == null) continue;
            this.addAssignment(assignment);
        }
    }

    public HasAssignments getResource() {
        return this.resource;
    }

    @Override
    public Document getDocument() {
        return this.document;
    }

    @Override
    public String getTimeUnitLabel() {
        return ((CanSupplyRateUnit)((Object)this.resource)).getTimeUnitLabel();
    }

    @Override
    public boolean isMaterial() {
        return ((CanSupplyRateUnit)((Object)this.resource)).isMaterial();
    }
}

