/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.criticalpath;

import com.projity.configuration.Configuration;
import com.projity.document.Document;
import com.projity.document.ObjectEvent;
import com.projity.field.Field;
import com.projity.options.ScheduleOption;
import com.projity.pm.assignment.Assignment;
import com.projity.pm.calendar.WorkingCalendar;
import com.projity.pm.criticalpath.CriticalPathFields;
import com.projity.pm.criticalpath.PredecessorTaskList;
import com.projity.pm.criticalpath.SchedulingAlgorithm;
import com.projity.pm.criticalpath.TaskSchedule;
import com.projity.pm.dependency.Dependency;
import com.projity.pm.dependency.DependencyService;
import com.projity.pm.scheduling.ScheduleEvent;
import com.projity.pm.task.BelongsToDocument;
import com.projity.pm.task.NormalTask;
import com.projity.pm.task.Project;
import com.projity.pm.task.SubProj;
import com.projity.pm.task.Task;
import com.projity.strings.Messages;
import com.projity.transaction.MultipleTransaction;
import com.projity.util.DateTime;
import com.projity.util.Environment;
import java.util.Iterator;
import java.util.ListIterator;
import org.apache.commons.lang.builder.ToStringBuilder;

public class CriticalPath
implements SchedulingAlgorithm {
    PredecessorTaskList predecessorTaskList = new PredecessorTaskList(this);
    private CriticalPathFields fieldUpdater = null;
    NormalTask finishSentinel;
    NormalTask startSentinel;
    Project project;
    boolean suspendUpdates = false;
    boolean needsReset = false;
    long earliestStart;
    long latestFinish;
    private boolean criticalPathJustChanged = false;
    private static Task traceTask;
    TaskSchedule.CalculationContext context;
    private static CriticalPath lastInstance;
    private static Field constraintTypeField;
    private boolean updating = false;

    public CriticalPath(Project project) {
        this.project = project;
        project.setSchedulingAlgorithm(this);
        this.fieldUpdater = CriticalPathFields.getInstance(this, project);
        this.startSentinel = new NormalTask(true, project);
        this.startSentinel.setDuration(0L);
        this.startSentinel.setName("<Start>");
        this.finishSentinel = new NormalTask(true, project);
        this.finishSentinel.setDuration(0L);
        this.finishSentinel.setName("<End>");
        this.setForward(this.isForward());
        this.setProjectBoundaries();
        this.initEarliestAndLatest();
    }

    private void setProjectBoundaries() {
        if (this.isForward()) {
            this.startSentinel.setWindowEarlyStart(this.project.getStartConstraint());
            this.finishSentinel.setWindowLateFinish(0L);
        } else {
            this.startSentinel.setWindowEarlyStart(0L);
            this.finishSentinel.setWindowLateFinish(this.project.getEnd());
        }
        this.predecessorTaskList.getList().add(0, new PredecessorTaskList.TaskReference(this.startSentinel));
        this.predecessorTaskList.getList().add(new PredecessorTaskList.TaskReference(this.finishSentinel));
    }

    @Override
    public void initialize(Object object) {
        this.project = (Project)object;
        this.predecessorTaskList.getList().clear();
        this.predecessorTaskList.addAll(this.project.getTasks());
        this.initSentinelsFromTasks();
        this.setProjectBoundaries();
        this.calculate(false);
    }

    private void initSentinelsFromTasks() {
        ListIterator listIterator = this.predecessorTaskList.listIterator();
        while (listIterator.hasNext()) {
            Task task = ((PredecessorTaskList.TaskReference)listIterator.next()).getTask();
            if (task.getPredecessorList().size() == 0) {
                this.addStartSentinelDependency(task);
            }
            if (task.getSuccessorList().size() != 0) continue;
            this.addEndSentinelDependency(task);
        }
    }

    @Override
    public String getName() {
        return Messages.getString("Text.forwardScheduled");
    }

    private boolean isHonorRequiredDates() {
        return ScheduleOption.getInstance().isHonorRequiredDates();
    }

    private int getFreshCalculationStateCount() {
        return this.predecessorTaskList.getFreshCalculationStateCount();
    }

    private int getNextCalculationStateCount() {
        return this.predecessorTaskList.getNextCalculationStateCount();
    }

    @Override
    public int getCalculationStateCount() {
        return this.predecessorTaskList.getCalculationStateCount();
    }

    private Task getBeginSentinel(boolean bl) {
        return bl ? this.startSentinel : this.finishSentinel;
    }

    private Task getEndSentinel(boolean bl) {
        return bl ? this.finishSentinel : this.startSentinel;
    }

    private void fastCalc(Task task) {
        boolean bl;
        lastInstance = this;
        Task task2 = this.getBeginSentinel(this.isForward());
        Task task3 = this.getEndSentinel(this.isForward());
        long l = this.isForward() ? this.project.getStartConstraint() : -this.project.getEnd();
        boolean bl2 = this.predecessorTaskList.hasReverseScheduledTasks();
        this.context = new TaskSchedule.CalculationContext();
        this.context.stateCount = this.getNextCalculationStateCount();
        this.context.honorRequiredDates = this.isHonorRequiredDates();
        this.context.forward = this.isForward();
        this.context.boundary = l;
        this.context.sentinel = task3;
        this.context.earlyOnly = false;
        this.context.assign = false;
        this.context.scheduleType = this.isForward() ? -1 : 1;
        this.context.pass = 0;
        boolean bl3 = task == task2 || task.getSchedule(this.context.scheduleType).affectsCriticalPath(this.context);
        this.context.earlyOnly = bl = bl3 && bl2;
        this.context.assign = true;
        this.context.pass = 1;
        this.criticalPathJustChanged = bl3;
        this.doPass(task, this.context);
        if (bl3) {
            long l2;
            this.context.stateCount = this.getNextCalculationStateCount();
            this.context.sentinel = task3;
            this.context.boundary = l2 = -task3.getSchedule(this.context.scheduleType).getBegin();
            this.context.sentinel = task2;
            this.context.forward = !this.context.forward;
            this.context.assign = false;
            this.context.scheduleType = -this.context.scheduleType;
            ++this.context.pass;
            this.doPass(null, this.context);
            this.project.setStart(this.startSentinel.getEarlyStart());
            this.project.setEnd(this.finishSentinel.getEarlyFinish());
            if (bl2) {
                this.context.stateCount = this.getNextCalculationStateCount();
                this.context.forward = !this.context.forward;
                this.context.boundary = l;
                this.context.sentinel = task3;
                this.context.earlyOnly = false;
                this.context.assign = true;
                this.context.scheduleType = -this.context.scheduleType;
                ++this.context.pass;
                this.doPass(null, this.context);
            }
        }
        this.getFreshCalculationStateCount();
    }

    private void doPass(Task task, TaskSchedule.CalculationContext calculationContext) {
        boolean bl;
        if (task != null) {
            task.getSchedule(calculationContext.scheduleType).invalidate();
            task.setCalculationStateCount(this.getCalculationStateCount());
        }
        ListIterator listIterator = (bl = calculationContext.forward) ? this.predecessorTaskList.listIterator() : this.predecessorTaskList.reverseIterator();
        boolean bl2 = this.project.isForward();
        while (bl ? listIterator.hasNext() : listIterator.hasPrevious()) {
            Task task2;
            PredecessorTaskList.TaskReference taskReference = (PredecessorTaskList.TaskReference)(bl ? listIterator.next() : listIterator.previous());
            traceTask = task2 = taskReference.getTask();
            calculationContext.taskReferenceType = taskReference.getType();
            TaskSchedule taskSchedule = task2.getSchedule(calculationContext.scheduleType);
            if (!bl) {
                calculationContext.taskReferenceType = -taskReference.getType();
            }
            if (task2.isReverseScheduled()) {
                taskSchedule.invalidate();
                task2.setCalculationStateCount(calculationContext.stateCount);
            }
            if (task2.getCalculationStateCount() < calculationContext.stateCount) continue;
            taskSchedule.calcDates(calculationContext);
            if (!calculationContext.assign || !bl2 && task2.isWbsParent()) continue;
            if (taskSchedule.getBegin() != 0L && !this.isSentinel(task2)) {
                this.earliestStart = Math.min(this.earliestStart, taskSchedule.getStart());
            }
            if (taskSchedule.getEnd() == 0L || this.isSentinel(task2)) continue;
            this.latestFinish = Math.max(this.latestFinish, taskSchedule.getFinish());
        }
    }

    @Override
    public void calculate(boolean bl) {
        this.calculate(bl, null);
    }

    @Override
    public void initEarliestAndLatest() {
        long l = this.project.getStartConstraint();
        if (l == 0L) {
            l = DateTime.midnightToday();
        }
        this.earliestStart = this.latestFinish = l;
    }

    private void _calculate(boolean bl, Task task) {
        long l = System.currentTimeMillis();
        if (this.predecessorTaskList.getList().size() < 3) {
            if (this.isForward()) {
                this.project.setEnd(this.project.getStartConstraint());
            } else {
                this.project.setStart(this.project.getEnd());
            }
            return;
        }
        if (task == null) {
            task = this.getBeginSentinel(this.isForward());
        }
        this.fastCalc(task);
        if (bl) {
            this.fireScheduleChanged();
        }
    }

    private void calculate(boolean bl, Task task) {
        if (this.suspendUpdates) {
            return;
        }
        this._calculate(bl, task);
    }

    @Override
    public int getDefaultTaskConstraintType() {
        return 0;
    }

    private void fireScheduleChanged() {
        this.project.fireScheduleChanged(this, ScheduleEvent.SCHEDULE);
    }

    private synchronized CriticalPathFields getOrClearUpdater(boolean bl) {
        if (bl) {
            if (this.updating) {
                System.out.println("interrupting update thread");
                this.fieldUpdater.interrupt();
                this.fieldUpdater = CriticalPathFields.getInstance(this, this.project);
            }
            this.updating = true;
            return this.fieldUpdater;
        }
        this.updating = false;
        return null;
    }

    @Override
    public void objectChanged(ObjectEvent objectEvent) {
        if (!this.project.isInitialized() && !Environment.isImporting()) {
            System.out.println("Error - Message received when Project is not init" + this.project);
            return;
        }
        if (objectEvent.getSource() == this) {
            return;
        }
        Object object = objectEvent.getObject();
        Task task = null;
        if (object instanceof Task) {
            if (objectEvent.isCreate()) {
                this.predecessorTaskList.arrangeTask((Task)object);
                return;
            }
            if (objectEvent.isDelete()) {
                Task task2 = (Task)object;
                this.predecessorTaskList.removeTask(task2);
                this.reset();
            } else if (objectEvent.isUpdate()) {
                task = (Task)object;
                Field field = objectEvent.getField();
                if (field != null && !this.fieldUpdater.inputContains(field)) {
                    return;
                }
                if (field == constraintTypeField) {
                    this.reset();
                    task.invalidateSchedules();
                    task.markTaskAsNeedingRecalculation();
                }
            }
            this.calculate(true, task);
        } else if (object instanceof Dependency) {
            SubProj subProj;
            Dependency dependency = (Dependency)object;
            if (!dependency.refersToDocument(this.project)) {
                return;
            }
            if (!objectEvent.isUpdate()) {
                this.reset();
            }
            task = (Task)dependency.getPredecessor();
            Task task3 = (Task)dependency.getSuccessor();
            task.invalidateSchedules();
            task.markTaskAsNeedingRecalculation();
            if (task3.isSubproject() && (subProj = (SubProj)((Object)task3)).isSubprojectOpen()) {
                subProj.getSubproject().markAllTasksAsNeedingRecalculation(true);
            }
            task3.invalidateSchedules();
            task3.markTaskAsNeedingRecalculation();
            this.project.markAllTasksAsNeedingRecalculation(true);
            this.calculate(true, null);
        } else if (object == this.project) {
            this.reset();
            this.calculate(true, null);
        } else if (object instanceof WorkingCalendar) {
            this.project.markAllTasksAsNeedingRecalculation(false);
            this.calculate(true, null);
        } else if (object instanceof Assignment) {
            Assignment assignment = (Assignment)object;
            task = assignment.getTask();
            if (task.getProject().getSchedulingAlgorithm() != this) {
                return;
            }
            this.calculate(true, task);
        } else if (object instanceof BelongsToDocument) {
            Cloneable cloneable;
            if (((BelongsToDocument)object).getDocument() instanceof Project && ((Project)(cloneable = (Project)((BelongsToDocument)object).getDocument())).getSchedulingAlgorithm() != this) {
                return;
            }
            cloneable = objectEvent.getField();
            if (cloneable != null && this.fieldUpdater.inputContains((Field)cloneable)) {
                this.calculate(true, null);
            }
        }
    }

    @Override
    public void reset() {
        if (this.suspendUpdates) {
            this.needsReset = true;
            return;
        }
        this.needsReset = false;
        this.initEarliestAndLatest();
        this.predecessorTaskList.rearrangeAll();
    }

    @Override
    public void addEndSentinelDependency(Task task) {
        if (task.getOwningProject() == this.project && !task.isExternal()) {
            DependencyService.getInstance().addEndSentinelDependency(this.finishSentinel, task);
        }
    }

    @Override
    public boolean removeEndSentinelDependency(Task task) {
        if (task.getOwningProject() == this.project && !task.isExternal()) {
            return DependencyService.getInstance().removeEndSentinel(this.finishSentinel, task);
        }
        return false;
    }

    @Override
    public void addStartSentinelDependency(Task task) {
        if (task.getOwningProject() == this.project && !task.isExternal()) {
            DependencyService.getInstance().addStartSentinelDependency(this.startSentinel, task);
        }
    }

    @Override
    public boolean removeStartSentinelDependency(Task task) {
        if (task.getOwningProject() == this.project && !task.isExternal()) {
            return DependencyService.getInstance().removeStartSentinel(this.startSentinel, task);
        }
        return false;
    }

    public long getStartConstraint() {
        return this.startSentinel.getConstraintDate();
    }

    @Override
    public void setStartConstraint(long l) {
        this.startSentinel.setScheduleConstraint(4, l);
        this.markBoundsAsDirty();
    }

    @Override
    public void setEndConstraint(long l) {
        this.finishSentinel.setScheduleConstraint(7, l);
        this.markBoundsAsDirty();
    }

    @Override
    public void markBoundsAsDirty() {
        Task task;
        this.startSentinel.markTaskAsNeedingRecalculation();
        this.finishSentinel.markTaskAsNeedingRecalculation();
        Iterator iterator = this.startSentinel.getSuccessorList().iterator();
        while (iterator.hasNext()) {
            task = (Task)((Dependency)iterator.next()).getTask(false);
            task.invalidateSchedules();
            task.markTaskAsNeedingRecalculation();
        }
        iterator = this.finishSentinel.getPredecessorList().iterator();
        while (iterator.hasNext()) {
            task = (Task)((Dependency)iterator.next()).getTask(true);
            task.invalidateSchedules();
            task.markTaskAsNeedingRecalculation();
        }
    }

    @Override
    public boolean isForward() {
        return this.project.isForward();
    }

    @Override
    public void setForward(boolean bl) {
        if (bl) {
            this.setStartConstraint(this.project.getStartConstraint());
            this.finishSentinel.setRawConstraintType(0);
        } else {
            this.setEndConstraint(this.project.getEnd());
            this.startSentinel.setRawConstraintType(0);
        }
        this.startSentinel.setForward(bl);
        this.finishSentinel.setForward(bl);
    }

    @Override
    public void multipleTransaction(MultipleTransaction multipleTransaction) {
        if (multipleTransaction.isFinalEnd()) {
            this.suspendUpdates = false;
            if (this.needsReset) {
                this.reset();
            }
            this.calculate(true, null);
        } else {
            this.suspendUpdates = true;
        }
    }

    @Override
    public boolean getMarkerStatus() {
        return this.predecessorTaskList.getMarkerStatus();
    }

    @Override
    public void addObject(Object object) {
        NormalTask normalTask = (NormalTask)object;
        if (normalTask.getSuccessorList().isEmpty()) {
            this.addEndSentinelDependency(normalTask);
        } else {
            this.removeEndSentinelDependency(normalTask);
        }
        if (normalTask.getPredecessorList().isEmpty()) {
            this.addStartSentinelDependency(normalTask);
        } else {
            this.removeStartSentinelDependency(normalTask);
        }
        normalTask.markTaskAsNeedingRecalculation();
        this.predecessorTaskList.arrangeTask(normalTask);
    }

    @Override
    public void addSubproject(Task task) {
        this.predecessorTaskList.addSubproject(task);
    }

    @Override
    public Document getMasterDocument() {
        return this.project;
    }

    public void dumpPredecessorList() {
        this.predecessorTaskList.dump();
    }

    public final long getEarliestStart() {
        return this.earliestStart;
    }

    public final long getLatestFinish() {
        return this.latestFinish;
    }

    private boolean isSentinel(Task task) {
        return task == this.startSentinel || task == this.finishSentinel;
    }

    public final Project getProject() {
        return this.project;
    }

    public boolean isCriticalPathJustChanged() {
        return this.criticalPathJustChanged;
    }

    @Override
    public CriticalPathFields getFieldUpdater() {
        return this.fieldUpdater;
    }

    @Override
    public void setEarliestAndLatest(long l, long l2) {
        this.earliestStart = l;
        this.latestFinish = l2;
    }

    public int[] findTaskPosition(Task task) {
        return this.predecessorTaskList.findTaskPosition(task);
    }

    public static String getTrace() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ToStringBuilder.reflectionToString(lastInstance));
        stringBuffer.append("\nProject: " + CriticalPath.lastInstance.project + " Task: " + traceTask + " reverse=" + traceTask.isReverseScheduled() + " parent =" + traceTask.isParent());
        return stringBuffer.toString();
    }

    static {
        constraintTypeField = Configuration.getFieldFromId("Field.constraintType");
    }
}

