/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.gantt;

import com.projity.pm.graphic.gantt.GanttModel;
import com.projity.pm.graphic.gantt.GanttParams;
import com.projity.pm.graphic.gantt.GanttUI;
import com.projity.pm.graphic.gantt.link_routing.DefaultGanttLinkRouting;
import com.projity.pm.graphic.graph.Graph;
import com.projity.pm.graphic.graph.GraphParams;
import com.projity.pm.graphic.graph.GraphUI;
import com.projity.pm.graphic.graph.LinkRouting;
import com.projity.pm.graphic.timescale.CoordinatesConverter;
import com.projity.pm.graphic.timescale.ScaledComponent;
import com.projity.pm.task.Project;
import com.projity.pm.time.HasStartAndEnd;
import com.projity.strings.Messages;
import com.projity.timescale.TimeScaleEvent;
import com.projity.timescale.TimeScaleListener;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JViewport;

public class Gantt
extends Graph
implements ScaledComponent,
TimeScaleListener,
GanttParams {
    private static final long serialVersionUID = -1806070019043393474L;
    protected LinkRouting routing = new DefaultGanttLinkRouting();

    public Gantt(Project project, String string) {
        this(new GanttModel(project, string), project);
    }

    protected Gantt(GanttModel ganttModel, Project project) {
        super(ganttModel, project);
        this.setToolTipText(Messages.getString("Text.rightClickForOptions"));
    }

    @Override
    public void cleanUp() {
        CoordinatesConverter coordinatesConverter = this.getCoord();
        if (coordinatesConverter != null) {
            coordinatesConverter.removeTimeScaleListener(this);
            coordinatesConverter.removeTimeScaleListener((GanttModel)this.model);
        }
        super.cleanUp();
    }

    @Override
    public void updateUI() {
        this.setUI(new GanttUI(this));
        this.invalidate();
    }

    @Override
    public CoordinatesConverter getCoord() {
        return ((GanttModel)this.model).getCoord();
    }

    @Override
    public void setCoord(CoordinatesConverter coordinatesConverter) {
        CoordinatesConverter coordinatesConverter2 = this.getCoord();
        if (coordinatesConverter2 != null) {
            coordinatesConverter2.removeTimeScaleListener(this);
        }
        coordinatesConverter.addTimeScaleListener(this);
        ((GanttModel)this.model).setCoord(coordinatesConverter);
    }

    @Override
    public void timeScaleChanged(TimeScaleEvent timeScaleEvent) {
        this.updateSize();
    }

    public int getRow(double d) {
        double d2 = d / (double)this.getRowHeight();
        return (int)d2;
    }

    @Override
    public int getRowHeight() {
        return ((GanttModel)this.model).getRowHeight();
    }

    @Override
    public void setRowHeight(int n) {
        ((GanttModel)this.model).setRowHeight(n);
    }

    @Override
    public Font getColumnHeaderFont() {
        return null;
    }

    @Override
    public void setColumnHeaderFont(Font font) {
    }

    @Override
    public LinkRouting getRouting() {
        return this.routing;
    }

    @Override
    public void setRouting(LinkRouting linkRouting) {
        this.routing = linkRouting;
    }

    public void updateSize() {
        ((GraphUI)this.ui).updateShapes();
        Container container = this.getParent();
        if (container instanceof JViewport) {
            JViewport jViewport = (JViewport)container;
            jViewport.setViewSize(new Dimension((int)Math.ceil(this.getCoord().getWidth()), jViewport.getViewSize().height));
        }
        this.setPreferredSize(new Dimension((int)Math.ceil(this.getCoord().getWidth()), this.getPreferredSize().height));
        this.revalidate();
    }

    @Override
    public Rectangle getGanttBounds() {
        return this.getDrawingBounds();
    }

    @Override
    public boolean useTextures() {
        return true;
    }

    @Override
    public Rectangle getPrintBounds() {
        return null;
    }

    @Override
    public void setPrintBounds(Rectangle rectangle) {
    }

    @Override
    public int getPrintCols() {
        return 0;
    }

    @Override
    public int getPrintRows() {
        return 0;
    }

    public void scrollToTask(HasStartAndEnd hasStartAndEnd, boolean bl) {
        CoordinatesConverter coordinatesConverter = this.getCoord();
        double d = coordinatesConverter.toX(hasStartAndEnd.getStart());
        double d2 = coordinatesConverter.toX(hasStartAndEnd.getEnd());
        Rectangle rectangle = this.getVisibleRect();
        if (bl && (d >= (double)rectangle.x && d <= (double)(rectangle.x + rectangle.width) || d2 >= (double)rectangle.x && d2 <= (double)(rectangle.x + rectangle.width) || d < (double)rectangle.x && d2 > (double)(rectangle.x + rectangle.width))) {
            return;
        }
        Container container = this.getParent();
        if (container instanceof JViewport) {
            JViewport jViewport = (JViewport)container;
            Point point = jViewport.getViewPosition();
            if (d < 150.0) {
                point.x = 0;
            } else {
                point.x = (int)Math.ceil(d) - 50;
                if (point.x < 0) {
                    point.x = 0;
                }
            }
            jViewport.setViewPosition(point);
        }
    }

    @Override
    public boolean isLeftPartVisible() {
        return true;
    }

    @Override
    public boolean isRightPartVisible() {
        return true;
    }

    @Override
    public void setLeftPartVisible(boolean bl) {
    }

    @Override
    public void setRightPartVisible(boolean bl) {
    }

    @Override
    public boolean isSupportLeftAndRightParts() {
        return false;
    }

    @Override
    public void setSupportLeftAndRightParts(boolean bl) {
    }

    @Override
    public GraphParams createSafePrintCopy() {
        return this;
    }
}

