/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.pert;

import com.projity.graphic.configuration.BarFormat;
import com.projity.graphic.configuration.GraphicConfiguration;
import com.projity.graphic.configuration.TexturedShape;
import com.projity.pm.graphic.model.cache.GraphicNode;
import com.projity.pm.graphic.model.cache.NodeModelCache;
import com.projity.pm.graphic.model.event.CompositeCacheEvent;
import com.projity.pm.graphic.network.NetworkParams;
import com.projity.pm.graphic.network.layout.AbstractNetworkLayout;
import com.projity.pm.graphic.pert.DependencyGraph;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ListIterator;
import org.apache.commons.collections.Closure;

public class PertLayout
extends AbstractNetworkLayout {
    protected DependencyGraph dependencyGraph = new DependencyGraph();
    protected TexturedShapeFinder texturedShapeFinder = new TexturedShapeFinder();

    public PertLayout(NetworkParams networkParams) {
        super(networkParams);
    }

    @Override
    public void setCache(NodeModelCache nodeModelCache) {
        super.setCache(nodeModelCache);
        this.dependencyGraph.setCache(nodeModelCache);
    }

    protected TexturedShape findShape(GraphicNode graphicNode) {
        this.texturedShapeFinder.initialize(graphicNode);
        this.barStyles.apply(graphicNode.getNode().getImpl(), this.texturedShapeFinder);
        return this.texturedShapeFinder.getShape();
    }

    @Override
    public void updateBounds() {
        this.dependencyGraph.updatePertLevels();
        GraphicConfiguration graphicConfiguration = GraphicConfiguration.getInstance();
        Point2D.Double double_ = new Point2D.Double(graphicConfiguration.getPertXOffset(), graphicConfiguration.getPertYOffset());
        Rectangle2D.Double double_2 = new Rectangle2D.Double(graphicConfiguration.getPertXOffset(), graphicConfiguration.getPertYOffset(), graphicConfiguration.getPertCellWidth(), graphicConfiguration.getPertCellHeight());
        int n = 0;
        int n2 = -1;
        this.setEmpty();
        ListIterator listIterator = this.cache.getIterator();
        while (listIterator.hasNext()) {
            GraphicNode graphicNode = (GraphicNode)listIterator.next();
            int n3 = this.cache.getPertLevel(graphicNode) - 1;
            if (n3 <= n2) {
                ++n;
            }
            n2 = n3;
            TexturedShape texturedShape = this.findShape(graphicNode);
            if (texturedShape == null) continue;
            double d = ((Point2D)double_).getX() + double_2.getMaxX() * (double)n2 + ((RectangularShape)double_2).getWidth() / 2.0;
            double d2 = ((Point2D)double_).getY() + double_2.getMaxY() * (double)n + ((RectangularShape)double_2).getHeight() / 2.0;
            GeneralPath generalPath = texturedShape.toGeneralPath(((RectangularShape)double_2).getWidth(), ((RectangularShape)double_2).getHeight(), d - ((RectangularShape)double_2).getWidth() / 2.0, d2, null);
            graphicNode.setPertShape(generalPath, d, d2);
            Rectangle rectangle = this.network.scale(generalPath.getBounds());
            if (this.isEmpty()) {
                this.bounds.setBounds(rectangle);
                continue;
            }
            Rectangle.union(this.bounds, rectangle, this.bounds);
        }
        this.fireLayoutChanged();
    }

    @Override
    public void graphicNodesCompositeEvent(CompositeCacheEvent compositeCacheEvent) {
        if (compositeCacheEvent.getRemovedEdges() != null) {
            this.dependencyGraph.removeDependencies(compositeCacheEvent.getRemovedEdges());
        }
        if (compositeCacheEvent.getInsertedEdges() != null) {
            this.dependencyGraph.insertDependencies(compositeCacheEvent.getInsertedEdges());
        }
        this.updateBounds();
    }

    protected class TexturedShapeFinder
    implements Closure {
        protected BarFormat format;
        protected GraphicNode node;
        protected TexturedShape shape;

        protected TexturedShapeFinder() {
        }

        void initialize(GraphicNode graphicNode) {
            this.node = graphicNode;
            this.shape = null;
        }

        @Override
        public void execute(Object object) {
            this.format = (BarFormat)object;
            if (this.format.getMiddle() != null) {
                this.shape = this.format.getMiddle();
            }
        }

        public TexturedShape getShape() {
            return this.shape;
        }
    }
}

