/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.spreadsheet.renderer;

import com.projity.datatype.Duration;
import com.projity.field.Field;
import com.projity.pm.graphic.model.cache.GraphicNode;
import com.projity.pm.graphic.spreadsheet.SpreadSheetParams;
import com.projity.pm.graphic.spreadsheet.common.CommonSpreadSheetModel;
import com.projity.pm.graphic.spreadsheet.renderer.FontManager;
import com.projity.pm.graphic.spreadsheet.renderer.OfflineRenderer;
import java.awt.Component;
import java.awt.Font;
import java.io.Serializable;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class TimeSimpleRenderer
extends DefaultTableCellRenderer
implements OfflineRenderer {
    static Font boldFont = null;

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Serializable serializable;
        JLabel jLabel;
        if (jTable == null) {
            this.setValue(null);
            jLabel = this;
        } else {
            jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            serializable = (CommonSpreadSheetModel)jTable.getModel();
            FontManager.setComponentFont(((CommonSpreadSheetModel)serializable).getCellProperties(((CommonSpreadSheetModel)serializable).getNode(n)), jLabel);
        }
        if (object != null && object instanceof Duration) {
            serializable = (Duration)object;
            jLabel.setText(serializable + "");
        }
        if (object instanceof String) {
            jLabel.setHorizontalAlignment(2);
        } else {
            jLabel.setHorizontalAlignment(4);
        }
        return jLabel;
    }

    @Override
    public Component getComponent(Object object, GraphicNode graphicNode, Field field, SpreadSheetParams spreadSheetParams) {
        Component component = this.getTableCellRendererComponent(null, object, false, false, -1, -1);
        FontManager.setComponentFont(spreadSheetParams.getFieldArray().getCellStyle().getCellFormat(graphicNode), component);
        return component;
    }
}

