/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.spreadsheet.selection.event;

import com.projity.pm.graphic.spreadsheet.SpreadSheet;
import com.projity.pm.graphic.spreadsheet.SpreadSheetColumnMenu;
import com.projity.pm.graphic.spreadsheet.common.CommonSpreadSheet;
import com.projity.pm.graphic.spreadsheet.selection.SpreadSheetSelectionModel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;

public class HeaderMouseListener
extends MouseAdapter {
    protected SpreadSheet table;

    public HeaderMouseListener(SpreadSheet spreadSheet) {
        this.table = spreadSheet;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        SpreadSheet spreadSheet;
        int n = this.table.columnAtPoint(mouseEvent.getPoint());
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            SpreadSheetSelectionModel spreadSheetSelectionModel = this.table.getSelection();
            this.table.getRowHeader().clearSelection();
            spreadSheetSelectionModel.getColumnSelection().setSelectionInterval(n, n);
            spreadSheetSelectionModel.getRowSelection().setSelectionInterval(0, this.table.getRowCount() - 1);
        } else if (SwingUtilities.isRightMouseButton(mouseEvent) && this.table instanceof CommonSpreadSheet && this.table.getSpreadSheetCategory() != null && (spreadSheet = this.table).isHasColumnHeaderPopup()) {
            SpreadSheetColumnMenu spreadSheetColumnMenu = new SpreadSheetColumnMenu(spreadSheet, n + 1);
            spreadSheetColumnMenu.show(spreadSheet, mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

