/*
 * Decompiled with CFR 0.152.
 */
package org.cesilko.rachota.core;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.cesilko.rachota.core.Day;
import org.cesilko.rachota.core.IdleTask;
import org.cesilko.rachota.core.Plan;
import org.cesilko.rachota.core.RegularTask;
import org.cesilko.rachota.core.Settings;
import org.cesilko.rachota.core.Task;
import org.cesilko.rachota.core.Translator;
import org.cesilko.rachota.gui.Tools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DiaryScanner {
    Document document;
    private static String dtd = "<?xml version='1.1' encoding='" + (String)Settings.getDefault().getSetting("systemEncoding") + "'?>&&<!--- One week of working plan.&(id - number of week in year,&os - identification of operating system e.g. Linux 3.0.0-12-generic,&year - calendar year)&-->&<!ELEMENT week (day)*>&<!ATTLIST week&    id CDATA #REQUIRED&    year CDATA #REQUIRED&    os CDATA #IMPLIED&  >&&<!--- Day of week.&(finish - time when user finished to work,&date - textual identification of day in format MM-dd-yyyy e.g. 12-31-2013,&start - time when user started to work,&id - number of day in week)&-->&<!ELEMENT day (task)*>&<!ATTLIST day&    finish CDATA #IMPLIED&    date CDATA #IMPLIED&    start CDATA #IMPLIED&    id CDATA #REQUIRED&  >&&<!--- Task planned for a day.&(duration - total time how long user worked on task so far,&state - information about progress on task)&-->&<!ELEMENT task (repetition|notification|notes|keyword|description|priority|private|idle)*>&<!ATTLIST task&    duration CDATA #REQUIRED&    state CDATA #IMPLIED&  >&&<!--- Priority of a task. -->&<!ELEMENT priority (#PCDATA)>&&<!--- Short description of a task. -->&<!ELEMENT description (#PCDATA)>&&<!--- Category of a task. -->&<!ELEMENT keyword (#PCDATA)>&&<!--- Long description of a task. -->&<!ELEMENT notes (#PCDATA)>&&<!--- Identification of an idle task. -->&<!ELEMENT idle EMPTY>&&<!--- Notification about a task at specified time.&(switch - whether task should start automatically,&time - when user should start working on a task)&-->&<!ELEMENT notification EMPTY>&<!ATTLIST notification&    switch CDATA #IMPLIED&    time CDATA #IMPLIED&  >&&<!--- Identification of private task. -->&<!ELEMENT private EMPTY>&&<!--- Identification of regular task.&(frequency - type of repetition)&-->&<!ELEMENT repetition EMPTY>&<!ATTLIST repetition&    frequency CDATA #IMPLIED&  >&";

    public DiaryScanner(Document document) {
        this.document = document;
    }

    public void loadDocument() {
        Element weekElement = this.document.getDocumentElement();
        this.loadWeek(weekElement);
    }

    private void loadWeek(Element element) {
        int week_id = Integer.parseInt(element.getAttributeNode("id").getValue());
        int week_year = Integer.parseInt(element.getAttributeNode("year").getValue());
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element dayElement = (Element)node;
            this.loadDay(dayElement, week_id, week_year);
        }
    }

    private void loadDay(Element dayElement, int week_id, int week_year) {
        int day_id = Integer.parseInt(dayElement.getAttributeNode("id").getValue());
        String start = dayElement.getAttributeNode("start").getValue();
        String finish = dayElement.getAttributeNode("finish").getValue();
        Date start_time = null;
        Date finish_time = null;
        if (!finish.equals("00:00")) {
            finish_time = new Date(Tools.getTime(finish));
            start_time = new Date(Tools.getTime(start));
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, week_year);
        calendar.set(3, week_id);
        calendar.set(7, day_id);
        Vector<Task> tasks = new Vector<Task>();
        NodeList nodes = dayElement.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element taskElement = (Element)node;
            Task task = this.loadTask(taskElement);
            tasks.add(task);
        }
        Day day = new Day(tasks, calendar.getTime(), start_time, finish_time);
        Plan.getDefault().addDay(day);
    }

    private Task loadTask(Element taskElement) {
        long duration = Tools.getTime(taskElement.getAttributeNode("duration").getValue());
        int state = Integer.parseInt(taskElement.getAttributeNode("state").getValue());
        Task task = null;
        int priority = 0;
        String description = "";
        String keyword = "";
        String notes = "";
        long notification = -1L;
        boolean automaticStart = false;
        boolean privateTask = false;
        int repetition = -1;
        boolean idle = false;
        NodeList nodes = taskElement.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element nodeElement = (Element)node;
            if (nodeElement.getTagName().equals("priority")) {
                priority = this.loadPriority(nodeElement);
            }
            if (nodeElement.getTagName().equals("description")) {
                description = this.loadDescription(nodeElement);
            }
            if (nodeElement.getTagName().equals("keyword")) {
                keyword = this.loadKeyword(nodeElement);
            }
            if (nodeElement.getTagName().equals("notes")) {
                notes = this.loadNotes(nodeElement);
            }
            if (nodeElement.getTagName().equals("notification")) {
                notification = this.loadNotification(nodeElement);
                automaticStart = this.loadAutomaticStart(nodeElement);
            }
            if (nodeElement.getTagName().equals("private")) {
                privateTask = true;
            }
            if (nodeElement.getTagName().equals("repetition")) {
                repetition = this.loadRepetition(nodeElement);
            }
            if (!nodeElement.getTagName().equals("idle")) continue;
            idle = true;
        }
        Date notificationTime = notification == -1L ? null : new Date(notification);
        task = new Task(description, keyword, notes, priority, state, duration, notificationTime, automaticStart, privateTask);
        if (repetition != -1) {
            task = new RegularTask(description, keyword, notes, priority, state, duration, notificationTime, automaticStart, privateTask, repetition);
        }
        if (idle) {
            task = new IdleTask();
            task.addDuration(duration);
            task.setState(state);
        }
        return task;
    }

    private int loadPriority(Element priorityElement) {
        NodeList nodes = priorityElement.getChildNodes();
        Node node = nodes.item(0);
        return Integer.parseInt(((Text)node).getData());
    }

    private String loadDescription(Element descriptionElement) {
        NodeList nodes = descriptionElement.getChildNodes();
        Node node = nodes.item(0);
        return ((Text)node).getData();
    }

    private String loadKeyword(Element keywordElement) {
        NodeList nodes = keywordElement.getChildNodes();
        Node node = nodes.item(0);
        return ((Text)node).getData();
    }

    private String loadNotes(Element notesElement) {
        NodeList nodes = notesElement.getChildNodes();
        Node node = nodes.item(0);
        return ((Text)node).getData();
    }

    private long loadNotification(Element notificationElement) {
        long notificationTime = Tools.getTime(notificationElement.getAttributeNode("time").getValue());
        return notificationTime;
    }

    private boolean loadAutomaticStart(Element notificationElement) {
        boolean automaticStart = Boolean.parseBoolean(notificationElement.getAttributeNode("switch").getValue());
        return automaticStart;
    }

    private int loadRepetition(Element repetitionElement) {
        int repetition = Integer.parseInt(repetitionElement.getAttributeNode("frequency").getValue());
        return repetition;
    }

    public static void createDTD() {
        String userDir = (String)Settings.getDefault().getSetting("userDir");
        String dtdFileName = userDir + File.separator + "diary.dtd";
        File dtdFile = new File(dtdFileName);
        try {
            if (dtdFile.exists()) {
                return;
            }
            BufferedWriter writer = new BufferedWriter(new FileWriter(dtdFile));
            StringTokenizer data = new StringTokenizer(dtd, "&", true);
            while (data.hasMoreTokens()) {
                String token = data.nextToken();
                if (token.equals("&")) {
                    writer.newLine();
                    continue;
                }
                writer.write(token);
            }
            writer.close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, Translator.getTranslation("ERROR.WRITE_ERROR", new String[]{dtdFileName}), Translator.getTranslation("ERROR.ERROR_TITLE"), 0);
        }
    }
}

