/*
 * Decompiled with CFR 0.152.
 */
package org.cesilko.rachota.core;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import org.cesilko.rachota.core.Clock;
import org.cesilko.rachota.core.ClockListener;
import org.cesilko.rachota.core.Plan;
import org.cesilko.rachota.core.RegularTask;
import org.cesilko.rachota.core.Settings;
import org.cesilko.rachota.core.Translator;
import org.cesilko.rachota.gui.Tools;

public class Task
implements ClockListener {
    private String description;
    private String keyword;
    private String notes;
    private int priority;
    private int state;
    private long duration;
    private Date notificationTime;
    private boolean automaticStart;
    private Date timeStamp;
    private boolean privateTask;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private long lastSaving;
    public static int STATE_NEW = 0;
    public static int STATE_STARTED = 1;
    public static int STATE_DONE = 2;
    public static int PRIORITY_HIGH = 0;
    public static int PRIORITY_MEDIUM = 1;
    public static int PRIORITY_LOW = 2;

    public Task(String description, String keyword, String notes, int priority, int state, long duration, Date notificationTime, boolean automaticStart, boolean privateTask) {
        this.setDescription(description);
        this.setKeyword(keyword);
        this.setNotes(notes);
        this.setPriority(priority);
        this.setState(state);
        this.setDuration(duration);
        this.setNotificationTime(notificationTime);
        this.setAutomaticStart(automaticStart);
        this.setPrivateTask(privateTask);
        this.timeStamp = null;
        this.lastSaving = 0L;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword.trim();
        this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(this, "keyword", null, keyword));
    }

    public String getKeyword() {
        return this.keyword;
    }

    public Iterator getKeywordIterator() {
        StringTokenizer tokenizer = new StringTokenizer(this.keyword, " ");
        ArrayList<String> tokens = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken());
        }
        return tokens.iterator();
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public String getNotes() {
        return this.notes;
    }

    public void addNote(String note, boolean recordTime) {
        if (recordTime) {
            note = "[" + Tools.getTime(new Date()) + "] " + note;
        }
        this.notes = this.notes.isEmpty() ? note : this.notes + "\n" + note;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    public static String getPriority(int priority) {
        return Translator.getTranslation("TASK_PRIORITY_" + priority);
    }

    public void setState(int state) {
        this.state = state;
    }

    public int getState() {
        return this.state;
    }

    public static String getState(int state) {
        return Translator.getTranslation("TASK_STATE_" + state);
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public void addDuration(long duration) {
        this.duration += duration;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setNotificationTime(Date notificationTime) {
        this.notificationTime = notificationTime;
        this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(this, "notificationTime", null, notificationTime));
    }

    public Date getNotificationTime() {
        return this.notificationTime;
    }

    public void setAutomaticStart(boolean automaticStart) {
        this.automaticStart = automaticStart;
    }

    public boolean automaticStart() {
        return this.automaticStart;
    }

    public void setPrivateTask(boolean privateTask) {
        this.privateTask = privateTask;
    }

    public boolean privateTask() {
        return this.privateTask;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void write(PrintStream stream) throws IOException {
        stream.print("        <task state=\"" + this.state + "\"");
        stream.println(" duration=\"" + Tools.getTime(this.duration) + "\">");
        stream.println("            <priority>" + this.priority + "</priority>");
        String data = Tools.replaceAll(this.description, "&", "&amp;");
        data = Tools.replaceAll(data, "<", "&lt;");
        data = Tools.replaceAll(data, ">", "&gt;");
        data = Tools.replaceAll(data, "\"", "&quot;");
        stream.println("            <description>" + data + "</description>");
        if (this.keyword != null && !this.keyword.equals("")) {
            data = Tools.replaceAll(this.keyword, "&", "&amp;");
            data = Tools.replaceAll(data, "<", "&lt;");
            data = Tools.replaceAll(data, ">", "&gt;");
            data = Tools.replaceAll(data, "\"", "&quot;");
            stream.println("            <keyword>" + data + "</keyword>");
        }
        if (this.notes != null && !this.notes.equals("")) {
            data = Tools.replaceAll(this.notes, "&", "&amp;");
            data = Tools.replaceAll(data, "<", "&lt;");
            data = Tools.replaceAll(data, ">", "&gt;");
            data = Tools.replaceAll(data, "\"", "&quot;");
            stream.println("            <notes>" + data + "</notes>");
        }
        if (this.notificationTime != null) {
            stream.println("            <notification time=\"" + Tools.getTime(this.notificationTime) + "\" switch=\"" + this.automaticStart + "\"/>");
        }
        if (this.privateTask) {
            stream.println("            <private/>");
        }
        this.writeRepetition(stream);
        stream.println("        </task>");
    }

    public void writeRepetition(PrintStream stream) throws IOException {
    }

    public void startWork() {
        Clock.getDefault().addListener(this);
        this.timeStamp = new Date();
        Boolean logTaskEvents = (Boolean)Settings.getDefault().getSetting("logTaskEvents");
        if (logTaskEvents.booleanValue()) {
            if (this.getState() == STATE_NEW) {
                this.addNote("started", true);
            } else {
                this.addNote("resumed", true);
            }
        }
        this.setState(STATE_STARTED);
    }

    public void suspendWork() {
        Clock.getDefault().removeListener(this);
        Date now = new Date();
        this.addDuration(now.getTime() - this.timeStamp.getTime());
        this.timeStamp = null;
        Boolean logTaskEvents = (Boolean)Settings.getDefault().getSetting("logTaskEvents");
        if (logTaskEvents.booleanValue()) {
            this.addNote("suspended", true);
        }
        this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(this, "duration", null, new Long(this.duration)));
    }

    public void workDone() {
        Boolean logTaskEvents;
        if (this.timeStamp != null) {
            Clock.getDefault().removeListener(this);
            Date now = new Date();
            this.addDuration(now.getTime() - this.timeStamp.getTime());
            this.timeStamp = null;
        }
        if ((logTaskEvents = (Boolean)Settings.getDefault().getSetting("logTaskEvents")).booleanValue()) {
            this.addNote("ended", true);
        }
        this.setState(STATE_DONE);
        this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(this, "duration", null, new Long(this.duration)));
    }

    public boolean isRunning() {
        return this.timeStamp != null;
    }

    @Override
    public void tick() {
        long requiredBackupAge;
        long backupAge;
        String hibernationThreshold;
        Date now = new Date();
        long timeSinceLastTick = now.getTime() - this.timeStamp.getTime();
        if (timeSinceLastTick > (long)(Integer.parseInt(hibernationThreshold = (String)Settings.getDefault().getSetting("hibernationTime")) * 60 * 1000)) {
            Tools.recordActivity();
            String hibernationAction = (String)Settings.getDefault().getSetting("hibernationAction");
            if (hibernationAction.equals(Settings.ON_HIBERNATION_IGNORE)) {
                this.timeStamp = new Date();
                this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(this, "hibernation", null, null));
                return;
            }
            if (hibernationAction.equals(Settings.ON_HIBERNATION_INCLUDE)) {
                this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(this, "hibernation", null, null));
            } else {
                Object[] buttons = new String[]{Translator.getTranslation("QUESTION.BT_HIBERNATION_IGNORE"), Translator.getTranslation("QUESTION.BT_HIBERNATION_INCLUDE")};
                int decision = JOptionPane.showOptionDialog(null, Translator.getTranslation("QUESTION.HIBERNATION_DETECTED", new String[]{hibernationThreshold, this.getDescription()}), Translator.getTranslation("QUESTION.QUESTION_TITLE"), 0, 3, null, buttons, buttons[1]);
                if (decision == 0) {
                    this.timeStamp = new Date();
                    this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(this, "hibernation", null, Settings.ON_HIBERNATION_IGNORE));
                    return;
                }
                this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(this, "hibernation", null, Settings.ON_HIBERNATION_INCLUDE));
            }
        }
        this.addDuration(timeSinceLastTick);
        long delayedAnswerTime = new Date().getTime() - now.getTime();
        Plan.getDefault().getDay(now).getIdleTask().addDuration(delayedAnswerTime);
        if (!this.isIdleTask()) {
            Settings.getDefault().setSetting("runningTask", this.getDescription() + "[" + this.timeStamp.getTime() + "]");
        }
        Plan.getDefault().uploadDiary(Plan.UPLOAD_IN_5_MINUTES);
        this.timeStamp = new Date();
        this.lastSaving += timeSinceLastTick;
        int savingPeriod = Integer.parseInt((String)Settings.getDefault().getSetting("savingPeriod")) * 1000;
        if (this.lastSaving > (long)savingPeriod) {
            Plan.savePlan();
            Settings.saveSettings();
            this.lastSaving = 0L;
        }
        if ((backupAge = new Date().getTime() - Long.parseLong(System.getProperty("backupCreated"))) > (requiredBackupAge = (long)(Integer.parseInt((String)Settings.getDefault().getSetting("backupAge")) * 60 * 1000))) {
            Plan.createBackup();
            System.setProperty("backupCreated", "" + new Date().getTime());
        }
        this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(this, "duration", null, new Long(this.duration)));
    }

    public Task compare(Task task, int attribute, boolean ascendingOrder) {
        switch (attribute) {
            case 0: {
                if (ascendingOrder) {
                    if (task.getPriority() >= this.priority) break;
                    task = this;
                    break;
                }
                if (task.getPriority() <= this.priority) break;
                task = this;
                break;
            }
            case 1: {
                if (ascendingOrder) {
                    if (task.getDescription().toLowerCase().compareTo(this.description.toLowerCase()) <= 0) break;
                    task = this;
                    break;
                }
                if (task.getDescription().toLowerCase().compareTo(this.description.toLowerCase()) >= 0) break;
                task = this;
                break;
            }
            case 2: {
                if (ascendingOrder) {
                    if (task.getDuration() <= this.duration) break;
                    task = this;
                    break;
                }
                if (task.getDuration() >= this.duration) break;
                task = this;
                break;
            }
            case 3: {
                if (ascendingOrder) {
                    if (task.getState() <= this.state) break;
                    task = this;
                    break;
                }
                if (task.getState() >= this.state) break;
                task = this;
                break;
            }
            case 4: {
                boolean taskRegular = task instanceof RegularTask;
                boolean thisRegular = this instanceof RegularTask;
                if (ascendingOrder) {
                    if (!(thisRegular & !taskRegular)) break;
                    task = this;
                    break;
                }
                if (!(taskRegular & !thisRegular)) break;
                task = this;
                break;
            }
            case 6: {
                if (ascendingOrder) {
                    if (task.getKeyword().toLowerCase().compareTo(this.keyword.toLowerCase()) <= 0) break;
                    task = this;
                    break;
                }
                if (task.getKeyword().toLowerCase().compareTo(this.keyword.toLowerCase()) >= 0) break;
                task = this;
                break;
            }
            case 7: {
                boolean taskPrivate = task.privateTask();
                boolean thisPrivate = this.privateTask();
                if (ascendingOrder) {
                    if (!(thisPrivate & !taskPrivate)) break;
                    task = this;
                    break;
                }
                if (!(taskPrivate & !thisPrivate)) break;
                task = this;
            }
        }
        return task;
    }

    public Task cloneTask() {
        return new Task(this.description, this.keyword, "", this.priority, STATE_NEW, 0L, this.notificationTime, this.automaticStart, this.privateTask);
    }

    public String toString() {
        return this.getDescription();
    }

    public boolean isIdleTask() {
        return false;
    }
}

