/*
 * Decompiled with CFR 0.152.
 */
package org.cesilko.rachota.core.filters;

import java.util.Iterator;
import java.util.Vector;
import org.cesilko.rachota.core.Task;
import org.cesilko.rachota.core.Translator;
import org.cesilko.rachota.core.filters.AbstractTaskFilter;

public class StateFilter
extends AbstractTaskFilter {
    public static final int RULE_EQUALS = 0;
    public static final int RULE_EQUALS_NOT = 1;

    public StateFilter(int contentRule, Integer state) {
        super(contentRule, state.toString());
    }

    public StateFilter() {
        this(0, new Integer(Task.STATE_NEW));
    }

    @Override
    public Vector getContentRules() {
        Vector<String> contentRules = new Vector<String>();
        contentRules.add(Translator.getTranslation("FILTER.RULE_EQUALS"));
        contentRules.add(Translator.getTranslation("FILTER.RULE_EQUALS_NOT"));
        return contentRules;
    }

    @Override
    public Vector getContentValues() {
        Vector<String> contentValues = new Vector<String>();
        contentValues.add(Translator.getTranslation("TASK_STATE_0"));
        contentValues.add(Translator.getTranslation("TASK_STATE_1"));
        contentValues.add(Translator.getTranslation("TASK_STATE_2"));
        return contentValues;
    }

    @Override
    public String getContent() {
        int index = Integer.parseInt(super.getContent());
        return (String)this.getContentValues().get(index);
    }

    @Override
    public Vector filterTasks(Vector tasks) {
        Vector filteredTasks = (Vector)tasks.clone();
        Iterator iterator = tasks.iterator();
        int requiredState = this.getContentValues().indexOf(this.getContent());
        int contentRule = this.getContentRule();
        block4: while (iterator.hasNext()) {
            Task task = (Task)iterator.next();
            switch (contentRule) {
                case 0: {
                    if (task.getState() == requiredState) continue block4;
                    filteredTasks.remove(task);
                    continue block4;
                }
                case 1: {
                    if (task.getState() != requiredState) continue block4;
                    filteredTasks.remove(task);
                    continue block4;
                }
            }
            System.out.println("Error: Task state can't be filtered by content rule: " + this.getContentRules().get(contentRule));
        }
        return filteredTasks;
    }

    @Override
    public String toString() {
        return Translator.getTranslation("TASK_STATE");
    }
}

