/*
 * Decompiled with CFR 0.152.
 */
package org.cesilko.rachota.gui;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.cesilko.rachota.core.Translator;
import org.cesilko.rachota.core.filters.AbstractTaskFilter;

public class FiltersTableModel
extends AbstractTableModel {
    public static final int FILTER_NAME = 0;
    public static final int FILTER_CONTENT_RULE = 1;
    public static final int FILTER_CONTENT = 2;
    private Vector filters = new Vector();

    public void addFilter(AbstractTaskFilter taskFilter) {
        this.filters.add(taskFilter);
        this.fireTableDataChanged();
    }

    public void removeFilter(AbstractTaskFilter taskFilter) {
        this.filters.remove(taskFilter);
        this.fireTableDataChanged();
    }

    public void replaceFilter(AbstractTaskFilter oldTaskFilter, AbstractTaskFilter newTaskFilter) {
        int index = this.filters.indexOf(oldTaskFilter);
        this.filters.setElementAt(newTaskFilter, index);
        this.fireTableDataChanged();
    }

    public AbstractTaskFilter getFilter(int row) {
        AbstractTaskFilter taskFilter = null;
        if (row < this.filters.size()) {
            taskFilter = (AbstractTaskFilter)this.filters.get(row);
        }
        return taskFilter;
    }

    public Vector getFilters() {
        return this.filters;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        if (this.filters == null) {
            return 0;
        }
        return this.filters.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        AbstractTaskFilter taskFilter = (AbstractTaskFilter)this.filters.get(row);
        switch (column) {
            case 0: {
                return taskFilter.toString();
            }
            case 1: {
                return taskFilter.getContentRules().get(taskFilter.getContentRule());
            }
            case 2: {
                return taskFilter.getContent();
            }
        }
        return "N/A";
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return Translator.getTranslation("FILTER.NAME");
            }
            case 1: {
                return Translator.getTranslation("FILTER.CONTENT_RULE");
            }
            case 2: {
                return Translator.getTranslation("FILTER.CONTENT");
            }
        }
        return "N/A";
    }
}

