/*
 * Decompiled with CFR 0.152.
 */
package org.cesilko.rachota.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JPanel;
import org.cesilko.rachota.core.Day;
import org.cesilko.rachota.core.Settings;
import org.cesilko.rachota.core.Task;
import org.cesilko.rachota.core.Translator;
import org.cesilko.rachota.core.filters.AbstractTaskFilter;
import org.cesilko.rachota.gui.Tools;

public class HistoryChart
extends JPanel
implements PropertyChangeListener {
    private Vector days;
    private AbstractTaskFilter taskFilter;
    private int chartType;
    int maxValueY;
    int minValueY;
    private double xStep;
    private double yStep;
    public static final int TYPE_TOTAL = 0;
    public static final int TYPE_FROM_TO = 1;
    public static final int TYPE_TIME_USAGE = 2;
    private static final int INSET_LEFT = 20;
    private static final int INSET_RIGHT = 10;
    private static final int INSET_TOP = 10;
    private static final int INSET_BOTTOM = 30;
    private static final Color LIGHT_GREEN = new Color(0, 153, 153);

    public HistoryChart(Vector days, AbstractTaskFilter taskFilter, int chartType) {
        this.setDays(days);
        this.setHighlightingFilter(taskFilter);
        this.setChartType(chartType);
        Settings.getDefault().addPropertyChangeListener(this);
    }

    public void setDays(Vector days) {
        this.days = days;
        this.repaint();
    }

    public void setHighlightingFilter(AbstractTaskFilter taskFilter) {
        this.taskFilter = taskFilter;
        this.repaint();
    }

    public void setChartType(int chartType) {
        this.chartType = chartType;
        this.repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        this.setFont(Tools.getFont());
        graphics.setColor(new Color(240, 240, 240));
        graphics.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
        this.computeSteps();
        this.drawAxes(graphics, true);
        this.drawHours(graphics);
        this.drawReferenceLines(graphics, true, true);
    }

    private void computeSteps() {
        this.computeMaxMinY();
        this.xStep = (double)(this.getBounds().width - 20 - 10) / (double)this.days.size();
        this.yStep = (double)(this.getBounds().height - 10 - 30) / (double)(this.maxValueY - this.minValueY);
    }

    private void computeMaxMinY() {
        this.minValueY = 24;
        this.maxValueY = 0;
        for (Day day : this.days) {
            int hours;
            if (this.chartType == 0 && (hours = (int)day.getTotalTime((Boolean)Settings.getDefault().getSetting("countPrivateTasks")) / 3600000) > this.maxValueY) {
                this.maxValueY = hours;
            }
            if (this.chartType == 2) {
                int hours2;
                Date finishTime;
                Iterator tasks = day.getTasks().iterator();
                long totalTime = 0L;
                while (tasks.hasNext()) {
                    Task task = (Task)tasks.next();
                    totalTime += task.getDuration();
                }
                if (day.getIdleTask().getDuration() == 0L && (finishTime = day.getFinishTime()) != null) {
                    totalTime = day.getFinishTime().getTime() - day.getStartTime().getTime();
                }
                if ((hours2 = (int)totalTime / 3600000) > this.maxValueY) {
                    this.maxValueY = hours2;
                }
            }
            if (this.chartType != 1 || !(day.getStartTime() != null & day.getFinishTime() != null)) continue;
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(day.getStartTime());
            int hour = calendar.get(11);
            if (hour < this.minValueY) {
                this.minValueY = hour;
            }
            calendar.setTime(day.getFinishTime());
            hour = calendar.get(11);
            if (hour <= this.maxValueY) continue;
            this.maxValueY = hour;
        }
        if (this.minValueY == 24) {
            this.minValueY = 0;
        }
        this.maxValueY = this.maxValueY != 0 ? (this.maxValueY += 2) : 25;
    }

    private void drawAxes(Graphics graphics, boolean drawGrid) {
        int width = this.getBounds().width;
        int height = this.getBounds().height;
        graphics.setColor(LIGHT_GREEN);
        graphics.drawRect(20, 10, width - 20 - 10, height - 10 - 30);
        int lastValueX = 0;
        int lastLineX = 0;
        int columns = this.days.size();
        for (int i = 0; i < columns; ++i) {
            int xi = (int)(20.0 + this.xStep * (double)(i + 1));
            if (xi - lastLineX > 5) {
                graphics.setColor(LIGHT_GREEN);
                graphics.drawLine(xi, height - 30, xi, height - 30 - 5);
                lastLineX = xi;
            }
            if (xi - lastValueX <= 50) continue;
            String value = this.days.get(i).toString();
            int correction = value.length() * 3;
            graphics.setColor(Color.DARK_GRAY);
            graphics.drawString(this.days.get(i).toString(), (int)(20.0 + this.xStep * ((double)i + 0.5) - (double)correction), height - 15);
            lastValueX = xi;
        }
        int lastValueY = height - 30;
        int lastLineY = height - 30;
        int gridStep = (this.maxValueY - this.minValueY) / 5;
        int nextGrid = gridStep - 1;
        for (int i = 0; i < this.maxValueY - this.minValueY; ++i) {
            int yi = (int)((double)(height - 30) - this.yStep * (double)(i + 1));
            if (lastLineY - yi > 5) {
                graphics.setColor(LIGHT_GREEN);
                graphics.drawLine(20, yi, 25, yi);
                lastLineY = yi;
            }
            if (drawGrid && i == nextGrid) {
                graphics.setColor(LIGHT_GREEN);
                graphics.drawLine(20, yi, width - 10, yi);
                nextGrid += gridStep;
            }
            if (lastValueY - yi <= 50) continue;
            String valueY = "" + (this.minValueY + i);
            graphics.setColor(Color.DARK_GRAY);
            graphics.drawString(valueY, this.minValueY + i > 9 ? 2 : 6, (int)((double)(height - 30) - this.yStep * (double)i + 3.0));
            lastValueY = yi;
        }
    }

    private void drawHours(Graphics graphics) {
        int height = this.getBounds().height;
        int width = this.getBounds().width;
        int count = this.days.size();
        long totalTimeFiltered = 0L;
        for (int i = 0; i < count; ++i) {
            int correction;
            int idleHeight;
            int privateHeight;
            Day day = (Day)this.days.get(i);
            if (this.chartType == 0) {
                double hours = (double)day.getTotalTime((Boolean)Settings.getDefault().getSetting("countPrivateTasks")) / 3600000.0;
                int columnHeight = (int)((double)(height - 30 - 10) * (hours / (double)this.maxValueY));
                int x = 20 + (int)(this.xStep * (double)i) + (this.xStep > 4.0 ? 2 : 0);
                if (columnHeight != 0) {
                    Vector filteredTasks;
                    graphics.setColor(Color.LIGHT_GRAY);
                    graphics.fillRect(x, height - 30 - columnHeight, (int)(this.xStep > 4.0 ? this.xStep - 3.0 : this.xStep), columnHeight);
                    if (this.taskFilter != null && (filteredTasks = this.taskFilter.filterTasks(day.getTasks())).size() != 0) {
                        filteredTasks.remove(day.getIdleTask());
                        Iterator iterator = filteredTasks.iterator();
                        long totalTime = 0L;
                        Boolean countPrivateTasks = (Boolean)Settings.getDefault().getSetting("countPrivateTasks");
                        while (iterator.hasNext()) {
                            Task task = (Task)iterator.next();
                            if (task.privateTask() && !countPrivateTasks.booleanValue()) continue;
                            totalTime += task.getDuration();
                        }
                        totalTimeFiltered += totalTime;
                        double filtered = (double)totalTime / 3600000.0;
                        int filteredTasksHeight = (int)((double)(height - 30 - 10) * (filtered / (double)this.maxValueY));
                        graphics.setColor(Color.CYAN);
                        graphics.fillRect(x, height - 30 - filteredTasksHeight, (int)(this.xStep > 4.0 ? this.xStep - 3.0 : this.xStep), filteredTasksHeight);
                        graphics.setColor(Color.DARK_GRAY);
                        graphics.drawRect(x, height - 30 - filteredTasksHeight, (int)(this.xStep > 4.0 ? this.xStep - 3.0 : this.xStep), filteredTasksHeight);
                    }
                    graphics.setColor(Color.DARK_GRAY);
                    graphics.drawRect(x, height - 30 - columnHeight, (int)(this.xStep > 4.0 ? this.xStep - 3.0 : this.xStep), columnHeight);
                    String value = Tools.getTime(day.getTotalTime((Boolean)Settings.getDefault().getSetting("countPrivateTasks")));
                    value = value.substring(0, value.lastIndexOf(":"));
                    if (hours < 10.0) {
                        value = value.substring(1);
                    }
                    int correction2 = graphics.getFontMetrics().stringWidth(value);
                    graphics.setColor(Color.DARK_GRAY);
                    if ((double)correction2 <= this.xStep + 2.0) {
                        graphics.drawString(value, (int)((double)x + this.xStep / 2.0 - (double)(correction2 / 2) - 1.0), height - 30 - columnHeight - 10);
                    }
                }
            }
            if (this.chartType == 1 && day.getStartTime() != null & day.getFinishTime() != null) {
                String finish;
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(day.getStartTime());
                int hour = calendar.get(11);
                int minute = calendar.get(12);
                double startTime = (double)hour + (double)minute / 60.0;
                calendar.setTime(day.getFinishTime());
                hour = calendar.get(11);
                minute = calendar.get(12);
                double finishTime = (double)hour + (double)minute / 60.0;
                int x = 20 + (int)(this.xStep * (double)i) + (this.xStep > 4.0 ? 2 : 0);
                int y1 = (int)((double)(height - 30) - this.yStep * (finishTime - (double)this.minValueY));
                int y2 = (int)(this.yStep * (finishTime - startTime));
                graphics.setColor(Color.LIGHT_GRAY);
                graphics.fillRect(x, y1, (int)(this.xStep > 4.0 ? this.xStep - 3.0 : this.xStep), y2);
                graphics.setColor(Color.DARK_GRAY);
                graphics.drawRect(x, y1, (int)(this.xStep > 4.0 ? this.xStep - 3.0 : this.xStep), y2);
                String start = Tools.getTime(day.getStartTime());
                if (start.charAt(0) == '0') {
                    start = start.substring(1);
                }
                if ((finish = Tools.getTime(day.getFinishTime())).charAt(0) == '0') {
                    finish = finish.substring(1);
                }
                int widthStart = graphics.getFontMetrics().stringWidth(start);
                int widthFinish = graphics.getFontMetrics().stringWidth(finish);
                graphics.setColor(Color.DARK_GRAY);
                if (!start.equals("0:00") && (double)widthStart <= this.xStep + 2.0) {
                    graphics.drawString(start, (int)((double)x + this.xStep / 2.0 - (double)(widthStart / 2) - 1.0), y1 + y2 - 10);
                }
                if (!finish.equals("0:00") && (double)widthFinish <= this.xStep + 2.0) {
                    graphics.drawString(finish, (int)((double)x + this.xStep / 2.0 - (double)(widthFinish / 2) - 1.0), y1 - 10);
                }
            }
            if (this.chartType != 2) continue;
            Task idleTask = day.getIdleTask();
            Iterator tasks = day.getTasks().iterator();
            double privateTime = 0.0;
            double totalTime = 0.0;
            while (tasks.hasNext()) {
                Task task = (Task)tasks.next();
                if (task.privateTask()) {
                    privateTime += (double)task.getDuration() / 3600000.0;
                    continue;
                }
                if (task.isIdleTask()) continue;
                totalTime += (double)task.getDuration() / 3600000.0;
            }
            double idleTime = 0.0;
            if (idleTask.getDuration() == 0L) {
                Date finishTime = day.getFinishTime();
                if (finishTime != null) {
                    idleTime = day.getFinishTime().getTime() - day.getStartTime().getTime() - day.getTotalTime(true);
                    idleTime /= 3600000.0;
                }
            } else {
                idleTime = (double)idleTask.getDuration() / 3600000.0;
            }
            int x = 20 + (int)(this.xStep * (double)i) + (this.xStep > 4.0 ? 2 : 0);
            int totalHeight = (int)((double)(height - 30 - 10) * ((totalTime + privateTime) / (double)this.maxValueY));
            if (totalHeight != 0) {
                graphics.setColor(Color.LIGHT_GRAY);
                graphics.fillRect(x, height - 30 - totalHeight, (int)(this.xStep > 4.0 ? this.xStep - 3.0 : this.xStep), totalHeight);
                graphics.setColor(Color.DARK_GRAY);
                graphics.drawRect(x, height - 30 - totalHeight, (int)(this.xStep > 4.0 ? this.xStep - 3.0 : this.xStep), totalHeight);
            }
            if ((privateHeight = (int)((double)(height - 30 - 10) * (privateTime / (double)this.maxValueY))) != 0) {
                graphics.setColor(Color.BLUE);
                graphics.fillRect(x, height - 30 - privateHeight, (int)(this.xStep > 4.0 ? this.xStep - 3.0 : this.xStep), privateHeight);
                graphics.setColor(Color.DARK_GRAY);
                graphics.drawRect(x, height - 30 - privateHeight, (int)(this.xStep > 4.0 ? this.xStep - 3.0 : this.xStep), privateHeight);
            }
            if ((idleHeight = (int)((double)(height - 30 - 10) * (idleTime / (double)this.maxValueY))) != 0) {
                graphics.setColor(Color.CYAN);
                graphics.fillRect(x, height - 30 - totalHeight - idleHeight, (int)(this.xStep > 4.0 ? this.xStep - 3.0 : this.xStep), idleHeight);
                graphics.setColor(Color.DARK_GRAY);
                graphics.drawRect(x, height - 30 - totalHeight - idleHeight, (int)(this.xStep > 4.0 ? this.xStep - 3.0 : this.xStep), idleHeight);
            }
            graphics.setColor(Color.BLACK);
            String working_Time = Translator.getTranslation("HISTORYCHART.WORKING_TIME");
            String private_Time = Translator.getTranslation("HISTORYCHART.PRIVATE_TIME");
            String idle_Time = Translator.getTranslation("HISTORYCHART.IDLE_TIME");
            int maxCorrection = correction = graphics.getFontMetrics().stringWidth(working_Time);
            correction = graphics.getFontMetrics().stringWidth(private_Time);
            if (correction > maxCorrection) {
                maxCorrection = correction;
            }
            if ((correction = graphics.getFontMetrics().stringWidth(idle_Time)) > maxCorrection) {
                maxCorrection = correction;
            }
            graphics.setColor(Color.WHITE);
            graphics.fillRect(width - 10 - maxCorrection - 25, 15, maxCorrection + 20, 50);
            graphics.setColor(Color.DARK_GRAY);
            graphics.drawRect(width - 10 - maxCorrection - 25, 15, maxCorrection + 20, 50);
            graphics.drawString(working_Time, width - 10 - maxCorrection - 6, 30);
            graphics.drawString(private_Time, width - 10 - maxCorrection - 6, 45);
            graphics.drawString(idle_Time, width - 10 - maxCorrection - 6, 60);
            graphics.setColor(Color.LIGHT_GRAY);
            graphics.fillRect(width - 10 - 20 - maxCorrection, 20, 10, 10);
            graphics.setColor(Color.DARK_GRAY);
            graphics.drawRect(width - 10 - 20 - maxCorrection, 20, 10, 10);
            graphics.setColor(Color.BLUE);
            graphics.fillRect(width - 10 - 20 - maxCorrection, 35, 10, 10);
            graphics.setColor(Color.DARK_GRAY);
            graphics.drawRect(width - 10 - 20 - maxCorrection, 35, 10, 10);
            graphics.setColor(Color.CYAN);
            graphics.fillRect(width - 10 - 20 - maxCorrection, 50, 10, 10);
            graphics.setColor(Color.DARK_GRAY);
            graphics.drawRect(width - 10 - 20 - maxCorrection, 50, 10, 10);
        }
        if (this.chartType == 0 && this.taskFilter != null) {
            String text = Translator.getTranslation("HISTORYCHART.HIGHLIGHTED_TASKS_TIME") + " " + Tools.getTime(totalTimeFiltered);
            text = text.substring(0, text.lastIndexOf(":"));
            int correction = graphics.getFontMetrics().stringWidth(text);
            graphics.setColor(Color.BLACK);
            graphics.drawString(text, width - 10 - correction - 10, 25);
        }
    }

    private void drawReferenceLines(Graphics graphics, boolean drawAverageHours, boolean drawGivenHours) {
        int y;
        if (this.chartType != 0) {
            return;
        }
        Iterator iterator = this.days.iterator();
        double totalHours = 0.0;
        int workDays = 0;
        while (iterator.hasNext()) {
            Day day = (Day)iterator.next();
            totalHours += (double)day.getTotalTime((Boolean)Settings.getDefault().getSetting("countPrivateTasks")) / 3600000.0;
            if (day.getTotalTime((Boolean)Settings.getDefault().getSetting("countPrivateTasks")) == 0L) continue;
            ++workDays;
        }
        double averageAll = totalHours / (double)this.days.size();
        double averageWork = workDays == 0 ? 0.0 : totalHours / (double)workDays;
        double given = Settings.getDefault().getWorkingHours();
        int width = this.getBounds().width;
        int height = this.getBounds().height;
        Font originalFont = this.getFont();
        graphics.setFont(new Font("Monospaced", 0, originalFont.getSize()));
        if (drawAverageHours) {
            graphics.setColor(Color.BLUE);
            y = (int)((double)(height - 30) - this.yStep * averageWork);
            graphics.drawLine(20, y, width - 10, y);
            String legend = Translator.getTranslation("HISTORYCHART.AVERAGE_WORK");
            int correction = graphics.getFontMetrics().stringWidth(legend);
            graphics.drawString(legend, width - 10 - correction, y - 5);
            graphics.setColor(Color.MAGENTA);
            y = (int)((double)(height - 30) - this.yStep * averageAll);
            graphics.drawLine(20, y, width - 10, y);
            graphics.drawString(Translator.getTranslation("HISTORYCHART.AVERAGE_ALL"), 25, y - 5);
        }
        if (drawGivenHours) {
            graphics.setColor(Color.RED);
            y = (int)((double)(height - 30) - this.yStep * given);
            graphics.drawLine(20, y, width - 10, y);
            graphics.drawString(Translator.getTranslation("HISTORYCHART.GIVEN_HOURS"), 25, y - 5);
        }
        graphics.setFont(originalFont);
    }

    public Day getDayAt(Point point) {
        int index;
        double x = point.getX();
        if (x - 20.0 < 0.0 | (index = (int)((x - 20.0) / this.xStep)) >= this.days.size()) {
            return null;
        }
        return (Day)this.days.get(index);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.repaint();
    }
}

