/*
 * Decompiled with CFR 0.152.
 */
package org.cesilko.rachota.gui;

import java.beans.PropertyChangeEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.ImageIcon;
import org.cesilko.rachota.core.Translator;
import org.cesilko.rachota.core.filters.AbstractTaskFilter;
import org.cesilko.rachota.gui.GenericWizard;
import org.cesilko.rachota.gui.HistoryChart;
import org.cesilko.rachota.gui.InvoiceGenerator;
import org.cesilko.rachota.gui.ReportContentWizardStep;
import org.cesilko.rachota.gui.ReportGenerator;
import org.cesilko.rachota.gui.ReportOutputWizardStep;

public class ReportWizard
extends GenericWizard {
    static final String TYPE_REPORT = "report";
    static final String TYPE_INVOICE = "invoice";
    static final String REPORT_ROWS_TASKS = "tasks";
    static final String REPORT_ROWS_PROJECTS = "projects";
    static final String OUTPUT_HTML = ".html";
    static final String OUTPUT_TXT = ".txt";
    static final String OUTPUT_CSV = ".csv";
    static final String INVOICE_TASKS_PROJECTS = "projects_tasks";
    static final String INVOICE_TASKS = "tasks";
    static final String SORTBY_DURATION = "duration";
    static final String SORTBY_PROJECTS_TASKS = "projects/tasks";
    static final String SORTBY_OCCURRENCES = "occurrences";
    static final String SORTBY_NOTES = "notes";
    private Vector days;
    private HistoryChart chart;
    private AbstractTaskFilter highlightFilter;
    private Vector selectFilters;

    public ReportWizard(Vector days, HistoryChart chart, AbstractTaskFilter highlightFilter, Vector selectFilters) {
        super(Translator.getTranslation("REPORTWIZARD.TITLE"));
        this.days = days;
        this.chart = chart;
        this.highlightFilter = highlightFilter;
        this.selectFilters = selectFilters;
        ReportOutputWizardStep reportOutputWizardStep = new ReportOutputWizardStep(this);
        ReportContentWizardStep reportContentWizardStep = new ReportContentWizardStep(this);
        reportOutputWizardStep.addPropertyChangeListener(reportContentWizardStep);
        this.setPreview(TYPE_REPORT);
        this.setSize(700, 530);
        this.setLocationRelativeTo(null);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        Object property = evt.getNewValue();
        ReportWizard.setWizardProperty(propertyName, property);
        if (propertyName.equals("report.output.file_selected")) {
            this.checkButtons();
        }
        if (propertyName.equals("invoice.currency")) {
            this.checkButtons();
        }
        if (propertyName.equals("invoice.tax")) {
            this.checkButtons();
        }
        if (propertyName.equals("invoice.price")) {
            this.checkButtons();
        }
        if (propertyName.equals("report.type")) {
            this.setPreview((String)property);
        }
        if (propertyName.equals("status.error")) {
            this.setStatus((String)property);
        }
        if (propertyName.equals("wizard.step.next")) {
            if (property instanceof ReportOutputWizardStep) {
                this.goNextStep();
            } else {
                this.finishWizard();
            }
        }
        if (propertyName.equals("wizard.cancel")) {
            this.cancelWizard();
        }
    }

    private void setPreview(String previewType) {
        if (TYPE_REPORT.equals(previewType)) {
            this.setPreview(new ImageIcon(this.getClass().getResource("/org/cesilko/rachota/gui/images/report_preview.png")));
        } else {
            this.setPreview(new ImageIcon(this.getClass().getResource("/org/cesilko/rachota/gui/images/invoice_preview.png")));
        }
    }

    @Override
    public void finishWizard() {
        this.setVisible(false);
        String reportType = (String)ReportWizard.getWizardProperty("report.type");
        File outputFile = (File)ReportWizard.getWizardProperty("report.output.file_selected");
        if (reportType.equals(TYPE_REPORT)) {
            String reportTitle = (String)ReportWizard.getWizardProperty("report.title");
            Boolean showChart = (Boolean)ReportWizard.getWizardProperty("report.chart");
            Boolean showFilters = (Boolean)ReportWizard.getWizardProperty("report.filters");
            String rowsRepresent = (String)ReportWizard.getWizardProperty("report.rows");
            Boolean includeDuration = (Boolean)ReportWizard.getWizardProperty("report.content.duration");
            Boolean includeProjectsTasks = (Boolean)ReportWizard.getWizardProperty("report.content.projects_tasks");
            Boolean includeOccurrences = (Boolean)ReportWizard.getWizardProperty("report.content.occurrences");
            Boolean includeNotes = (Boolean)ReportWizard.getWizardProperty("report.content.notes");
            String sortBy = (String)ReportWizard.getWizardProperty("report.sortby");
            ReportGenerator reportGenerator = new ReportGenerator(outputFile, reportTitle, showChart, showFilters, rowsRepresent, includeDuration, includeProjectsTasks, includeOccurrences, includeNotes, sortBy, this.days, this.chart, this.highlightFilter, this.selectFilters);
            reportGenerator.generateReport();
        } else {
            String invoiceTitle = (String)ReportWizard.getWizardProperty("invoice.title");
            String userDetails = (String)ReportWizard.getWizardProperty("invoice.details.user");
            String customerDetails = (String)ReportWizard.getWizardProperty("invoice.details.customer");
            String paymentDetails = (String)ReportWizard.getWizardProperty("invoice.details.payment");
            Integer dueDays = (Integer)ReportWizard.getWizardProperty("invoice.due_days");
            Double price = Double.parseDouble((String)ReportWizard.getWizardProperty("invoice.price"));
            String currency = (String)ReportWizard.getWizardProperty("invoice.currency");
            Double tax = Double.parseDouble((String)ReportWizard.getWizardProperty("invoice.tax"));
            String rowsRepresent = (String)ReportWizard.getWizardProperty("invoice.rows");
            InvoiceGenerator invoiceGenerator = new InvoiceGenerator(outputFile, invoiceTitle, userDetails, customerDetails, paymentDetails, dueDays, price, currency, tax, rowsRepresent, this.days, this.selectFilters);
            invoiceGenerator.generateInvoice();
        }
    }
}

