/*
 * Decompiled with CFR 0.152.
 */
package org.cesilko.rachota.gui;

import java.awt.Desktop;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.net.URI;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.cesilko.rachota.core.Day;
import org.cesilko.rachota.core.Settings;
import org.cesilko.rachota.core.Task;
import org.cesilko.rachota.core.Translator;

public class Tools {
    public static final String title = "Rachota 2.4";
    public static final String build = "#140825";
    public static final int BEEP_WARNING = 0;
    public static final int BEEP_NOTIFICATION = 1;
    private static Font font = null;

    public static String getTime(double time) {
        long hours = (long)time / 3600000L;
        String text = (hours > 9L ? "" : "0") + hours;
        long minutes = (long)(time -= (double)(hours * 3600000L)) / 60000L;
        text = text + ":" + (minutes > 9L ? "" : "0") + minutes;
        long seconds = (long)(time -= (double)(minutes * 60000L)) / 1000L;
        text = text + ":" + (seconds > 9L ? "" : "0") + seconds;
        return text;
    }

    public static String getTimeShort(double time) {
        long hours = (long)time / 3600000L;
        String text = (hours > 9L ? "" : "0") + hours;
        long minutes = (long)(time -= (double)(hours * 3600000L)) / 60000L;
        text = text + ":" + (minutes > 9L ? "" : "0") + minutes;
        time -= (double)(minutes * 60000L);
        return text;
    }

    public static String getTime(Date time) {
        if (time == null) {
            return "00:00";
        }
        SimpleDateFormat df = (SimpleDateFormat)SimpleDateFormat.getDateInstance();
        String timeFormat = Translator.getTranslation("FORMAT.TIME");
        df.applyPattern(timeFormat);
        return df.format(time);
    }

    public static long getTime(String text) throws NumberFormatException {
        long time = 0L;
        if (text.length() == 5) {
            SimpleDateFormat df = (SimpleDateFormat)SimpleDateFormat.getDateInstance();
            String timeFormat = Translator.getTranslation("FORMAT.TIME");
            df.applyPattern(timeFormat);
            try {
                time = df.parse(text).getTime();
            }
            catch (ParseException ex) {
                throw new NumberFormatException("Error: Time does not comply with hh:mm format: " + text);
            }
        } else {
            int firstColon = text.indexOf(":");
            int secondColon = text.lastIndexOf(":");
            int hours = Integer.parseInt(text.substring(0, firstColon));
            int minutes = Integer.parseInt(text.substring(firstColon + 1, secondColon));
            int seconds = Integer.parseInt(text.substring(secondColon + 1, text.length()));
            time = seconds * 1000;
            time += (long)(minutes * 1000 * 60);
            time += (long)(hours * 1000 * 60 * 60);
        }
        return time;
    }

    public static long getTotalTime(boolean includeIdleTime, boolean includePrivateTime, Vector days) {
        long totalTime = 0L;
        for (Day day : days) {
            Task idleTask;
            totalTime += day.getTotalTime(includePrivateTime);
            if (!includeIdleTime || (idleTask = day.getIdleTask()) == null) continue;
            totalTime += idleTask.getDuration();
        }
        return totalTime;
    }

    public static String replaceAll(String text, String oldText, String newText) {
        int index = text.indexOf(oldText);
        while (index != -1) {
            text = text.substring(0, index) + newText + text.substring(index + oldText.length());
            index = text.indexOf(oldText, index + 1);
        }
        return text;
    }

    public static void beep(int type) {
        int[] notify = new int[]{100, 100, 100, 200, 200, 100, 100, 100, 100};
        int[] delays = new int[]{200, 200, 200, 100, 100, 200, 200, 200};
        switch (type) {
            case 1: {
                delays = notify;
            }
        }
        for (int i = 0; i < delays.length; ++i) {
            Toolkit.getDefaultToolkit().beep();
            try {
                Thread.sleep(delays[i]);
                continue;
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
    }

    public static String getRID() {
        return "Rachota 2.4|#140825|" + System.getProperty("os.name") + "|" + System.getProperty("os.arch") + "|" + System.getProperty("os.version") + "|" + System.getProperty("java.version") + "|" + Locale.getDefault().getDisplayCountry(Locale.US) + "|" + System.getProperty("user.name") + "|" + System.getProperty("user.dir");
    }

    public static Font getFont() {
        if (font == null) {
            font = new Font((String)Settings.getDefault().getSetting("fontName"), 0, Integer.parseInt((String)Settings.getDefault().getSetting("fontSize")));
        }
        return font;
    }

    public static void recordActivity() {
        System.setProperty("rachota.lastInteraction", "" + new Date().getTime());
    }

    public static long getInactivity() {
        String lastActivity = System.getProperty("rachota.lastInteraction");
        if (lastActivity == null) {
            return 0L;
        }
        return new Date().getTime() - Long.parseLong(lastActivity);
    }

    public static void setupSelectAllListener(JSpinner spinner) {
        FocusAdapter spinnerFocus = new FocusAdapter(){

            @Override
            public void focusGained(final FocusEvent e) {
                if (e.getSource() instanceof JTextField) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            ((JTextField)e.getSource()).selectAll();
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
            }
        };
        if (spinner.getEditor() instanceof JSpinner.DefaultEditor) {
            ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField().addFocusListener(spinnerFocus);
        }
    }

    static String getRandomID() {
        Double randomID = new Double(Math.random());
        return randomID.toString().substring(2, 5);
    }

    static void showURL(String webPage) {
        if (System.getProperty("java.version").startsWith("1.6")) {
            try {
                URI url = new URI(webPage);
                Desktop.getDesktop().browse(url);
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String[] commands = null;
        String os = System.getProperty("os.name");
        if (os.indexOf("Unix") != -1) {
            commands = new String[]{"firefox ", "konqueror ", "mozilla ", "opera "};
        }
        if (os.indexOf("Linux") != -1) {
            commands = new String[]{"firefox ", "konqueror ", "mozilla ", "opera "};
        }
        if (os.indexOf("Windows") != -1) {
            commands = new String[]{"cmd.exe /c start "};
        }
        if (os.indexOf("Macintosh") != -1) {
            commands = new String[]{"open "};
        }
        if (commands == null) {
            return;
        }
        for (int i = 0; i < commands.length; ++i) {
            String command = commands[i] + webPage;
            System.out.println("Executing \"" + command + "\" command.");
            try {
                Process process = Runtime.getRuntime().exec(command);
                process.waitFor();
                int exit = process.exitValue();
                if (exit != 0) continue;
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

