/*
 * Decompiled with CFR 0.152.
 */
package net.ponec.jworksheet.core;

import java.awt.AWTException;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import net.ponec.jworksheet.bo.Parameters;
import net.ponec.jworksheet.core.ApplContext;
import net.ponec.jworksheet.core.ApplTools;
import net.ponec.jworksheet.core.SysTray;
import net.ponec.jworksheet.gui.JWorkSheet;
import net.ponec.jworksheet.resources.ResourceProvider;

public class SysTray6
extends SysTray
implements MouseListener,
ActionListener {
    private ApplContext applContext;
    private JWorkSheet frame;
    private TrayIcon trayIcon;
    private Boolean systemTraySupport = null;
    private MenuItem miAbout = new MenuItem("About jWorkSheet");
    private MenuItem miOpen = new MenuItem("Open");
    private MenuItem miEvent = new MenuItem("Create Event");
    private MenuItem miExit = new MenuItem("Exit");

    public void init(ApplContext applContext) {
        this.applContext = applContext;
    }

    public boolean isSupported() {
        if (this.systemTraySupport == null) {
            this.frame = this.applContext.getTopFrame();
            this.initSysTray();
            this.applContext.setSystrayTooltip();
        }
        return this.systemTraySupport;
    }

    public void initSysTray() {
        this.systemTraySupport = SystemTray.isSupported();
        if (this.isSupported()) {
            PopupMenu popupMenu = new PopupMenu();
            this.miAbout.addActionListener(this);
            this.miOpen.addActionListener(this);
            this.miEvent.addActionListener(this);
            this.miExit.addActionListener(this);
            popupMenu.add(this.miAbout);
            popupMenu.addSeparator();
            popupMenu.add(this.miOpen);
            popupMenu.add(this.miEvent);
            popupMenu.addSeparator();
            popupMenu.add(this.miExit);
            Image image = new ResourceProvider().getImage(ResourceProvider.LOGO_TRY);
            this.trayIcon = new TrayIcon(image, null, popupMenu);
            this.trayIcon.setImageAutoSize(true);
            this.trayIcon.addMouseListener(this);
            try {
                SystemTray systemTray = SystemTray.getSystemTray();
                systemTray.add(this.trayIcon);
            }
            catch (AWTException aWTException) {
                this.systemTraySupport = false;
                System.err.println("TrayIcon could not be added.");
            }
        } else {
            System.out.println("System Tray is not supported");
        }
    }

    private void openWindow() {
        this.frame.setVisibleLock(true);
        new Thread(new Runnable(){

            public void run() {
                ApplTools.sleep(80);
                SysTray6.this.frame.setExtendedState(0);
                SysTray6.this.frame.setVisibleLock(false);
            }
        }).start();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        switch (mouseEvent.getButton()) {
            case 1: {
                boolean bl = mouseEvent.getClickCount() == 2;
                Enum enum_ = Parameters.P_SYSTRAY_SECOND_CLICK.of(this.applContext.getParameters());
                if (SysTray.Action.EVENT == enum_) {
                    if (bl) {
                        this.frame.createWorkEvent(true);
                    }
                    this.openWindow();
                    break;
                }
                if (SysTray.Action.HIDE == enum_ && this.frame.isVisible()) {
                    this.frame.setState(1);
                    break;
                }
                this.openWindow();
                break;
            }
            case 3: {
                this.miOpen.setLabel(this.frame.isVisible() ? "Hide" : "Open");
                break;
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.miExit) {
            try {
                this.applContext.getTopFrame().dispose();
                System.exit(0);
            }
            catch (Throwable throwable) {
                String string = throwable.getMessage() + '\n' + throwable.getClass().getName();
                this.showMessage(string, null);
            }
            System.exit(0);
        } else if (object == this.miOpen) {
            if (this.frame.isVisible()) {
                this.frame.setVisible(false);
            } else {
                this.openWindow();
            }
        } else if (object == this.miEvent) {
            this.frame.createWorkEvent(true);
            this.openWindow();
        } else if (object == this.miAbout) {
            this.showMessage("Applicaton: jWorkSheet\nVersion: 0.90\nLicense: GNU/GPL", (Object)TrayIcon.MessageType.INFO);
        }
    }

    private void showMessage(String string, Object object) {
        TrayIcon.MessageType messageType = (TrayIcon.MessageType)((Object)object);
        if (messageType == null) {
            messageType = TrayIcon.MessageType.ERROR;
        }
        String string2 = TrayIcon.MessageType.ERROR.equals((Object)messageType) ? "Error" : "Info";
        this.trayIcon.displayMessage(string2, string, messageType);
    }

    public void setTooltip(String string) {
        if (this.trayIcon != null) {
            this.trayIcon.setToolTip(ApplTools.isValid(string) ? string : "jWorkSheet");
        }
    }
}

