/*
 * Decompiled with CFR 0.152.
 */
package net.ponec.jworksheet.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.ponec.jworksheet.bo.Parameters;
import net.ponec.jworksheet.core.ApplContext;
import net.ponec.jworksheet.core.ApplTools;
import net.ponec.jworksheet.core.LanguageManager;
import net.ponec.jworksheet.gui.TopDialog;
import net.ponec.jworksheet.resources.ResourceProvider;

public class DateDialog
extends TopDialog
implements ActionListener,
ChangeListener {
    private static final Logger LOGGER = Logger.getLogger(DateDialog.class.getName());
    private final String gotoFormat;
    private final String mainFormat;
    private Date result = null;
    private JButton bCancel;
    private JButton bOK;
    private JButton bToday;
    private ButtonGroup currentDayGroup;
    private JPanel jPanel2;
    private JLabel lDate;
    private JPanel pButtons;
    private ButtonGroup reportTypeGroup;
    private JSpinner tDate;

    public DateDialog(ApplContext applContext) {
        super(applContext);
        Object object;
        this.setLocale(applContext.getLanguage());
        this.mainFormat = this.applContext.getParameters().getDateFormat(Parameters.P_DATE_MAIN_FORMAT, applContext);
        this.gotoFormat = this.applContext.getParameters().getDateFormat(Parameters.P_DATE_GOTO_FORMAT, applContext);
        this.initComponents();
        this.tDate.setValue(this.applContext.getSelectedDay().getTime());
        this.setTitle("Go to the day");
        this.setSize(300, 130);
        this.getRootPane().setDefaultButton(this.bOK);
        if (this.gotoFormat.startsWith("EEEE")) {
            ApplTools.setAlign(this.tDate, 4);
        }
        if (!Parameters.P_HIDE_ICONS.of(this.applContext.getParameters()).booleanValue()) {
            object = new ResourceProvider();
            this.bOK.setIcon(((ResourceProvider)object).getIcon("_tick.png"));
            this.bCancel.setIcon(((ResourceProvider)object).getIcon("_cross.png"));
            this.bToday.setIcon(((ResourceProvider)object).getIcon("_empty.png"));
            this.bToday.setIconTextGap(0);
        }
        object = this.applContext.getLanguageManager();
        ((LanguageManager)object).setFirstRunTexts(this);
    }

    private JSpinner createDateSpinner() {
        return ApplTools.createSpinnerDate(this.gotoFormat, this.getLocale());
    }

    public Date getResult() {
        this.setVisible(true);
        return this.result;
    }

    public final void escapeAction(ActionEvent actionEvent) {
        this.bCancelActionPerformed(actionEvent);
    }

    private void initComponents() {
        this.currentDayGroup = new ButtonGroup();
        this.reportTypeGroup = new ButtonGroup();
        this.jPanel2 = new JPanel();
        this.lDate = new JLabel();
        this.tDate = this.createDateSpinner();
        this.pButtons = new JPanel();
        this.bOK = new JButton();
        this.bCancel = new JButton();
        this.bToday = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.jPanel2.setLayout(new GridBagLayout());
        this.lDate.setText("Date:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.jPanel2.add((Component)this.lDate, gridBagConstraints);
        this.tDate.setFont(new Font("Lucida Sans", 0, 11));
        this.tDate.setPreferredSize(new Dimension(160, 18));
        this.tDate.addChangeListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel2.add((Component)this.tDate, gridBagConstraints);
        this.pButtons.setLayout(new FlowLayout(1, 5, 0));
        this.bOK.setMnemonic('O');
        this.bOK.setText("OK");
        this.bOK.addActionListener(this);
        this.pButtons.add(this.bOK);
        this.bCancel.setMnemonic('C');
        this.bCancel.setText("Cancel");
        this.bCancel.addActionListener(this);
        this.pButtons.add(this.bCancel);
        this.bToday.setMnemonic('T');
        this.bToday.setText("Today");
        this.bToday.addActionListener(this);
        this.pButtons.add(this.bToday);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.pButtons, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(15, 15, 15, 15);
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.bOK) {
            this.bOKActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.bCancel) {
            this.bCancelActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.bToday) {
            this.bTodayActionPerformed(actionEvent);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.tDate) {
            this.tDateStateChanged(changeEvent);
        }
    }

    private void tDateStateChanged(ChangeEvent changeEvent) {
        Date date = (Date)this.tDate.getValue();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.mainFormat, this.applContext.getLanguage());
        this.setTitle(simpleDateFormat.format(date));
    }

    private void bTodayActionPerformed(ActionEvent actionEvent) {
        this.tDate.setValue(new Date());
    }

    private void bOKActionPerformed(ActionEvent actionEvent) {
        this.result = (Date)this.tDate.getValue();
        this.bCancelActionPerformed(actionEvent);
    }

    private void bCancelActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.dispose();
    }
}

