/*
 * Decompiled with CFR 0.152.
 */
package net.ponec.jworksheet.report;

import java.util.ArrayList;
import java.util.Collections;
import net.ponec.jworksheet.bo.Event;
import net.ponec.jworksheet.report.TaskGroup;
import org.ujoframework.Ujo;
import org.ujoframework.UjoProperty;
import org.ujoframework.core.UjoComparator;

public class GroupSet {
    protected ArrayList<Ujo> tasks = new ArrayList();
    protected UjoComparator comparator;
    protected UjoProperty propertyTime;
    protected boolean showEmptyProject = false;
    protected TaskGroup key = new TaskGroup(null);

    public GroupSet(UjoComparator ujoComparator, UjoProperty ujoProperty) {
        this.comparator = ujoComparator;
        this.propertyTime = ujoProperty;
    }

    public TaskGroup addTime(Event event) {
        short s = (Short)event.readValue(this.propertyTime);
        if (this.showEmptyProject || s > 0) {
            TaskGroup taskGroup = this.findTaskGroup(event);
            taskGroup.addTime(s);
            return taskGroup;
        }
        return null;
    }

    protected TaskGroup findTaskGroup(Event event) {
        this.key.init(event);
        int n = Collections.binarySearch(this.tasks, this.key, this.comparator);
        if (n >= 0) {
            return (TaskGroup)this.tasks.get(n);
        }
        TaskGroup taskGroup = new TaskGroup(event);
        this.tasks.add(-n - 1, taskGroup);
        return taskGroup;
    }

    protected TaskGroup[] getGroups() {
        TaskGroup[] taskGroupArray = this.tasks.toArray(new TaskGroup[this.tasks.size()]);
        return taskGroupArray;
    }

    public int size() {
        return this.tasks.size();
    }

    public String toString() {
        return "[" + this.size() + "]";
    }

    public UjoProperty getPropertyTime() {
        return this.propertyTime;
    }

    public boolean isShowEmptyProject() {
        return this.showEmptyProject;
    }

    public void setShowEmptyProject(boolean bl) {
        this.showEmptyProject = bl;
    }
}

