/*
 * Decompiled with CFR 0.152.
 */
package net.ponec.jworksheet.report;

import java.io.IOException;
import java.util.List;
import net.ponec.jworksheet.bo.Event;
import net.ponec.jworksheet.bo.Parameters;
import net.ponec.jworksheet.bo.WorkDay;
import net.ponec.jworksheet.bo.WorkSpace;
import net.ponec.jworksheet.bo.item.YearMonthDay;
import net.ponec.jworksheet.core.ApplContext;
import net.ponec.jworksheet.core.ApplTools;
import net.ponec.jworksheet.core.Calculator;
import net.ponec.jworksheet.core.LanguageManager;
import net.ponec.jworksheet.resources.ResourceProvider;
import org.ujoframework.UjoProperty;

public abstract class SuperReport
implements Calculator {
    protected ApplContext applContext;
    protected YearMonthDay dateFrom;
    protected YearMonthDay dateTo;
    protected String reportTitle;
    protected int workDayCount = 0;

    protected String getText(CharSequence charSequence) {
        LanguageManager languageManager = this.applContext.getLanguageManager();
        if (charSequence instanceof UjoProperty) {
            return languageManager.getTextAllways((UjoProperty)charSequence);
        }
        return languageManager.getTextAllways(((Object)charSequence).toString());
    }

    public void init(ApplContext applContext, YearMonthDay yearMonthDay, YearMonthDay yearMonthDay2, String string) {
        this.applContext = applContext;
        this.dateFrom = yearMonthDay;
        this.dateTo = yearMonthDay2;
        this.reportTitle = string;
        this.init();
        for (WorkDay workDay : (List)WorkSpace.P_DAYS.of(applContext.getWorkSpace())) {
            YearMonthDay yearMonthDay3 = WorkDay.P_DATE.of(workDay);
            if (yearMonthDay3.compareTo(yearMonthDay) < 0 || yearMonthDay3.compareTo(yearMonthDay2) > 0 || WorkDay.P_EVENTS.getItemCount(workDay) <= 0) continue;
            if (!WorkDay.P_DAYOFF.of(workDay).booleanValue()) {
                ++this.workDayCount;
            }
            for (Event event : (List)WorkDay.P_EVENTS.of(workDay)) {
                this.calculate(workDay, event);
            }
        }
    }

    protected void init() {
    }

    public ApplContext getApplContext() {
        return this.applContext;
    }

    public int getWorkDayCount() {
        return this.workDayCount;
    }

    protected String escape(Object object) {
        String string;
        String string2 = string = object != null ? object.toString() : "";
        if (string.length() == 0) {
            return "&nbsp;";
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + 8);
        block8: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block8;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block8;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block8;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block8;
                }
                case '\'': {
                    stringBuilder.append("&apos;");
                    continue block8;
                }
                case ' ': {
                    stringBuilder.append(' ');
                    continue block8;
                }
                default: {
                    if (c < ' ') {
                        stringBuilder.append("&#");
                        stringBuilder.append(Integer.toString(c));
                        stringBuilder.append(';');
                        continue block8;
                    }
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public void printFilter(StringBuilder stringBuilder) {
        if (this.dateFrom.equals(this.dateTo)) {
            stringBuilder.append("\n<div style=\"margin-top:5px;\">");
            stringBuilder.append(this.getText("Date"));
            stringBuilder.append(": ");
            stringBuilder.append(this.dateFrom.toString());
            stringBuilder.append("</div>");
        } else {
            String[] stringArray = new String[]{"\n<table class=\"filter\" cellspacing=\"0\">", "<tr>", "<td>", this.getText("DateFrom"), "</td><td>", ": ", "</td><td>", this.dateFrom.toString(), "</td>", "</tr><tr>", "<td>", this.getText("DateTo"), "</td><td>", ": ", "</td><td>", this.dateTo.toString(), "</td>", "</tr><tr>", "<td>", this.getText("WorkDays"), "</td><td>", ": ", "</td><td>", String.valueOf(this.getWorkDayCount()), "</td>", "</tr>", "</table>"};
            String string = ApplTools.stringCat("", stringArray);
            stringBuilder.append(string);
        }
    }

    public String getReport(String string, String string2) {
        string2 = string2 == null ? "jWorkSheet Report" : this.escape(string2);
        String[] stringArray = new String[]{"<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">", "<html lang=\"en\"><head>", "<base href=\"" + this.applContext.getConfigDir().toURI() + "\">", "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">", "<title>" + this.escape(string2) + "</title>", "<meta name=\"Generator\" content=\"jWorkSheet\" />", "<link rel=\"stylesheet\" type=\"text/css\" href=\"" + Parameters.P_REPORT_CSS.getDefault() + "\" />", "<link rel=\"stylesheet\" type=\"text/css\" href=\"" + Parameters.P_REPORT_CSS.of(this.applContext.getParameters()) + "\" />", "</head>", "<body>", "<h2 style=\"margin-bottom:0px;\">" + this.escape(string2) + "</h2>", "&nbsp;<br />", string, "<hr />", "<div class=\"footer\">Powered by <a href=\"http://jworksheet.ponec.net/\">jWorkSheet</a> version 0.90<img src=\"styles/" + ResourceProvider.LOGO16 + "\"/></div>", "</body>", "</html>"};
        String string3 = ApplTools.stringCat("\n", stringArray);
        return string3;
    }

    protected void printTableBeg(StringBuilder stringBuilder) throws IOException {
        stringBuilder.append("<table cellspacing=\"0\" class=\"projects border\">");
    }

    protected void printTableEnd(StringBuilder stringBuilder) throws IOException {
        stringBuilder.append("</table>");
    }

    protected String formatTime(int n) {
        String string = this.applContext.getParameters().formatTime(n);
        return string;
    }

    protected String formatTimeZero(int n) {
        String string = n != 0 ? this.formatTime(n) : "&nbsp;";
        return string;
    }

    protected boolean isDayOff(YearMonthDay yearMonthDay) {
        List<WorkDay> list = WorkSpace.P_DAYS.getList(this.applContext.getWorkSpace());
        for (WorkDay workDay : list) {
            if (!WorkDay.P_DATE.equals(workDay, yearMonthDay)) continue;
            boolean bl = WorkDay.P_DAYOFF.of(workDay);
            return bl;
        }
        return false;
    }
}

