/*
 * Decompiled with CFR 0.152.
 */
package org.ujoframework.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.ujoframework.Ujo;
import org.ujoframework.UjoProperty;
import org.ujoframework.UjoPropertyList;
import org.ujoframework.core.UjoActionImpl;
import org.ujoframework.core.UjoHandlerXML;
import org.ujoframework.core.UjoService;
import org.ujoframework.extensions.ListUjoProperty;
import org.ujoframework.extensions.Property;
import org.ujoframework.extensions.UjoAction;
import org.ujoframework.extensions.UjoTextable;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UjoManagerXML
extends UjoService<UjoTextable> {
    public static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    public static final String ATTR_CLASS = "javaClass";
    public static final String ATTR_LIST = "javaList";
    public static final String ATTR_ITEM = "javaItem";
    protected String rootElementName = "body";
    protected boolean breakLineEnabled = true;
    protected UjoAction actionExport;
    protected UjoAction actionElement;

    protected UjoManagerXML() {
        super(UjoTextable.class);
    }

    public static final UjoManagerXML getInstance() {
        return new UjoManagerXML();
    }

    public <T extends UjoTextable> T parseXML(File file, Class<T> clazz, Object object) throws ParserConfigurationException, SAXException, IOException {
        return this.parseXML(file, clazz, true, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends UjoTextable> T parseXML(File file, Class<T> clazz, boolean bl, Object object) throws ParserConfigurationException, SAXException, IOException {
        InputStream inputStream = this.getInputStream(file);
        try {
            T t = this.parseXML(inputStream, clazz, bl, object);
            return t;
        }
        finally {
            inputStream.close();
        }
    }

    public <T extends UjoTextable> T parseXML(InputStream inputStream, Class<T> clazz, Object object) throws ParserConfigurationException, SAXException, IOException {
        return this.parseXML(inputStream, clazz, true, object);
    }

    public <T extends UjoTextable> T parseXML(InputStream inputStream, Class<T> clazz, boolean bl, Object object) throws ParserConfigurationException, SAXException, IOException {
        return UjoHandlerXML.parseXML(inputStream, clazz, bl, object, this.getUjoManager());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveXML(File file, UjoTextable ujoTextable, String string, Object object) throws IOException {
        OutputStream outputStream = this.getOutputStream(file);
        try {
            this.saveXML(outputStream, ujoTextable, string, object);
        }
        finally {
            outputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveXML(OutputStream outputStream, UjoTextable ujoTextable, String string, Object object) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, UTF_8);
        try {
            this.saveXML(outputStreamWriter, ujoTextable, string, object);
        }
        finally {
            ((Writer)outputStreamWriter).close();
        }
    }

    public void saveXML(Writer writer, UjoTextable ujoTextable, String string, Object object) throws IOException {
        this.saveXML(writer, this.rootElementName, ujoTextable, string, object);
        writer.flush();
    }

    public void saveXML(Writer writer, String string, UjoTextable ujoTextable, String string2, Object object) throws IOException {
        this.actionExport = new UjoActionImpl(2, object);
        this.actionElement = new UjoActionImpl(4, object);
        writer.write(string2 != null ? string2 : XML_HEADER);
        Property property = Property.newInstance(string, ujoTextable.getClass());
        this.printProperty(null, property, null, ujoTextable, writer, false);
    }

    protected void printAttributes(UjoTextable ujoTextable, Writer writer) throws IOException {
        for (UjoProperty ujoProperty : ujoTextable.readProperties()) {
            Object object = ujoTextable.readValue(ujoProperty);
            if (object == null || Ujo.class.isAssignableFrom(ujoProperty.getType()) || !this.getUjoManager().isXmlAttribute(ujoProperty) || !ujoTextable.readAuthorization(this.actionExport, ujoProperty, object) || this.getUjoManager().isTransientProperty(ujoProperty)) continue;
            String string = ujoTextable.readValueString(ujoProperty, this.actionExport);
            writer.write(32);
            writer.write(ujoProperty.getName());
            writer.write("=\"");
            this.printText2Xml(writer, string);
            writer.write(34);
        }
    }

    public void printProperties(Writer writer, UjoTextable ujoTextable) throws IOException {
        this.printProperties(writer, ujoTextable, ujoTextable.readProperties());
    }

    public void printProperties(Writer writer, UjoTextable ujoTextable, UjoPropertyList ujoPropertyList) throws IOException {
        UjoProperty ujoProperty = this.getUjoManager().getXmlElementBody(ujoTextable.getClass());
        for (UjoProperty ujoProperty2 : ujoPropertyList) {
            Class<Object> clazz;
            Object object = ujoTextable.readValue(ujoProperty2);
            if (object == null || !ujoTextable.readAuthorization(this.actionExport, ujoProperty2, object) || this.getUjoManager().isXmlAttribute(ujoProperty2) || object instanceof List && ((List)object).isEmpty() || this.getUjoManager().isTransientProperty(ujoProperty2)) continue;
            if (object instanceof List) {
                Class clazz2 = clazz = ujoProperty2 instanceof ListUjoProperty ? ((ListUjoProperty)ujoProperty2).getItemType() : null;
                if (clazz != null && ((ListUjoProperty)ujoProperty2).isItemTypeOf(Ujo.class)) {
                    for (Object e : (List)object) {
                        Class<?> clazz3 = clazz != e.getClass() ? e.getClass() : null;
                        this.printProperty(ujoTextable, ujoProperty2, clazz3, e, writer, false);
                    }
                    continue;
                }
                Iterator iterator = null;
                this.printProperty(ujoTextable, ujoProperty2, (Class)((Object)iterator), object, writer, true);
                continue;
            }
            if (ujoProperty == ujoProperty2) {
                this.writeNewLine(writer);
                this.printValue2XML(writer, Object.class, object, ujoTextable, ujoProperty2, true);
                continue;
            }
            clazz = object.getClass() != ujoProperty2.getType() ? object.getClass() : null;
            this.printProperty(ujoTextable, ujoProperty2, clazz, object, writer, false);
        }
    }

    private void printProperty(UjoTextable ujoTextable, UjoProperty ujoProperty, Class clazz, Object object, Writer writer, boolean bl) throws IOException {
        if (object == null || ujoTextable != null && !ujoTextable.readAuthorization(this.actionExport, ujoProperty, object)) {
            return;
        }
        this.writeNewLine(writer);
        writer.write(60);
        writer.write(ujoProperty.getName());
        if (object instanceof UjoTextable) {
            this.printAttributes((UjoTextable)object, writer);
        }
        if (clazz != null) {
            writer.write(32);
            writer.write(ATTR_CLASS);
            writer.write("=\"");
            writer.write(clazz.getName());
            writer.write(34);
        }
        writer.write(62);
        this.printValue2XML(writer, Object.class, object, ujoTextable, ujoProperty, bl);
        writer.write("</");
        writer.write(ujoProperty.getName());
        writer.write(62);
    }

    public void printItem(Writer writer, Class clazz, Object object, UjoTextable ujoTextable, UjoProperty ujoProperty) throws IOException {
        this.writeNewLine(writer);
        writer.write(60);
        writer.write(ATTR_ITEM);
        if (!(object == null || clazz != null && clazz.equals(object.getClass()))) {
            writer.write(32);
            writer.write(ATTR_CLASS);
            writer.write("=\"");
            writer.write(object.getClass().getName());
            writer.write("\"");
        }
        writer.write(62);
        this.printValue2XML(writer, clazz, object, ujoTextable, ujoProperty, false);
        writer.write("</");
        writer.write(ATTR_ITEM);
        writer.write(62);
    }

    public void printText2Xml(Appendable appendable, String string) throws IOException {
        int n = string.length();
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    appendable.append("&lt;");
                    continue block7;
                }
                case '>': {
                    appendable.append("&gt;");
                    continue block7;
                }
                case '&': {
                    appendable.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    appendable.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    appendable.append("&apos;");
                    continue block7;
                }
                default: {
                    if (c < ' ') {
                        appendable.append("&#");
                        appendable.append(Integer.toString(c));
                        appendable.append(';');
                        continue block7;
                    }
                    appendable.append(c);
                }
            }
        }
    }

    public final void writeNewLine(Appendable appendable) throws IOException {
        if (this.breakLineEnabled) {
            appendable.append('\n');
        }
    }

    public void printValue2XML(Writer writer, Class clazz, Object object, UjoTextable ujoTextable, UjoProperty ujoProperty, boolean bl) throws IOException {
        if (object != null) {
            if (object instanceof UjoTextable) {
                this.printProperties(writer, (UjoTextable)object);
            } else if (!bl && object instanceof List) {
                for (Object e : (List)object) {
                    this.printItem(writer, clazz, e, ujoTextable, ujoProperty);
                }
            } else {
                String string = ujoTextable.readValueString(ujoProperty, this.actionExport);
                this.printText2Xml(writer, string);
            }
        }
    }

    public String getRootElementName() {
        return this.rootElementName;
    }

    public void setRootElementName(String string) {
        this.rootElementName = string;
    }
}

