/*
 * Decompiled with CFR 0.152.
 */
package org.ujoframework.criterion;

import org.ujoframework.Ujo;
import org.ujoframework.criterion.BinaryOperator;
import org.ujoframework.criterion.Criterion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryCriterion<UJO extends Ujo>
extends Criterion<UJO> {
    private final Criterion<UJO> crn1;
    private final Criterion<UJO> crn2;
    private final BinaryOperator operator;

    public BinaryCriterion(Criterion<UJO> criterion, BinaryOperator binaryOperator, Criterion<UJO> criterion2) {
        this.crn1 = criterion;
        this.crn2 = criterion2;
        this.operator = binaryOperator;
    }

    @Override
    public final Criterion<UJO> getLeftNode() {
        return this.crn1;
    }

    @Override
    public final Criterion<UJO> getRightNode() {
        return this.crn2;
    }

    @Override
    public final BinaryOperator getOperator() {
        return this.operator;
    }

    @Override
    public boolean evaluate(UJO UJO) {
        boolean bl = this.crn1.evaluate(UJO);
        switch (this.operator) {
            case AND: {
                return bl && this.crn2.evaluate(UJO);
            }
            case OR: {
                return bl || this.crn2.evaluate(UJO);
            }
            case XOR: {
                return bl != this.crn2.evaluate(UJO);
            }
            case NAND: {
                return !bl || !this.crn2.evaluate(UJO);
            }
            case NOR: {
                return !bl && !this.crn2.evaluate(UJO);
            }
            case EQ: {
                return bl == this.crn2.evaluate(UJO);
            }
            case NOT: {
                return !bl;
            }
        }
        throw new IllegalArgumentException("Unsupported operator: " + this.operator);
    }

    @Override
    public final boolean isBinary() {
        return true;
    }

    public String toString() {
        return "{" + this.crn1 + ") " + this.operator.name() + " (" + this.crn2 + ")";
    }
}

