/*
 * Decompiled with CFR 0.152.
 */
package boplanets.gui;

import boplanets.gui.CmbPlanetsCellRenderer;
import boplanets.gui.MyColCellRenderer;
import boplanets.gui.MyTableCellEditor;
import boplanets.gui.MyTableModel;
import boplanets.gui.PlanetsPanel;
import boplanets.gui.PlanetsView;
import boplanets.planetSystem.Planet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

public class PnlOrbitalParameters
extends JPanel
implements TableModelListener {
    private JButton BtnApply;
    private JButton BtnClose;
    private JScrollPane ScrpOrbitalParams;
    private JTable TblEditableParams;
    private JTable TblOrbitalParams;
    private JComboBox cmbPlanets;
    private JScrollPane scrpEditableParams;
    private static final int PNL_WIDTH = 300;
    private static final int PNL_HEIGHT = 570;
    private JDialog _dialog;
    private WindowAdapter _dialogWindowListener;
    private int _planetIndex;
    private Planet _selPlanet;
    private static final Object[] _orbitalParamNames = new Object[]{"major axis in AU=149.598 km", "orbital period in earthdays", "sidereal day in earthdays", "sun day in earthdays", "obliquity of equator in degrees", "argument of vernal equinox in degrees", "ecliptic X-coordinate in AU", "ecliptic Y-coordinate in AU", "ecliptic Z-coordinate in AU", "rightascension in degrees", "declination in degrees", "azimuth in degrees", "altitude in degrees", "Greenw. mean sidereal time in degrees", "mean longitude in degrees"};
    private Object[] _editableParamNames = new Object[]{"numerical excentricity", "inclination of orbital in degrees", "argument of perihelion in degrees", "longitude of ascending node in degrees"};
    private static final String[] _tableHeaderEditableParams = new String[]{"Parameter Name", "Actual Value"};
    private static final String[] _tableHeaderOrbitalParams = new String[]{"Parameter Name", "Value"};
    private static final int START_ROW_DYN_PARAMS = 6;
    private static final int START_ROW_STATIC_PARAMS = 0;
    private static final int INDEX_NAMES_COL = 0;
    private static final int INDEX_DATA_COL = 1;
    private PlanetsView _parent;
    private PlanetsPanel _planetsPanel;
    private MyTableModel _modelOrbitalParams;
    private MyTableModel _modelEditableParams;
    private boolean _editableParamsChanged;
    private MyTableCellEditor _tblCellEditor;

    public PnlOrbitalParameters(PlanetsView planetsView, PlanetsPanel planetsPanel) {
        this._parent = planetsView;
        this._modelOrbitalParams = new MyTableModel(_tableHeaderOrbitalParams);
        this._modelEditableParams = new MyTableModel(_tableHeaderEditableParams);
        this.initComponents();
        this._modelOrbitalParams.setColumnData(_orbitalParamNames, 0);
        TableColumn tableColumn = this.TblOrbitalParams.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(190);
        tableColumn.setResizable(true);
        this._modelEditableParams.setColumnData(this._editableParamNames, 0);
        this._modelEditableParams.setColumnEditable(1, true);
        this.TblEditableParams.setSelectionMode(0);
        tableColumn = this.TblEditableParams.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(190);
        tableColumn.setResizable(true);
        tableColumn.setCellRenderer(new MyColCellRenderer());
        tableColumn = this.TblEditableParams.getColumnModel().getColumn(1);
        this._tblCellEditor = new MyTableCellEditor(new JTextField());
        tableColumn.setCellEditor(this._tblCellEditor);
        this._modelEditableParams.addTableModelListener(this);
        Planet[] planetArray = planetsPanel.getAllPlanets();
        int n = planetArray.length;
        for (int i = 0; i < n; ++i) {
            this.cmbPlanets.addItem(planetArray[i]);
        }
        this._planetIndex = 0;
        this.cmbPlanets.setSelectedIndex(0);
        this._selPlanet = (Planet)this.cmbPlanets.getSelectedItem();
        this._planetsPanel = planetsPanel;
        this._planetsPanel.registerStepCompleteListener(this);
        this._dialog = new JDialog(planetsView, "Orbital Parameters", false);
        this._dialog.getContentPane().add(this);
        URL uRL = this.getClass().getResource("images/icon_parameters.jpg");
        this._dialog.setIconImage(new ImageIcon(uRL).getImage());
        this._dialog.setSize(300, 570);
        this._dialog.setDefaultCloseOperation(2);
        this._dialogWindowListener = new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                PnlOrbitalParameters.this.Dialog_WindowClosed(windowEvent);
            }
        };
        this._dialog.addWindowListener(this._dialogWindowListener);
        this._dialog.setResizable(false);
        this._dialog.setVisible(true);
    }

    private void initComponents() {
        this.cmbPlanets = new JComboBox();
        this.ScrpOrbitalParams = new JScrollPane();
        this.TblOrbitalParams = new JTable();
        this.scrpEditableParams = new JScrollPane();
        this.TblEditableParams = new JTable();
        this.BtnApply = new JButton();
        this.BtnClose = new JButton();
        this.setFont(new Font("Arial", 0, 11));
        this.setPreferredSize(new Dimension(300, 570));
        this.setLayout(new FlowLayout(1, 5, 10));
        this.cmbPlanets.setFont(new Font("Arial", 0, 11));
        this.cmbPlanets.setBorder(BorderFactory.createTitledBorder(null, "Select Planet", 0, 0, new Font("Arial", 0, 11), Color.blue));
        this.cmbPlanets.setPreferredSize(new Dimension(90, 45));
        this.cmbPlanets.setRenderer(new CmbPlanetsCellRenderer());
        this.cmbPlanets.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PnlOrbitalParameters.this.cmbPlanets_ActionPerformed(actionEvent);
            }
        });
        this.add(this.cmbPlanets);
        this.ScrpOrbitalParams.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("CheckBoxMenuItem.selectionBackground")), "Static & dynamic parameters", 0, 0, new Font("Arial", 0, 11), Color.blue));
        this.ScrpOrbitalParams.setFocusable(false);
        this.ScrpOrbitalParams.setFont(new Font("Arial", 0, 11));
        this.ScrpOrbitalParams.setPreferredSize(new Dimension(285, 280));
        this.TblOrbitalParams.setBackground(UIManager.getDefaults().getColor("CheckBox.background"));
        this.TblOrbitalParams.setFont(new Font("Arial", 0, 11));
        this.TblOrbitalParams.setModel(this._modelOrbitalParams);
        this.TblOrbitalParams.setToolTipText("static or dynamic orbital parameters of the selected planet");
        this.TblOrbitalParams.setFocusable(false);
        this.TblOrbitalParams.setRequestFocusEnabled(false);
        this.TblOrbitalParams.setRowSelectionAllowed(false);
        this.TblOrbitalParams.setUpdateSelectionOnSort(false);
        this.ScrpOrbitalParams.setViewportView(this.TblOrbitalParams);
        this.add(this.ScrpOrbitalParams);
        this.scrpEditableParams.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("CheckBoxMenuItem.selectionBackground")), "Editable Parameters", 1, 0, new Font("Arial", 0, 11), Color.blue));
        this.scrpEditableParams.setFont(new Font("Arial", 0, 11));
        this.scrpEditableParams.setPreferredSize(new Dimension(285, 105));
        this.TblEditableParams.setFont(new Font("Arial", 0, 11));
        this.TblEditableParams.setModel(this._modelEditableParams);
        this.TblEditableParams.setToolTipText("edit  a parameter  & terminate  by ENTER key. Valid values: num. excentricity:[0, 0.9], all angles: [-180, 180]");
        this.TblEditableParams.setRowSelectionAllowed(false);
        this.TblEditableParams.setSurrendersFocusOnKeystroke(true);
        this.scrpEditableParams.setViewportView(this.TblEditableParams);
        this.add(this.scrpEditableParams);
        this.BtnApply.setFont(new Font("Arial", 0, 11));
        this.BtnApply.setText("Apply");
        this.BtnApply.setToolTipText("applies edited parameters, if no parameter is just edited");
        this.BtnApply.setBorder(new SoftBevelBorder(0));
        this.BtnApply.setPreferredSize(new Dimension(65, 25));
        this.BtnApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PnlOrbitalParameters.this.BtnApply_ActionPerformed(actionEvent);
            }
        });
        this.add(this.BtnApply);
        this.BtnClose.setFont(new Font("Arial", 0, 11));
        this.BtnClose.setText("Close");
        this.BtnClose.setToolTipText("close the form without applying the edited parameters");
        this.BtnClose.setBorder(new SoftBevelBorder(0));
        this.BtnClose.setPreferredSize(new Dimension(65, 25));
        this.BtnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PnlOrbitalParameters.this.BtnClose_ActionPerformed(actionEvent);
            }
        });
        this.add(this.BtnClose);
    }

    private void BtnApply_ActionPerformed(ActionEvent actionEvent) {
        int n = this.TblEditableParams.getEditingColumn();
        int n2 = this.TblEditableParams.getEditingRow();
        if (n != -1 && n2 != -1) {
            this._tblCellEditor.cancelCellEditing();
            Toolkit.getDefaultToolkit().beep();
            this.TblEditableParams.requestFocusInWindow();
            return;
        }
        double d = (Double)this._modelEditableParams.getValueAt(0, 1);
        double d2 = (Double)this._modelEditableParams.getValueAt(1, 1) * (Math.PI / 180);
        double d3 = (Double)this._modelEditableParams.getValueAt(2, 1) * (Math.PI / 180);
        double d4 = (Double)this._modelEditableParams.getValueAt(3, 1) * (Math.PI / 180);
        this._planetsPanel.applyNewOrbParams(this._selPlanet, d, d2, d3, d4);
        this.BtnApply.setEnabled(false);
        this._editableParamsChanged = false;
    }

    private void BtnClose_ActionPerformed(ActionEvent actionEvent) {
        this._dialog.dispose();
    }

    private void cmbPlanets_ActionPerformed(ActionEvent actionEvent) {
        this._planetIndex = this.cmbPlanets.getSelectedIndex();
        this._selPlanet = (Planet)this.cmbPlanets.getSelectedItem();
        this.loadStaticOrbParamters(this._selPlanet);
        this.loadDynamicOrbParameters(this._selPlanet);
        this._editableParamsChanged = false;
        this.BtnApply.setEnabled(false);
    }

    private void Dialog_WindowClosed(WindowEvent windowEvent) {
        this._planetsPanel.unregisterStepCompleteListener();
        this._parent.PnlOrbitalParametersClosed();
        this._dialog.removeWindowListener(this._dialogWindowListener);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        int n = tableModelEvent.getColumn();
        if (n < 0) {
            String string = "AllColumns";
        } else {
            this.BtnApply.setEnabled(true);
            this._editableParamsChanged = true;
        }
    }

    public void nextPositionCompleted() {
        this.loadDynamicOrbParameters(this._selPlanet);
    }

    private void loadStaticOrbParamters(Planet planet) {
        Object[] objectArray = planet.getStaticOrbParams();
        this._modelOrbitalParams.setPartColumnData(objectArray, 1, 0);
        Object[] objectArray2 = planet.getEditableOrbParams();
        this._modelEditableParams.setColumnData(objectArray2, 1);
    }

    private void loadDynamicOrbParameters(Planet planet) {
        Object[] objectArray = planet.getDynOrbParams();
        this._modelOrbitalParams.setPartColumnData(objectArray, 1, 6);
    }
}

