/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.dialog;

import de.lehmannet.om.ISchemaElement;
import de.lehmannet.om.ITarget;
import de.lehmannet.om.ui.catalog.CatalogLoader;
import de.lehmannet.om.ui.catalog.ICatalog;
import de.lehmannet.om.ui.catalog.IListableCatalog;
import de.lehmannet.om.ui.dialog.AbstractDialog;
import de.lehmannet.om.ui.dialog.SearchDialog;
import de.lehmannet.om.ui.navigation.ObservationManager;
import de.lehmannet.om.ui.navigation.tableModel.AbstractSchemaTableModel;
import de.lehmannet.om.ui.panel.AbstractPanel;
import de.lehmannet.om.ui.panel.AbstractSearchPanel;
import de.lehmannet.om.ui.util.ConstraintsBuilder;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

class CatalogPanel
extends AbstractPanel
implements ActionListener {
    private JComboBox catalogBox = new JComboBox();
    private JButton searchButton = null;
    private ICatalog selectedCatalog = null;
    private JTable table = new JTable();
    private AbstractSchemaTableModel model = null;
    private JScrollPane scrollTable = null;
    private ObservationManager om = null;
    private JButton positive = null;
    private CatalogLoader loader = null;
    private ITarget selectedTarget = null;

    public CatalogPanel(ObservationManager om) {
        super(true);
        this.loader = om.getExtensionLoader().getCatalogLoader();
        this.om = om;
        String[] cNames = this.loader.getCatalogNames();
        for (int i = 0; i < cNames.length; ++i) {
            this.catalogBox.addItem(cNames[i]);
        }
        String defaultCatalog = this.om.getConfiguration().getConfig("om.default.catalog");
        if (defaultCatalog != null && !"".equals(defaultCatalog)) {
            this.catalogBox.setSelectedItem(this.om.getConfiguration().getConfig("om.default.catalog"));
        }
        this.catalogBox.addActionListener(this);
        this.selectedCatalog = this.loader.getCatalog((String)this.catalogBox.getSelectedItem());
        if (this.selectedCatalog instanceof IListableCatalog) {
            this.model = ((IListableCatalog)this.selectedCatalog).getTableModel();
            this.table.setModel(this.model);
        }
        this.table.setSelectionMode(0);
        ListSelectionModel lsm = this.table.getSelectionModel();
        lsm.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (!lsm.isSelectionEmpty()) {
                    int selectedRow = lsm.getMinSelectionIndex();
                    CatalogPanel.this.selectedTarget = (ITarget)CatalogPanel.this.model.getSchemaElement(selectedRow);
                    ITarget[] targets = CatalogPanel.this.om.getXmlCache().getTargets();
                    for (int i = 0; i < targets.length; ++i) {
                        if (!targets[i].equals(CatalogPanel.this.selectedTarget)) continue;
                        CatalogPanel.this.selectedTarget = targets[i];
                        break;
                    }
                }
            }
        });
        this.table.setDoubleBuffered(true);
        this.setColumnSize();
        this.scrollTable = new JScrollPane(this.table);
        this.createPanel();
    }

    public ISchemaElement createSchemaElement() {
        return this.selectedTarget;
    }

    public ISchemaElement getSchemaElement() {
        return this.selectedTarget;
    }

    public ISchemaElement updateSchemaElement() {
        return this.selectedTarget;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JComboBox) {
            JComboBox box = (JComboBox)e.getSource();
            if (this.catalogBox.equals(box)) {
                String selected = (String)this.catalogBox.getSelectedItem();
                this.selectedCatalog = this.loader.getCatalog(selected);
                if (this.selectedCatalog.getSearchPanel() == null) {
                    this.searchButton.setEnabled(false);
                } else {
                    this.searchButton.setEnabled(true);
                }
                if (this.selectedCatalog instanceof IListableCatalog) {
                    this.model = ((IListableCatalog)this.selectedCatalog).getTableModel();
                    this.table.setModel(this.model);
                    this.setColumnSize();
                } else {
                    this.table.setModel(new DefaultTableModel());
                    this.showSearchDialog();
                }
            }
        } else if (e.getSource() instanceof JButton) {
            ISchemaElement result;
            if (this.searchButton.equals(e.getSource())) {
                this.showSearchDialog();
            } else if (this.positive.equals(e.getSource()) && (result = this.createSchemaElement()) != null) {
                this.om.getXmlCache().addSchemaElement(result);
                this.om.setChanged(true);
                this.processComponentEvent(new ComponentEvent(this, 103));
            }
        }
    }

    private void showSearchDialog() {
        AbstractSearchPanel panel = this.selectedCatalog.getSearchPanel();
        SearchDialog sd = new SearchDialog(AbstractDialog.bundle.getString("dialog.catalog.search.title"), panel, this, this.om);
        this.selectedTarget = (ITarget)sd.getSearchResult();
        if (this.selectedTarget != null) {
            ITarget[] targets = this.om.getXmlCache().getTargets();
            for (int i = 0; i < targets.length; ++i) {
                if (!targets[i].equals(this.selectedTarget)) continue;
                this.selectedTarget = targets[i];
                this.processComponentEvent(new ComponentEvent(this, 103));
                return;
            }
            this.om.getXmlCache().addSchemaElement((ISchemaElement)this.selectedTarget);
            this.om.setChanged(true);
            this.processComponentEvent(new ComponentEvent(this, 103));
        }
    }

    private void setColumnSize() {
        if (this.table.getColumnModel().getColumnCount() <= 1) {
            return;
        }
        this.table.setAutoResizeMode(0);
        TableColumn col = this.table.getColumnModel().getColumn(0);
        col.setPreferredWidth(((AbstractSchemaTableModel)this.table.getModel()).getColumnSize(0));
        col = this.table.getColumnModel().getColumn(1);
        col.setPreferredWidth(((AbstractSchemaTableModel)this.table.getModel()).getColumnSize(1));
        this.table.setAutoResizeMode(2);
    }

    private void createPanel() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        this.setLayout(gridbag);
        ConstraintsBuilder.buildConstraints(constraints, 0, 0, 1, 1, 5, 1);
        constraints.fill = 2;
        JLabel LcatalogName = new JLabel(AbstractDialog.bundle.getString("dialog.catalog.label.catalogName"));
        gridbag.setConstraints(LcatalogName, constraints);
        this.add(LcatalogName);
        ConstraintsBuilder.buildConstraints(constraints, 0, 1, 1, 1, 45, 1);
        gridbag.setConstraints(this.catalogBox, constraints);
        this.add(this.catalogBox);
        ConstraintsBuilder.buildConstraints(constraints, 1, 1, 1, 1, 20, 1);
        this.searchButton = new JButton(AbstractDialog.bundle.getString("dialog.catalog.label.searchButton"));
        this.searchButton.setToolTipText(AbstractDialog.bundle.getString("dialog.catalog.tooltip.searchButton"));
        this.searchButton.addActionListener(this);
        if (this.selectedCatalog.getSearchPanel() == null) {
            this.searchButton.setEnabled(false);
        }
        gridbag.setConstraints(this.searchButton, constraints);
        this.add(this.searchButton);
        ConstraintsBuilder.buildConstraints(constraints, 0, 2, 2, 1, 5, 1);
        constraints.fill = 2;
        JLabel LTargets = new JLabel(AbstractDialog.bundle.getString("dialog.catalog.label.targets"));
        gridbag.setConstraints(LTargets, constraints);
        this.add(LTargets);
        ConstraintsBuilder.buildConstraints(constraints, 0, 3, 2, 5, 45, 10);
        gridbag.setConstraints(this.scrollTable, constraints);
        this.scrollTable.setMinimumSize(new Dimension(200, 200));
        this.add(this.scrollTable);
        ConstraintsBuilder.buildConstraints(constraints, 0, 8, 2, 1, 45, 1);
        constraints.fill = 2;
        this.positive = new JButton(AbstractDialog.bundle.getString("dialog.catalog.positive"));
        this.positive.addActionListener(this);
        gridbag.setConstraints(this.positive, constraints);
        this.add(this.positive);
        ConstraintsBuilder.buildConstraints(constraints, 0, 9, 2, 1, 45, 86);
        constraints.fill = 1;
        JLabel Lfill = new JLabel("");
        gridbag.setConstraints(Lfill, constraints);
        this.add(Lfill);
    }
}

