/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.dialog;

import de.lehmannet.om.ui.dialog.AbstractDialog;
import de.lehmannet.om.ui.dialog.TargetSelectionModel;
import de.lehmannet.om.ui.navigation.ObservationManager;
import de.lehmannet.om.ui.util.ConstraintsBuilder;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class TargetSelectorPopup
extends JDialog
implements ActionListener {
    private JButton ok = null;
    private JButton cancel = null;
    private TargetSelectionModel tableModel = null;

    public TargetSelectorPopup(ObservationManager om, String title, String targetType, List preSelectedTargets) {
        super((Frame)om, true);
        super.setTitle(title);
        super.setSize(400, 210);
        super.setDefaultCloseOperation(2);
        super.setLocationRelativeTo(null);
        this.tableModel = new TargetSelectionModel(om.getXmlCache().getTargets(), targetType, preSelectedTargets);
        this.initDialog();
        super.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof JButton) {
            JButton sourceButton = (JButton)source;
            if (sourceButton.equals(this.ok)) {
                super.dispose();
            } else if (sourceButton.equals(this.cancel)) {
                super.dispose();
                this.tableModel = null;
            }
        }
    }

    public List getSelectedTargets() {
        if (this.tableModel == null) {
            return null;
        }
        return this.tableModel.getAllSelectedTargets();
    }

    private void initDialog() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        super.getContentPane().setLayout(gridbag);
        ConstraintsBuilder.buildConstraints(constraints, 0, 0, 2, 1, 90, 90);
        constraints.fill = 1;
        JTable table = new JTable(this.tableModel);
        table.setEnabled(true);
        table.setEditingColumn(1);
        table.setRowSelectionAllowed(true);
        table.setSelectionMode(0);
        table.setDoubleBuffered(true);
        table.setToolTipText(AbstractDialog.bundle.getString("popup.targetSelector.table.tooltip"));
        JScrollPane scrollPane = new JScrollPane(table);
        gridbag.setConstraints(scrollPane, constraints);
        super.getContentPane().add(scrollPane);
        ConstraintsBuilder.buildConstraints(constraints, 0, 1, 1, 1, 5, 5);
        constraints.fill = 2;
        this.ok = new JButton(AbstractDialog.bundle.getString("dialog.button.ok"));
        this.ok.addActionListener(this);
        gridbag.setConstraints(this.ok, constraints);
        super.getContentPane().add(this.ok);
        ConstraintsBuilder.buildConstraints(constraints, 1, 1, 1, 1, 5, 5);
        constraints.fill = 2;
        this.cancel = new JButton(AbstractDialog.bundle.getString("dialog.button.cancel"));
        this.cancel.addActionListener(this);
        gridbag.setConstraints(this.cancel, constraints);
        super.getContentPane().add(this.cancel);
    }
}

