/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.navigation.tableModel;

import de.lehmannet.om.IExtendableSchemaElement;
import de.lehmannet.om.IObservation;
import de.lehmannet.om.ISchemaElement;
import de.lehmannet.om.ui.comparator.EyepieceComparator;
import de.lehmannet.om.ui.comparator.FilterComparator;
import de.lehmannet.om.ui.comparator.ImagerComparator;
import de.lehmannet.om.ui.comparator.LensComparator;
import de.lehmannet.om.ui.comparator.ObservationComparator;
import de.lehmannet.om.ui.comparator.ObserverComparator;
import de.lehmannet.om.ui.comparator.ScopeComparator;
import de.lehmannet.om.ui.comparator.SessionComparator;
import de.lehmannet.om.ui.comparator.SiteComparator;
import de.lehmannet.om.ui.comparator.TargetComparator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.TreeMap;
import javax.swing.table.AbstractTableModel;

public class ExtendedSchemaTableModel
extends AbstractTableModel {
    private PropertyResourceBundle bundle = (PropertyResourceBundle)ResourceBundle.getBundle("ObservationManager", Locale.getDefault());
    private TreeMap elementMap = null;
    private boolean multipleSelection = false;
    private int currentSelectedRow = 0;

    public ExtendedSchemaTableModel(ISchemaElement[] elements, int schemaElementType, String xsiFilter, boolean multipleSelection, List preSelectedTargets) {
        this.multipleSelection = multipleSelection;
        Comparator comparator = null;
        switch (schemaElementType) {
            case 3: {
                comparator = new ImagerComparator();
                break;
            }
            case 0: {
                comparator = new EyepieceComparator();
                break;
            }
            case 8: {
                comparator = new FilterComparator();
                break;
            }
            case 9: {
                comparator = new LensComparator();
                break;
            }
            case 2: {
                comparator = new ObservationComparator();
                break;
            }
            case 6: {
                comparator = new ObserverComparator();
                break;
            }
            case 1: {
                comparator = new ScopeComparator();
                break;
            }
            case 5: {
                comparator = new SessionComparator();
                break;
            }
            case 4: {
                comparator = new SiteComparator();
                break;
            }
            case 7: {
                comparator = new TargetComparator();
            }
        }
        this.elementMap = new TreeMap(comparator);
        for (int i = 0; i < elements.length; ++i) {
            if (7 == schemaElementType && xsiFilter != null && !((IExtendableSchemaElement)elements[i]).getXSIType().equals(xsiFilter) || 2 == schemaElementType && xsiFilter != null && !((IObservation)elements[i]).getTarget().getXSIType().equals(xsiFilter)) continue;
            if (!this.multipleSelection) {
                this.elementMap.put(elements[i], new Boolean(false));
                continue;
            }
            if (preSelectedTargets != null && preSelectedTargets.contains(elements[i])) {
                this.elementMap.put(elements[i], new Boolean(true));
                continue;
            }
            this.elementMap.put(elements[i], new Boolean(false));
        }
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        if (this.elementMap == null) {
            return 5;
        }
        return this.elementMap.size();
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.elementMap.isEmpty()) {
            return "";
        }
        ISchemaElement keySchemaElement = this.elementMap.keySet().toArray(new ISchemaElement[0])[rowIndex];
        if (keySchemaElement == null) {
            return "";
        }
        switch (columnIndex) {
            case 0: {
                return this.elementMap.get(keySchemaElement);
            }
            case 1: {
                return keySchemaElement.getDisplayName();
            }
        }
        return "";
    }

    public void setValueAt(Object o, int row, int column) {
        if (column == 0 && o instanceof Boolean) {
            if (this.multipleSelection) {
                this.setSelection(row, (Boolean)o);
            } else {
                this.setSingleSelection(row, (Boolean)o);
            }
            super.fireTableDataChanged();
        }
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return String.class;
            }
        }
        return String.class;
    }

    public void setSelection(int row, boolean selection) {
        ISchemaElement keySchemaElement = this.elementMap.keySet().toArray(new ISchemaElement[0])[row];
        this.elementMap.remove(keySchemaElement);
        this.elementMap.put(keySchemaElement, new Boolean(selection));
    }

    public void setSingleSelection(int row, boolean selection) {
        if (!this.multipleSelection) {
            this.setSelection(this.currentSelectedRow, false);
        }
        this.setSelection(row, selection);
        this.currentSelectedRow = row;
    }

    public List getAllSelectedElements() {
        ArrayList<ISchemaElement> result = new ArrayList<ISchemaElement>();
        Iterator keyIterator = this.elementMap.keySet().iterator();
        ISchemaElement current = null;
        Boolean currentValue = null;
        while (keyIterator.hasNext()) {
            current = (ISchemaElement)keyIterator.next();
            currentValue = (Boolean)this.elementMap.get(current);
            if (!currentValue.booleanValue()) continue;
            result.add(current);
        }
        return result;
    }

    public String getColumnName(int column) {
        String name = "";
        switch (column) {
            case 0: {
                name = this.bundle.getString("popup.schemaSelector.selection");
                break;
            }
            case 1: {
                name = this.bundle.getString("popup.schemaSelector.schemaElement");
            }
        }
        return name;
    }

    public int getSelectedRow() {
        if (this.multipleSelection) {
            return -1;
        }
        return this.currentSelectedRow;
    }
}

