/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.navigation.tableModel;

import de.lehmannet.om.IObserver;
import de.lehmannet.om.ui.navigation.tableModel.AbstractSchemaTableModel;
import java.util.Iterator;

public class ObserverTableModel
extends AbstractSchemaTableModel {
    private static final String MODEL_ID = "Observer";

    public ObserverTableModel(IObserver[] observer) {
        this.elements = observer;
    }

    public int getColumnCount() {
        return 3;
    }

    public String getID() {
        return MODEL_ID;
    }

    public int getRowCount() {
        if (this.elements == null) {
            return 5;
        }
        return this.elements.length;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        String value = "";
        if (this.elements == null) {
            return value;
        }
        IObserver observer = (IObserver)this.elements[rowIndex];
        switch (columnIndex) {
            case 0: {
                value = observer.getSurname();
                break;
            }
            case 1: {
                value = observer.getName();
                break;
            }
            case 2: {
                Iterator i = observer.getContacts().iterator();
                while (i.hasNext()) {
                    value = value + i.next();
                    if (!i.hasNext()) continue;
                    value = value + "; ";
                }
                break;
            }
        }
        return value;
    }

    public String getColumnName(int column) {
        String name = "";
        switch (column) {
            case 0: {
                name = AbstractSchemaTableModel.bundle.getString("table.header.observer.surname");
                break;
            }
            case 1: {
                name = AbstractSchemaTableModel.bundle.getString("table.header.observer.name");
                break;
            }
            case 2: {
                name = AbstractSchemaTableModel.bundle.getString("table.header.observer.contact");
            }
        }
        return name;
    }
}

