/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.project;

import de.lehmannet.om.ITarget;
import de.lehmannet.om.ui.navigation.ObservationManager;
import de.lehmannet.om.ui.project.ProjectCatalog;
import de.lehmannet.om.ui.project.ProjectLoaderRunnable;
import de.lehmannet.om.ui.project.WaitPopup;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class ProjectLoader {
    final PropertyResourceBundle bundle = (PropertyResourceBundle)ResourceBundle.getBundle("ObservationManager", Locale.getDefault());
    private static final String PROJECTS_DIR = "projects";
    private ObservationManager observationManager = null;
    private List projectList = new ArrayList();
    ThreadGroup loadProjects = new ThreadGroup("Load all projects");

    public ProjectLoader(ObservationManager om) {
        this.observationManager = om;
        this.loadProjects();
    }

    public ProjectCatalog[] getProjects() {
        this.waitForProjectsLoaders();
        return this.projectList.toArray(new ProjectCatalog[0]);
    }

    private void waitForProjectsLoaders() {
        if (this.loadProjects.activeCount() > 0) {
            new WaitPopup(this.loadProjects, this.observationManager);
        }
    }

    private void loadProjects() {
        File path = new File(this.observationManager.getInstallDir().getAbsolutePath() + File.separator + PROJECTS_DIR);
        if (!path.exists()) {
            return;
        }
        String[] projects = path.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                File file = new File(dir.getAbsolutePath() + File.separator + name);
                return file.getName().endsWith(".omp") && !"CVS".equals(file.getName());
            }
        });
        if (projects == null || projects.length == 0) {
            return;
        }
        List userTargets = this.loadUserTargets();
        ArrayList<Thread> projectThreads = new ArrayList<Thread>();
        File projectFile = null;
        for (int i = 0; i < projects.length; ++i) {
            projectFile = new File(path.getAbsolutePath() + File.separator + projects[i]);
            ProjectLoaderRunnable runnable = new ProjectLoaderRunnable(this.observationManager, this.projectList, userTargets, projectFile, this.observationManager.isDebug());
            Thread thread = new Thread(this.loadProjects, runnable, "Load project " + projects[i]);
            projectThreads.add(thread);
        }
        Iterator iter = projectThreads.iterator();
        while (iter.hasNext()) {
            ((Thread)iter.next()).start();
        }
    }

    private List loadUserTargets() {
        ArrayList<ITarget> userTargets = new ArrayList<ITarget>();
        ITarget[] targets = this.observationManager.getXmlCache().getTargets();
        for (int i = 0; i < targets.length; ++i) {
            if (targets[i].getObserver() == null) continue;
            userTargets.add(targets[i]);
        }
        return userTargets;
    }
}

