/*
 * Decompiled with CFR 0.152.
 */
package de.lehmannet.om.ui.util;

import de.lehmannet.om.ui.dialog.IDialog;
import de.lehmannet.om.ui.extension.SchemaUILoader;
import de.lehmannet.om.ui.util.ConstraintsBuilder;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class ExtenableSchemaElementSelector
extends JDialog
implements ActionListener {
    final PropertyResourceBundle bundle = (PropertyResourceBundle)ResourceBundle.getBundle("ObservationManager", Locale.getDefault());
    private JButton ok = null;
    private JButton cancel = null;
    private JComboBox selector = null;
    private IDialog selectedSchemaElementDialog = null;
    private boolean result = false;
    private int schemaElementConstant = -1;
    private SchemaUILoader loader = null;

    public ExtenableSchemaElementSelector(JDialog parent, SchemaUILoader loader, int schemaElementConstant) {
        super((Dialog)parent, true);
        this.schemaElementConstant = schemaElementConstant;
        super.setTitle(this.bundle.getString("selector.title"));
        this.init(parent, loader);
    }

    public ExtenableSchemaElementSelector(JFrame parent, SchemaUILoader loader, int schemaElementConstant) {
        super((Frame)parent, true);
        this.schemaElementConstant = schemaElementConstant;
        super.setTitle(this.bundle.getString("selector.title"));
        this.init(parent, loader);
    }

    public void init(Window window, SchemaUILoader loader) {
        this.loader = loader;
        this.initFindingChooser();
        if (this.loader.getAllXSIDisplayNamesForCreation(this.schemaElementConstant) == null || this.loader.getAllXSIDisplayNamesForCreation(this.schemaElementConstant).length == 0) {
            JOptionPane.showMessageDialog(this, this.bundle.getString("extenableSchemaElementSelector.warning.noElements"), this.bundle.getString("title.warning"), 2);
            return;
        }
        super.setDefaultCloseOperation(2);
        super.setSize(300, 80);
        Point obsLocation = window.getLocationOnScreen();
        Dimension obsSize = window.getSize();
        int x = obsLocation.x + obsSize.width / 2 - super.getSize().width / 2;
        int y = obsLocation.y + obsSize.height / 2 - super.getSize().height / 2;
        super.setLocation(x, y);
        super.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.ok)) {
            this.result = true;
            String selectedSE = (String)this.selector.getSelectedItem();
            this.selectedSchemaElementDialog = this.loadDialog(selectedSE);
            this.dispose();
        } else if (e.getSource().equals(this.cancel)) {
            this.cancel();
        }
    }

    public IDialog getDialog() {
        return this.selectedSchemaElementDialog;
    }

    public boolean getResult() {
        return this.result;
    }

    private void initFindingChooser() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        super.getContentPane().setLayout(gridbag);
        ConstraintsBuilder.buildConstraints(constraints, 0, 0, 2, 1, 100, 100);
        constraints.fill = 2;
        this.selector = new JComboBox();
        gridbag.setConstraints(this.selector, constraints);
        this.fillSelector();
        super.getContentPane().add(this.selector);
        ConstraintsBuilder.buildConstraints(constraints, 0, 1, 1, 1, 50, 100);
        constraints.fill = 2;
        this.ok = new JButton(this.bundle.getString("selector.button.select"));
        gridbag.setConstraints(this.ok, constraints);
        this.ok.addActionListener(this);
        super.getContentPane().add(this.ok);
        ConstraintsBuilder.buildConstraints(constraints, 1, 1, 1, 1, 50, 100);
        constraints.fill = 2;
        this.cancel = new JButton(this.bundle.getString("selector.button.cancel"));
        gridbag.setConstraints(this.cancel, constraints);
        this.cancel.addActionListener(this);
        super.getContentPane().add(this.cancel);
    }

    private void fillSelector() {
        String[] names = this.loader.getAllXSIDisplayNamesForCreation(this.schemaElementConstant);
        for (int x = 0; x < names.length; ++x) {
            this.selector.addItem(names[x]);
        }
    }

    private void cancel() {
        this.dispose();
        this.result = false;
    }

    private IDialog loadDialog(String name) {
        String type = this.loader.getTypeForDisplayName(name);
        if (7 == this.schemaElementConstant) {
            return this.loader.getTargetDialog(type, null, null);
        }
        return this.loader.getSchemaElementDialog(type, this.schemaElementConstant, null, true);
    }
}

