/*
 * Decompiled with CFR 0.152.
 */
package eap.fits;

import eap.fits.FitsColumn;
import eap.fits.FitsException;
import eap.fits.FitsHeader;

public class FitsASCIIColumn
extends FitsColumn {
    int start_byte;
    int decimals;

    public FitsASCIIColumn(FitsHeader fitsHeader, int n) throws FitsException {
        block11: {
            super(fitsHeader, n);
            this.count = 1;
            this.type = this.form.charAt(0);
            try {
                if (this.type == 'I') {
                    this.representation = Class.forName("java.lang.Integer");
                    break block11;
                }
                if (this.type == 'A') {
                    this.representation = Class.forName("java.lang.String");
                    break block11;
                }
                if (this.type == 'E') {
                    this.representation = Class.forName("java.lang.Float");
                    break block11;
                }
                if (this.type == 'F') {
                    this.representation = Class.forName("java.lang.Float");
                    break block11;
                }
                if (this.type == 'D') {
                    this.representation = Class.forName("java.lang.Double");
                    break block11;
                }
                throw new FitsException("unknown ASCII table data type " + this.type);
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println(classNotFoundException);
                throw new FitsException("Unknown class in " + this);
            }
        }
        try {
            int n2 = this.form.indexOf(46);
            if (n2 >= 0) {
                this.bytes = Integer.parseInt(this.form.substring(1, n2));
                this.decimals = Integer.parseInt(this.form.substring(n2 + 1));
            } else {
                this.bytes = Integer.parseInt(this.form.substring(1));
                this.decimals = 0;
            }
        }
        catch (Exception exception) {
            throw new FitsException("Can't parse TFORM" + n + " - " + this.form + " " + exception);
        }
        this.start_byte = fitsHeader.card("TBCOL" + n).intValue() - 1;
    }

    public int getStartByte() {
        return this.start_byte;
    }

    public int getDecimals() {
        return this.decimals;
    }
}

