/*
 * Decompiled with CFR 0.152.
 */
package de.andreasroerig.gui;

import de.andreasroerig.gui.GuiHelper;
import de.andreasroerig.util.RegParams;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import regim.FrameVector;

public class CombineColorDialog
extends JDialog
implements ActionListener {
    public static final int TYPE_BLEND = 0;
    public static final int TYPE_MEDIAN = 1;
    public static final int TYPE_SIGMA = 2;
    private Choice cRot;
    private Choice cGruen;
    private Choice cBlau;
    private Button btnOk;
    private Button btnCancel;
    private int numFrames;
    private boolean okPressed;
    private RegParams theParams = RegParams.instance();

    public CombineColorDialog(Frame owner, FrameVector fv) {
        super(owner, "Blend", true);
        String title = "Blend";
        JDialog.setDefaultLookAndFeelDecorated(true);
        Point p = GuiHelper.getFrameCenter(owner);
        this.setBounds(p.x - 150, p.y - 150, 300, 300);
        this.numFrames = fv.size();
        Panel north = new Panel(new GridLayout(4, 2, 2, 2));
        Panel east = new Panel(new GridLayout(4, 1, 2, 2));
        Panel west = new Panel(new GridLayout(4, 1, 2, 2));
        Label l1 = new Label("Color:");
        Label l2 = new Label("Frame:");
        west.add(l1);
        east.add(l2);
        this.cRot = new Choice();
        this.cGruen = new Choice();
        this.cBlau = new Choice();
        int j = 0;
        while (j < this.numFrames) {
            this.cRot.addItem(fv.getFrameAt(j).getName());
            this.cGruen.addItem(fv.getFrameAt(j).getName());
            this.cBlau.addItem(fv.getFrameAt(j).getName());
            ++j;
        }
        Label lRot = new Label("Red:");
        west.add(lRot);
        east.add(this.cRot);
        Label lGruen = new Label("Green:");
        west.add(lGruen);
        east.add(this.cGruen);
        Label lBlau = new Label("Blue:");
        west.add(lBlau);
        east.add(this.cBlau);
        Panel south = new Panel();
        this.btnOk = new Button("OK");
        this.btnCancel = new Button("Cancel");
        this.btnOk.addActionListener(this);
        this.btnCancel.addActionListener(this);
        south.add(this.btnOk);
        south.add(this.btnCancel);
        this.setTitle("Combine channels");
        this.getContentPane().add((Component)west, "West");
        this.getContentPane().add((Component)east, "East");
        this.getContentPane().add((Component)south, "South");
        this.pack();
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equalsIgnoreCase("OK")) {
            System.out.println("OK gedrueckt!");
            this.okPressed = true;
        }
        if (evt.getActionCommand().equalsIgnoreCase("Cancel")) {
            this.okPressed = false;
        }
        this.setVisible(false);
        this.dispose();
    }

    public int getRedIndex() {
        return this.cRot.getSelectedIndex();
    }

    public int getGreenIndex() {
        return this.cGruen.getSelectedIndex();
    }

    public int getBlueIndex() {
        return this.cBlau.getSelectedIndex();
    }

    public boolean getOkPressed() {
        return this.okPressed;
    }
}

