/*
 * Decompiled with CFR 0.152.
 */
package de.andreasroerig.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.beans.PropertyChangeListener;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ScreenStretchPanel
extends JPanel
implements ChangeListener {
    private JSlider jslBlackPt;
    private JSlider jslWhitePt;
    private int black;
    private int white;
    private boolean locked = false;

    public ScreenStretchPanel(JFrame owner, PropertyChangeListener listener) {
        JFrame.setDefaultLookAndFeelDecorated(true);
        this.black = 0;
        this.white = 255;
        this.jslBlackPt = new JSlider(0, 255, this.black);
        this.jslWhitePt = new JSlider(0, 255, this.white);
        this.jslBlackPt.setForeground(Color.BLACK);
        this.jslBlackPt.setBackground(Color.BLACK);
        this.jslWhitePt.setForeground(Color.WHITE);
        this.jslWhitePt.setBackground(Color.WHITE);
        this.jslBlackPt.setOrientation(1);
        this.jslWhitePt.setOrientation(1);
        this.resize(owner);
        this.addPropertyChangeListener(listener);
        this.jslBlackPt.addChangeListener(this);
        this.jslWhitePt.addChangeListener(this);
        this.add(this.jslBlackPt);
        this.add(this.jslWhitePt);
        this.setVisible(true);
    }

    public void resize(JFrame owner) {
        Dimension size = new Dimension((int)this.jslBlackPt.getPreferredSize().getWidth(), owner.getHeight() - owner.getInsets().top - owner.getInsets().bottom - 65);
        this.jslBlackPt.setPreferredSize(size);
        this.jslWhitePt.setPreferredSize(size);
    }

    public int getBlack() {
        return this.jslBlackPt.getValue();
    }

    public int getWhite() {
        return this.jslWhitePt.getValue();
    }

    public JSlider getJslBlackPt() {
        return this.jslBlackPt;
    }

    public JSlider getJslWhitePt() {
        return this.jslWhitePt;
    }

    public void setValues(int black, int white) {
        this.locked = true;
        if (black != this.black) {
            this.black = black;
            this.jslBlackPt.setValue(black);
        }
        if (white != this.white) {
            this.white = white;
            this.jslWhitePt.setValue(white);
        }
        this.locked = false;
    }

    public void stateChanged(ChangeEvent event) {
        if (!(this.jslBlackPt.getValueIsAdjusting() || this.jslWhitePt.getValueIsAdjusting() || this.jslBlackPt.getValue() == this.black && this.jslWhitePt.getValue() == this.white)) {
            this.black = this.jslBlackPt.getValue();
            this.white = this.jslWhitePt.getValue();
            this.firePropertyChange(this.getName(), 0, 1);
        }
    }
}

