/*
 * Decompiled with CFR 0.152.
 */
package de.andreasroerig.gui;

import de.andreasroerig.gui.GuiHelper;
import de.andreasroerig.util.RegParams;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JDialog;
import regim.FrameVector;

public class SelectionDialog
extends JDialog
implements ActionListener {
    public static final int TYPE_BLEND = 0;
    public static final int TYPE_MEDIAN = 1;
    public static final int TYPE_SIGMA = 2;
    private Choice[] auswahl;
    private TextField[] tf;
    private Checkbox ignoreBlackBorder;
    private TextField tfSigma;
    private Button btnOk;
    private Button btnCancel;
    private int numFrames;
    private int[] frameIndices;
    private double[] weights;
    private double sigma;
    private boolean okPressed;
    private RegParams theParams = RegParams.instance();

    public SelectionDialog(Frame owner, FrameVector fv, int type) {
        this(owner, type);
        this.numFrames = fv.size();
        Panel north = new Panel(new GridLayout(this.numFrames + 1, 2, 2, 2));
        Label l1 = new Label("Frame:");
        Label l2 = new Label("Weight:");
        north.add(l1);
        north.add(l2);
        this.auswahl = new Choice[this.numFrames];
        this.tf = new TextField[this.numFrames];
        int i = 0;
        while (i < this.numFrames) {
            this.auswahl[i] = new Choice();
            this.tf[i] = new TextField("1", 3);
            this.tf[i].setEnabled(false);
            int j = 0;
            while (j < this.numFrames) {
                this.auswahl[i].addItem(fv.getFrameAt(j).getName());
                ++j;
            }
            this.auswahl[i].addItem("");
            this.auswahl[i].select("");
            north.add(this.auswahl[i]);
            north.add(this.tf[i]);
            ++i;
        }
        switch (type) {
            case 0: {
                i = 0;
                while (i < this.tf.length) {
                    this.tf[i].setEnabled(true);
                    ++i;
                }
                break;
            }
            case 1: {
                break;
            }
        }
        this.getContentPane().add((Component)north, "North");
        this.pack();
        this.setVisible(true);
    }

    public SelectionDialog(Frame owner, File[] fa, int type) {
        this(owner, type);
        this.numFrames = fa.length;
        Panel north = new Panel(new GridLayout(this.numFrames + 1, 2, 2, 2));
        Label l1 = new Label("Frame:");
        Label l2 = new Label("Weight:");
        north.add(l1);
        north.add(l2);
        this.auswahl = new Choice[this.numFrames];
        this.tf = new TextField[this.numFrames];
        int i = 0;
        while (i < this.numFrames) {
            this.auswahl[i] = new Choice();
            this.tf[i] = new TextField("1", 3);
            this.tf[i].setEnabled(false);
            this.auswahl[i].addItem(fa[i].getName());
            this.auswahl[i].setEnabled(false);
            north.add(this.auswahl[i]);
            north.add(this.tf[i]);
            ++i;
        }
        switch (type) {
            case 0: {
                i = 0;
                while (i < this.tf.length) {
                    this.tf[i].setEnabled(true);
                    ++i;
                }
                break;
            }
            case 1: {
                break;
            }
        }
        this.getContentPane().add((Component)north, "North");
        this.pack();
        this.setVisible(true);
    }

    private SelectionDialog(Frame owner, int type) {
        super(owner, "Blend", true);
        String title = "Blend";
        JDialog.setDefaultLookAndFeelDecorated(true);
        Point p = GuiHelper.getFrameCenter(owner);
        this.setBounds(p.x - 150, p.y - 150, 300, 300);
        Panel center = new Panel(new GridLayout(2, 1));
        Panel ctop = new Panel();
        this.ignoreBlackBorder = new Checkbox("Ignore black border", this.theParams.getSearchCenterDistance());
        ctop.add(this.ignoreBlackBorder);
        center.add(ctop);
        Panel cbottom = new Panel();
        Label l3 = new Label("Sigma:");
        cbottom.add(l3);
        l3.setVisible(false);
        this.tfSigma = new TextField("" + this.theParams.getCombineSigma(), 3);
        this.tfSigma.setEnabled(false);
        this.tfSigma.setVisible(false);
        cbottom.add(this.tfSigma);
        center.add(cbottom);
        Panel south = new Panel();
        this.btnOk = new Button("OK");
        this.btnCancel = new Button("Cancel");
        this.btnOk.addActionListener(this);
        this.btnCancel.addActionListener(this);
        south.add(this.btnOk);
        south.add(this.btnCancel);
        switch (type) {
            case 0: {
                title = "Blend";
                break;
            }
            case 1: {
                title = "Median combine";
                break;
            }
            case 2: {
                title = "Sigma combine";
                this.tfSigma.setEnabled(true);
                this.tfSigma.setVisible(true);
                l3.setVisible(true);
            }
        }
        this.setTitle(title);
        this.getContentPane().add((Component)center, "Center");
        this.getContentPane().add((Component)south, "South");
    }

    public void actionPerformed(ActionEvent evt) {
        int numSelected = 0;
        if (evt.getActionCommand().equalsIgnoreCase("OK")) {
            System.out.println("OK gedr\u00ef\u00bf\u00bdckt!");
            this.okPressed = true;
            int i = 0;
            while (i < this.numFrames) {
                if (!this.auswahl[i].getSelectedItem().equals("")) {
                    ++numSelected;
                }
                ++i;
            }
            this.frameIndices = new int[numSelected];
            this.weights = new double[numSelected];
            int j = 0;
            i = 0;
            while (i < this.numFrames) {
                if (!this.auswahl[i].getSelectedItem().equals("")) {
                    this.frameIndices[j] = this.auswahl[i].getSelectedIndex();
                    this.weights[j] = Double.valueOf(this.tf[j].getText());
                    ++j;
                }
                ++i;
            }
            this.sigma = Double.valueOf(this.tfSigma.getText());
            this.theParams.setIgnoreBlackBorder(this.ignoreBlackBorder.getState());
            this.theParams.setCombineSigma(this.sigma);
        }
        if (evt.getActionCommand().equalsIgnoreCase("Cancel")) {
            this.okPressed = false;
        }
        this.setVisible(false);
        this.dispose();
    }

    public double[] getWeights() {
        return this.weights;
    }

    public int[] getFrameIndices() {
        return this.frameIndices;
    }

    public boolean getOkPressed() {
        return this.okPressed;
    }

    public double getSigma() {
        return this.sigma;
    }

    public void setSigma(double sigma) {
        this.sigma = sigma;
    }
}

