/*
 * Decompiled with CFR 0.152.
 */
package de.andreasroerig.tiff;

import de.andreasroerig.bild.BWBild;
import de.andreasroerig.bild.Bild;
import de.andreasroerig.bild.RGBBild;
import de.andreasroerig.util.SLogger;
import java.io.IOException;
import java.io.RandomAccessFile;

public class TiffReader {
    protected RandomAccessFile ras;
    protected String fname;
    protected boolean bigEnd;
    protected long ifdOffset;
    protected long[] stripOffsets;
    protected long stripByteCounts;
    protected int len;
    protected int width;
    protected int bitsPerSamp;
    private int imgType;
    private int compression;
    private int photometric;
    private int rowsPerStrip;
    private int sampPerPix;
    private int bytesPerRow;
    private int tmpRowCount;
    private int tmpOffsetCount;
    private int tmpLenCount;
    private int[][] r;
    private int[][] g;
    private int[][] b;

    public TiffReader(String fname) throws IOException {
        this.fname = fname;
        this.ras = new RandomAccessFile(fname, "r");
        this.tmpRowCount = 0;
        this.tmpOffsetCount = 0;
        this.tmpLenCount = 0;
    }

    public void readFromTiff() throws IOException {
        this.readTiffHeader();
        this.readIfd();
        this.readTiffStrips();
        this.ras.close();
    }

    public Bild readBildFromTiff() throws IOException {
        Bild theBild = null;
        this.readFromTiff();
        switch (this.imgType) {
            case 1: {
                theBild = new BWBild(this);
                break;
            }
            case 0: {
                theBild = new RGBBild(this);
                break;
            }
            default: {
                throw new IOException("Unknown image type");
            }
        }
        return theBild;
    }

    public void readTiffHeader() throws IOException {
        byte[] bar = new byte[5];
        int[] theBytes = new int[5];
        this.ras.read(bar, 0, 2);
        if (bar[0] == 73 && bar[1] == 73) {
            this.bigEnd = false;
        } else if (bar[0] == 77 && bar[1] == 77) {
            this.bigEnd = true;
        } else {
            throw new IOException("Invalid TIFF byte order specification.");
        }
        this.ras.read(bar, 0, 2);
        if (this.bigEnd && bar[1] != 42) {
            throw new IOException("This is not a TIFF file.");
        }
        if (!this.bigEnd && bar[0] != 42) {
            throw new IOException("This is not a TIFF file.");
        }
        int i = 0;
        while (i < 4) {
            theBytes[i] = this.ras.read();
            ++i;
        }
        this.ifdOffset = this.calcInt32(theBytes);
    }

    public void readIfd() throws IOException {
        int[] theBytes = new int[5];
        this.ras.seek(this.ifdOffset);
        SLogger.debug("IFD Offset = " + Long.toHexString(this.ifdOffset));
        int i = 0;
        while (i < 2) {
            theBytes[i] = this.ras.read();
            ++i;
        }
        int numEntries = this.calcInt16(theBytes);
        SLogger.debug("IFD Entries = " + numEntries);
        int j = 0;
        while (j < numEntries) {
            long value;
            i = 0;
            while (i < 2) {
                theBytes[i] = this.ras.read();
                ++i;
            }
            int tag = this.calcInt16(theBytes);
            i = 0;
            while (i < 2) {
                theBytes[i] = this.ras.read();
                ++i;
            }
            int type = this.calcInt16(theBytes);
            i = 0;
            while (i < 4) {
                theBytes[i] = this.ras.read();
                ++i;
            }
            int numVal = (int)this.calcInt32(theBytes);
            SLogger.debug("Number of values = " + numVal + ", Type = " + type);
            if (type == 3 && numVal <= 2) {
                i = 0;
                while (i < 2) {
                    theBytes[i] = this.ras.read();
                    ++i;
                }
                value = this.calcInt16(theBytes);
                i = 0;
                while (i < 2) {
                    theBytes[i] = this.ras.read();
                    ++i;
                }
            } else {
                i = 0;
                while (i < 4) {
                    theBytes[i] = this.ras.read();
                    ++i;
                }
                value = this.calcInt32(theBytes);
            }
            switch (tag) {
                case 256: {
                    this.width = (int)value;
                    SLogger.debug("Img width = " + this.width);
                    break;
                }
                case 257: {
                    this.len = (int)value;
                    SLogger.debug("Img length = " + this.len);
                    break;
                }
                case 258: {
                    if (numVal == 1) {
                        this.bitsPerSamp = (int)value;
                        SLogger.debug("Bits per sample = " + this.bitsPerSamp);
                        break;
                    }
                    long newOffset = value;
                    long curOffset = this.ras.getFilePointer();
                    this.ras.seek(newOffset);
                    i = 0;
                    while (i < 2) {
                        theBytes[i] = this.ras.read();
                        ++i;
                    }
                    this.bitsPerSamp = this.calcInt16(theBytes);
                    SLogger.debug("Bits per sample = " + this.bitsPerSamp);
                    this.ras.seek(curOffset);
                    break;
                }
                case 259: {
                    this.compression = (int)value;
                    SLogger.debug("Compression = " + this.compression);
                    break;
                }
                case 262: {
                    this.photometric = (int)value;
                    SLogger.debug("Photometric Interpretation = " + this.photometric);
                    break;
                }
                case 273: {
                    this.stripOffsets = new long[numVal];
                    SLogger.debug("Number of Strip Offsets = " + numVal);
                    if (numVal == 1) {
                        this.stripOffsets[0] = value;
                        SLogger.debug("Strip Offset[0] = " + this.stripOffsets[0]);
                        break;
                    }
                    long newOffset = value;
                    long curOffset = this.ras.getFilePointer();
                    this.ras.seek(newOffset);
                    int k = 0;
                    while (k < numVal) {
                        if (type == 3) {
                            i = 0;
                            while (i < 2) {
                                theBytes[i] = this.ras.read();
                                ++i;
                            }
                            this.stripOffsets[k] = this.calcInt16(theBytes);
                        }
                        if (type == 4) {
                            i = 0;
                            while (i < 4) {
                                theBytes[i] = this.ras.read();
                                ++i;
                            }
                            this.stripOffsets[k] = this.calcInt32(theBytes);
                        }
                        ++k;
                    }
                    this.ras.seek(curOffset);
                    break;
                }
                case 277: {
                    this.sampPerPix = (int)value;
                    SLogger.debug("Samples per Pixel = " + this.sampPerPix);
                    if (this.sampPerPix == 0) {
                        SLogger.debug("Warning guess Samples per Pixel should be 3");
                        this.sampPerPix = 3;
                    }
                    if (this.sampPerPix == 3) {
                        this.imgType = 0;
                    }
                    if (this.sampPerPix != 1) break;
                    this.imgType = 1;
                    break;
                }
                case 278: {
                    this.rowsPerStrip = (int)value;
                    SLogger.debug("Rows Per Strip = " + this.rowsPerStrip);
                    break;
                }
                case 279: {
                    this.stripByteCounts = value;
                    SLogger.debug("Strip Byte Counts = " + this.stripByteCounts);
                    break;
                }
                case 282: {
                    SLogger.debug("X-Resolution found");
                    break;
                }
                case 283: {
                    SLogger.debug("Y-Resolution found");
                    break;
                }
                default: {
                    SLogger.debug("unknown tag = " + tag);
                }
            }
            ++j;
        }
        this.bytesPerRow = this.sampPerPix * this.width * (this.bitsPerSamp / 8);
        SLogger.debug("Bytes per row = " + this.bytesPerRow);
    }

    public void readTiffStrips() throws IOException {
        long pixCount = 0L;
        this.r = new int[this.len][this.width];
        if (this.imgType == 0) {
            this.g = new int[this.len][this.width];
            this.b = new int[this.len][this.width];
        }
        byte[] row = new byte[this.bytesPerRow];
        int[] theBytes = new int[5];
        int rowCount = 0;
        int i = 0;
        int k = 0;
        do {
            int j;
            if (rowCount == 0) {
                this.ras.seek(this.stripOffsets[k]);
            }
            this.ras.read(row);
            pixCount += (long)this.bytesPerRow;
            if (this.imgType == 0) {
                j = 0;
                while (j < this.width) {
                    if (this.bitsPerSamp == 16) {
                        theBytes[0] = row[j * 6] < 0 ? 256 + row[j * 6] : row[j * 6];
                        theBytes[1] = row[j * 6 + 1] < 0 ? 256 + row[j * 6 + 1] : row[j * 6 + 1];
                        this.r[i][j] = this.calcInt16(theBytes);
                        theBytes[0] = row[j * 6 + 2] < 0 ? 256 + row[j * 6 + 2] : row[j * 6 + 2];
                        theBytes[1] = row[j * 6 + 3] < 0 ? 256 + row[j * 6 + 3] : row[j * 6 + 3];
                        this.g[i][j] = this.calcInt16(theBytes);
                        theBytes[0] = row[j * 6 + 4] < 0 ? 256 + row[j * 6 + 4] : row[j * 6 + 4];
                        theBytes[1] = row[j * 6 + 5] < 0 ? 256 + row[j * 6 + 5] : row[j * 6 + 5];
                        this.b[i][j] = this.calcInt16(theBytes);
                    }
                    if (this.bitsPerSamp == 8) {
                        this.r[i][j] = row[j * 3] < 0 ? 256 + row[j * 3] : row[j * 3];
                        this.g[i][j] = row[j * 3 + 1] < 0 ? 256 + row[j * 3 + 1] : row[j * 3 + 1];
                        this.b[i][j] = row[j * 3 + 2] < 0 ? 256 + row[j * 3 + 2] : row[j * 3 + 2];
                    }
                    ++j;
                }
            }
            if (this.imgType == 1) {
                j = 0;
                while (j < this.width) {
                    if (this.bitsPerSamp == 16) {
                        theBytes[0] = row[j * 2] < 0 ? 256 + row[j * 2] : row[j * 2];
                        theBytes[1] = row[j * 2 + 1] < 0 ? 256 + row[j * 2 + 1] : row[j * 2 + 1];
                        this.r[i][j] = this.calcInt16(theBytes);
                    }
                    if (this.bitsPerSamp == 8) {
                        this.r[i][j] = row[j] < 0 ? 256 + row[j] : row[j];
                    }
                    ++j;
                }
            }
            ++i;
            if (++rowCount != this.rowsPerStrip) continue;
            rowCount = 0;
            ++k;
        } while (i < this.len);
        SLogger.debug("Anzahl gelesener Pixel: " + pixCount);
    }

    public int[][] readRow() throws IOException {
        int j;
        long pixCount = 0L;
        int[] theBytes = new int[5];
        byte[] row = new byte[this.bytesPerRow];
        int[][] erg = null;
        if (this.tmpLenCount == this.len) {
            return null;
        }
        if (this.tmpRowCount == 0) {
            this.ras.seek(this.stripOffsets[this.tmpOffsetCount]);
        }
        this.ras.read(row);
        pixCount += (long)this.bytesPerRow;
        if (this.imgType == 0) {
            erg = new int[this.width][3];
            j = 0;
            while (j < this.width) {
                if (this.bitsPerSamp == 16) {
                    theBytes[0] = row[j * 6] < 0 ? 256 + row[j * 6] : row[j * 6];
                    theBytes[1] = row[j * 6 + 1] < 0 ? 256 + row[j * 6 + 1] : row[j * 6 + 1];
                    erg[j][0] = this.calcInt16(theBytes);
                    theBytes[0] = row[j * 6 + 2] < 0 ? 256 + row[j * 6 + 2] : row[j * 6 + 2];
                    theBytes[1] = row[j * 6 + 3] < 0 ? 256 + row[j * 6 + 3] : row[j * 6 + 3];
                    erg[j][1] = this.calcInt16(theBytes);
                    theBytes[0] = row[j * 6 + 4] < 0 ? 256 + row[j * 6 + 4] : row[j * 6 + 4];
                    theBytes[1] = row[j * 6 + 5] < 0 ? 256 + row[j * 6 + 5] : row[j * 6 + 5];
                    erg[j][2] = this.calcInt16(theBytes);
                }
                if (this.bitsPerSamp == 8) {
                    erg[j][0] = row[j * 3] < 0 ? 256 + row[j * 3] : row[j * 3];
                    erg[j][1] = row[j * 3 + 1] < 0 ? 256 + row[j * 3 + 1] : row[j * 3 + 1];
                    erg[j][2] = row[j * 3 + 2] < 0 ? 256 + row[j * 3 + 2] : row[j * 3 + 2];
                }
                ++j;
            }
        }
        if (this.imgType == 1) {
            erg = new int[this.width][1];
            j = 0;
            while (j < this.width) {
                if (this.bitsPerSamp == 16) {
                    theBytes[0] = row[j * 2] < 0 ? 256 + row[j * 2] : row[j * 2];
                    theBytes[1] = row[j * 2 + 1] < 0 ? 256 + row[j * 2 + 1] : row[j * 2 + 1];
                    erg[j][0] = this.calcInt16(theBytes);
                }
                if (this.bitsPerSamp == 8) {
                    erg[j][0] = row[j] < 0 ? 256 + row[j] : row[j];
                }
                ++j;
            }
        }
        ++this.tmpLenCount;
        ++this.tmpRowCount;
        if (this.tmpRowCount == this.rowsPerStrip) {
            this.tmpRowCount = 0;
            ++this.tmpOffsetCount;
        }
        return erg;
    }

    public int getImgType() {
        return this.imgType;
    }

    public int calcInt16(int[] bytes) {
        if (this.bigEnd) {
            return bytes[0] * 256 + bytes[1];
        }
        return bytes[1] * 256 + bytes[0];
    }

    public long calcInt32(int[] bytes) {
        if (this.bigEnd) {
            return bytes[0] * 0x1000000 + bytes[1] * 65536 + bytes[2] * 256 + bytes[3];
        }
        return bytes[3] * 0x1000000 + bytes[2] * 65536 + bytes[1] * 256 + bytes[0];
    }

    public int[] getByteArray(long val) {
        int tmp;
        int[] bar = new int[4];
        bar[3] = tmp = (int)(val / 0x1000000L);
        val -= (long)(tmp * 0x1000000);
        bar[2] = tmp = (int)(val / 65536L);
        val -= (long)(tmp * 65536);
        bar[1] = tmp = (int)(val / 256L);
        bar[0] = (int)(val - (long)(tmp * 256));
        return bar;
    }

    public int[] getByteArray(int val) {
        int tmp;
        int[] bar = new int[2];
        bar[1] = tmp = val / 256;
        bar[0] = val - tmp * 256;
        return bar;
    }

    public int[][] getB() {
        return this.b;
    }

    public void setB(int[][] b) {
        this.b = b;
    }

    public int[][] getG() {
        return this.g;
    }

    public void setG(int[][] g) {
        this.g = g;
    }

    public int[][] getR() {
        return this.r;
    }

    public void setR(int[][] r) {
        this.r = r;
    }

    public int[][] getData() {
        return this.r;
    }

    public int getLen() {
        return this.len;
    }

    public void setLen(int len) {
        this.len = len;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getBitsPerSamp() {
        return this.bitsPerSamp;
    }

    public void setBitsPerSamp(int bitsPerSamp) {
        this.bitsPerSamp = bitsPerSamp;
    }

    public int getSampPerPix() {
        return this.sampPerPix;
    }

    public void setSampPerPix(int sampPerPix) {
        this.sampPerPix = sampPerPix;
    }

    public String getFname() {
        return this.fname;
    }

    public void setFname(String fname) {
        this.fname = fname;
    }
}

